/*
 * Decompiled with CFR 0.152.
 */
package com.kony.middleware.db;

import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.connectors.dataadapter.StorageConnectorUtils;
import com.konylabs.middleware.connectors.dataadapter.StorageDatabaseDetails;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class DatabaseHelper {
    private static final Logger LOGGER = Logger.getLogger(DatabaseHelper.class);
    protected StorageDatabaseDetails storageDatabaseDetails = new StorageDatabaseDetails();

    public DatabaseHelper(StorageDatabaseDetails storageDatabaseDetails) {
        this.storageDatabaseDetails = storageDatabaseDetails;
        this.storageDatabaseDetails.setJdbcURL(this.getJdbcConnectionUrl());
        this.storageDatabaseDetails.setDriverClass(this.getDriver());
    }

    public boolean createDatabase(String databaseName, String databasePassword) {
        boolean createDatabase = true;
        for (String executeQuery : this.getDatabaseCreateQuery(databaseName, databasePassword)) {
            createDatabase &= this.executeSqlQuery(executeQuery);
        }
        return createDatabase;
    }

    public boolean deleteDatabase(String databaseName) throws SQLException {
        return this.executeQuery(this.getDatabaseDeleteQuery(databaseName));
    }

    public abstract Map<String, String> getComponentProperties();

    public abstract Connection getDatabaseConnection() throws SQLException;

    public String getHostIP() {
        return this.storageDatabaseDetails.getHostname();
    }

    public String getPort() {
        return this.storageDatabaseDetails.getPort();
    }

    public abstract boolean executeDatabaseMigrationScripts(String var1, String[] var2, Map<String, String> var3, boolean var4) throws SQLException;

    public abstract Connection getSystemDatabaseConnection() throws SQLException;

    private void safeConnectionClose(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"Unable to close the database connection.", (Throwable)e);
            }
        }
    }

    protected abstract String[] getDatabaseCreateQuery(String var1, String var2);

    protected abstract String getDatabaseDeleteQuery(String var1);

    public abstract String getDriver();

    public ArrayList<String> getMissingFields() {
        ArrayList<String> missingFields = new ArrayList<String>();
        this.addIfNull(missingFields, this.storageDatabaseDetails.getUsername(), "storage_database_username");
        this.addIfNull(missingFields, this.storageDatabaseDetails.getPassword(), "storage_database_password");
        this.addIfNull(missingFields, this.storageDatabaseDetails.getHostname(), "storage_database_hostname");
        this.addIfNull(missingFields, this.storageDatabaseDetails.getPort(), "storage_database_port");
        return missingFields;
    }

    public abstract String getJdbcUrlWithDatabaseName(String var1);

    protected abstract Connection getJdbcConnectionDatabase(String var1) throws SQLException;

    protected abstract String getJdbcConnectionUrl();

    public abstract String getDatabaseType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeQuery(String sqlQuery) throws SQLException {
        boolean bl;
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getSystemDatabaseConnection();
            statement = connection.createStatement();
            bl = !statement.execute(sqlQuery);
        }
        catch (Throwable throwable) {
            Closer.closeQuietly(statement);
            this.safeConnectionClose(connection);
            throw throwable;
        }
        Closer.closeQuietly((AutoCloseable)statement);
        this.safeConnectionClose(connection);
        return bl;
    }

    protected boolean executeSqlQuery(String sqlQuery) {
        boolean result = false;
        try {
            result = this.executeQuery(sqlQuery);
        }
        catch (SQLException e) {
            this.logError(sqlQuery, e);
        }
        this.logExecuteSqlResult(sqlQuery, result);
        return result;
    }

    protected void addIfNull(ArrayList<String> missingFields, String username, String propertyName) {
        if (StringUtils.isBlank((String)username)) {
            missingFields.add(propertyName);
        }
    }

    protected void logExecuteSqlResult(String sqlQuery, boolean result) {
        if (result) {
            LOGGER.info((Object)("Successfully executed: " + sqlQuery));
        } else {
            this.logError(sqlQuery, null);
        }
    }

    protected void logError(String sqlQuery, SQLException e) {
        LOGGER.error((Object)("Exception occurred while executing query: " + sqlQuery), (Throwable)e);
    }

    public String getStorageSchemaName(String appId, String envGuid) {
        return this.getStorageDatabaseName(appId, envGuid);
    }

    public String getStorageDatabaseName(String appId, String envguid) {
        StringBuilder schemaName = new StringBuilder(appId);
        if (StringUtils.isNotBlank((String)envguid)) {
            schemaName.append("_").append(StorageConnectorUtils.getFirstPartFromEnvGUID(envguid));
        }
        return schemaName.toString();
    }

    public StorageDatabaseDetails getStorageDatabaseDetails() {
        return this.storageDatabaseDetails;
    }

    public StorageDatabaseDetails getStorageDatabaseDetails(String appId, String envGuid) {
        StorageDatabaseDetails storageDatabaseDetails = this.getStorageDatabaseDetails();
        String databaseName = this.getStorageDatabaseName(appId, envGuid);
        storageDatabaseDetails.setJdbcURL(this.getJdbcUrlWithDatabaseName(databaseName));
        return storageDatabaseDetails;
    }
}

