/*
 * Decompiled with CFR 0.152.
 */
package com.kony.middleware.db;

import com.kony.middleware.db.DatabaseHelper;
import com.kony.middleware.db.MSSQLDatabaseHelper;
import com.kony.middleware.db.MariaDatabaseHelper;
import com.kony.middleware.db.MySQLDatabaseHelper;
import com.kony.middleware.db.OracleDatabaseHelper;
import com.konylabs.middleware.common.EncryptDecryptText;
import com.konylabs.middleware.common.S3Config;
import com.konylabs.middleware.connectors.dataadapter.StorageDatabaseDetails;
import com.konylabs.middleware.connectors.dataadapter.StorageProperties;
import com.konylabs.middleware.environment.EnvironmentFactory;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.math.NumberUtils;

public final class DatabaseHelperFactory {
    private static final int ADMIN_DB_USED_CONNECTIONS = 10;

    public static DatabaseHelper createDatabaseHelper(String databaseType, String hostname, String port, String username, String password, String dbinstance, String defaultSchemaName, int maxConnections, long connectionTimeout) {
        StorageDatabaseDetails storageDatabaseDetails = new StorageDatabaseDetails();
        storageDatabaseDetails.setDatabaseType(databaseType);
        storageDatabaseDetails.setHostname(hostname);
        storageDatabaseDetails.setInstanceName(dbinstance);
        storageDatabaseDetails.setPassword(password);
        storageDatabaseDetails.setPort(port);
        storageDatabaseDetails.setUsername(username);
        storageDatabaseDetails.setMaxConnections(maxConnections);
        storageDatabaseDetails.setConnectionTimeout(TimeUnit.SECONDS.toMillis(connectionTimeout));
        return DatabaseHelperFactory.createDatabaseHelper(storageDatabaseDetails, defaultSchemaName);
    }

    public static StorageDatabaseDetails populateStorageDatabaseDetails() {
        int maxConnections;
        long connectionTimeout = 30L;
        StorageDatabaseDetails storageDatabaseDetails = new StorageDatabaseDetails();
        if (MiddlewareUtils.isAmazonS3Support()) {
            String connTimeoutValue;
            storageDatabaseDetails.setDatabaseType("mysql");
            storageDatabaseDetails.setHostname(ConfigUtility.getProperty((String)S3Config.RDS_HOSTNAME.name()));
            storageDatabaseDetails.setPort(ConfigUtility.getProperty((String)S3Config.RDS_PORT.name()));
            storageDatabaseDetails.setUsername(ConfigUtility.getProperty((String)S3Config.JDBC_DEVICEDB_USER.name()));
            storageDatabaseDetails.setPassword(ConfigUtility.getProperty((String)S3Config.JDBC_DEVICEDB_PASSWORD.name()));
            String maxActiveValue = ConfigUtility.getProperty((String)S3Config.MAX_ACTIVE_DBC.name());
            maxConnections = 5;
            if (NumberUtils.isNumber((String)maxActiveValue)) {
                maxConnections = Integer.parseInt(maxActiveValue) / EnvironmentFactory.getEnvironment().getNumberOfNodes();
                if ((maxConnections -= 10) <= 0) {
                    maxConnections = 5;
                }
            }
            if (NumberUtils.isNumber((String)(connTimeoutValue = ConfigUtility.getProperty((String)S3Config.RDS_CONNECTION_TIMEOUT.name())))) {
                connectionTimeout = Long.parseLong(connTimeoutValue);
            }
        } else {
            storageDatabaseDetails.setDatabaseType((String)StorageProperties.DB_TYPE.getFromConfig());
            storageDatabaseDetails.setHostname((String)StorageProperties.DB_HOSTNAME.getFromConfig());
            storageDatabaseDetails.setPort((String)StorageProperties.DB_PORT.getFromConfig());
            storageDatabaseDetails.setUsername((String)StorageProperties.DB_USERNAME.getFromConfig());
            storageDatabaseDetails.setPassword(EncryptDecryptText.decryptText((String)((String)StorageProperties.DB_PASSWORD.getFromConfig())));
            storageDatabaseDetails.setInstanceName((String)StorageProperties.DB_INSTANCE.getFromConfig());
            storageDatabaseDetails.setDataTablespace((String)StorageProperties.DATA_TABLESPACE.getFromConfig());
            storageDatabaseDetails.setIndexTablespace((String)StorageProperties.INDEX_TABLESPACE.getFromConfig());
            storageDatabaseDetails.setLobTablespace((String)StorageProperties.LOB_TABLESPACE.getFromConfig());
            maxConnections = (Integer)StorageProperties.DB_MAX_CONNECTIONS.getFromConfig();
            connectionTimeout = (Long)StorageProperties.DB_CONNECTION_TIMEOUT_IN_SECS.getFromConfig();
        }
        storageDatabaseDetails.setMaxConnections(maxConnections);
        storageDatabaseDetails.setConnectionTimeout(TimeUnit.SECONDS.toMillis(connectionTimeout));
        return storageDatabaseDetails;
    }

    public static DatabaseHelper createDatabaseHelper() {
        StorageDatabaseDetails storageDatabaseDetails = DatabaseHelperFactory.populateStorageDatabaseDetails();
        return DatabaseHelperFactory.createDatabaseHelper(storageDatabaseDetails);
    }

    public static DatabaseHelper createDatabaseHelper(StorageDatabaseDetails storageDatabaseDetails) {
        String defaultSchema = (String)StorageProperties.SQLSERVER_DEFAULT_SCHEMA.getFromConfig();
        return DatabaseHelperFactory.createDatabaseHelper(storageDatabaseDetails, defaultSchema);
    }

    private static DatabaseHelper createDatabaseHelper(StorageDatabaseDetails storageDatabaseDetails, String defaultSchemaName) {
        String dbType = storageDatabaseDetails.getDatabaseType();
        if ("mysql".equalsIgnoreCase(dbType)) {
            return new MySQLDatabaseHelper(storageDatabaseDetails);
        }
        if ("mariadb".equalsIgnoreCase(dbType)) {
            return new MariaDatabaseHelper(storageDatabaseDetails);
        }
        if ("sqlserver".equalsIgnoreCase(dbType)) {
            return new MSSQLDatabaseHelper(storageDatabaseDetails, defaultSchemaName);
        }
        if ("oracle".equalsIgnoreCase(dbType)) {
            return new OracleDatabaseHelper(storageDatabaseDetails);
        }
        throw new IllegalArgumentException("configured database type not supported for storage service");
    }

    public static boolean isSupportedDatabase(String dbType) {
        return "mysql".equalsIgnoreCase(dbType) || "mariadb".equalsIgnoreCase(dbType) || "sqlserver".equalsIgnoreCase(dbType) || "oracle".equalsIgnoreCase(dbType);
    }

    private DatabaseHelperFactory() {
    }
}

