/*
 * Decompiled with CFR 0.152.
 */
package com.kony.middleware.db;

import com.konylabs.middleware.connectors.dataadapter.StorageConnectorUtils;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.flywaydb.core.Flyway;

public final class DatabaseMigrationHelper {
    private static final Logger LOGGER = Logger.getLogger(DatabaseMigrationHelper.class);

    public static boolean executeFlywayMigrate(String connectionUrl, String username, String password, String scriptLocation, String[] databaseNames, Map<String, String> componentProperties, boolean validateOnMigrate) throws SQLException {
        LOGGER.info((Object)("Database schemas for migration are :" + Arrays.toString(databaseNames)));
        try {
            Flyway flyway = StorageConnectorUtils.getFlyway(connectionUrl, username, password, databaseNames[0], scriptLocation);
            DatabaseMigrationHelper.doExecute(componentProperties, validateOnMigrate, flyway);
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"Database migration failed.", (Throwable)e);
            throw new SQLException(e);
        }
        LOGGER.info((Object)("Finished migration on databases " + Arrays.toString(databaseNames)));
        return true;
    }

    public static void executeFlywayMigrate(DataSource dataSource, String scriptLocation, Map<String, String> componentProperties, boolean validateOnMigrate, String schema) throws SQLException {
        LOGGER.info((Object)"Executing flyway migrations");
        try {
            Flyway flyway = new Flyway();
            flyway.setDataSource(dataSource);
            flyway.setSchemas(new String[]{schema});
            if (StringUtils.isNotBlank((String)scriptLocation)) {
                flyway.setLocations(new String[]{"filesystem:" + scriptLocation});
            }
            DatabaseMigrationHelper.doExecute(componentProperties, validateOnMigrate, flyway);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Database migration failed.", (Throwable)ex);
            throw new SQLException(ex);
        }
        LOGGER.info((Object)"Finished migration on databases ");
    }

    private static void doExecute(Map<String, String> componentProperties, boolean validateOnMigrate, Flyway flyway) {
        if (componentProperties != null) {
            flyway.setPlaceholders(componentProperties);
        }
        flyway.setValidateOnMigrate(validateOnMigrate);
        flyway.repair();
        int migrationsDone = flyway.migrate();
        LOGGER.info((Object)("Successfully migrated " + migrationsDone + "scripts"));
    }

    private DatabaseMigrationHelper() {
    }
}

