/*
 * Decompiled with CFR 0.152.
 */
package com.kony.middleware.db;

import com.kony.middleware.db.DatabaseHelper;
import com.kony.middleware.db.DatabaseMigrationHelper;
import com.konylabs.middleware.connectors.dataadapter.StorageConnectorUtils;
import com.konylabs.middleware.connectors.dataadapter.StorageDatabaseDetails;
import com.konylabs.middleware.connectors.dataadapter.StorageProperties;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

class MSSQLDatabaseHelper
extends DatabaseHelper {
    private static final Logger LOGGER = Logger.getLogger(MSSQLDatabaseHelper.class);
    private String defaultSchema = null;

    public MSSQLDatabaseHelper(StorageDatabaseDetails storageDatabaseDetails, String schemaName) {
        super(storageDatabaseDetails);
        this.defaultSchema = schemaName;
    }

    @Override
    public boolean executeDatabaseMigrationScripts(String scriptLocation, String[] databaseNames, Map<String, String> componentProperties, boolean validateOnMigrate) throws SQLException {
        return DatabaseMigrationHelper.executeFlywayMigrate(this.getConnectionUrl(databaseNames), this.getStorageDatabaseDetails().getUsername(), this.getStorageDatabaseDetails().getPassword(), scriptLocation, databaseNames, componentProperties, validateOnMigrate);
    }

    @Override
    public Connection getDatabaseConnection() throws SQLException {
        try {
            Class.forName(this.getDriver());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Error while fetching MSSQL class object.", (Throwable)e);
        }
        return DriverManager.getConnection(this.getJdbcConnectionUrl(), this.getStorageDatabaseDetails().getUsername(), this.getStorageDatabaseDetails().getPassword());
    }

    @Override
    public Connection getSystemDatabaseConnection() throws SQLException {
        try {
            Class.forName(this.getDriver());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Error while fetching MSSQL class object.", (Throwable)e);
        }
        return DriverManager.getConnection(this.getConnectionUrl(), this.getStorageDatabaseDetails().getUsername(), this.getStorageDatabaseDetails().getPassword());
    }

    @Override
    protected String[] getDatabaseCreateQuery(String databaseName, String databasePassword) {
        return new String[]{String.format(this.getIfNotExistsQuery(databaseName) + this.getCreateDatabaseQuery(databaseName), new Object[0])};
    }

    private String getCreateDatabaseQuery(String databaseName) {
        return String.format(" CREATE DATABASE [%s]", databaseName);
    }

    private String getIfNotExistsQuery(String databaseName) {
        return String.format("IF NOT EXISTS (" + this.getSelectQuery(databaseName) + ")", databaseName);
    }

    private String getSelectQuery(String databaseName) {
        return String.format("SELECT name FROM master.dbo.sysdatabases WHERE name='%s'", databaseName);
    }

    @Override
    protected String getDatabaseDeleteQuery(String databaseName) {
        return String.format("DROP DATABASE %s", databaseName);
    }

    @Override
    public String getDriver() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    @Override
    protected Connection getJdbcConnectionDatabase(String databaseName) throws SQLException {
        try {
            Class.forName(this.getDriver());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Error while fetching MSSQL class object.", (Throwable)e);
        }
        return DriverManager.getConnection(this.getDatabaseConnectionUrl(databaseName), this.getStorageDatabaseDetails().getUsername(), this.getStorageDatabaseDetails().getPassword());
    }

    @Override
    protected String getJdbcConnectionUrl() {
        return this.getDatabaseConnectionUrl("master");
    }

    private String getDatabaseConnectionUrl(String databaseName) {
        String connectionURL = String.format("jdbc:sqlserver://%s:%s;" + (this.storageDatabaseDetails.getInstanceName() == "" ? "" : "instanceName=" + this.storageDatabaseDetails.getInstanceName() + ";") + "databaseName=%s", this.getHostIP(), this.getPort(), databaseName);
        return this.updateURLIfWindowsAuthenticated(connectionURL);
    }

    private String updateURLIfWindowsAuthenticated(String connectionURL) {
        boolean isWindowsAuth = (Boolean)StorageProperties.IS_WINDOWS_AUTH.getFromConfig();
        if (isWindowsAuth) {
            connectionURL = connectionURL.concat(";integratedSecurity=true");
        }
        return connectionURL;
    }

    private String getConnectionUrl() {
        String connectionURL = String.format("jdbc:sqlserver://%s:%s", this.getHostIP(), this.getPort());
        return this.updateURLIfWindowsAuthenticated(connectionURL);
    }

    private String getConnectionUrl(String[] databaseNames) {
        return this.getDatabaseConnectionUrl(databaseNames[0]);
    }

    @Override
    public String getJdbcUrlWithDatabaseName(String databaseName) {
        return this.getDatabaseConnectionUrl(databaseName);
    }

    @Override
    public String getDatabaseType() {
        return StorageConnectorUtils.StorageDatabaseType.sqlserver.name();
    }

    @Override
    public String getStorageSchemaName(String appId, String envGuid) {
        return this.defaultSchema;
    }

    @Override
    public Map<String, String> getComponentProperties() {
        HashMap<String, String> componentProperties = new HashMap<String, String>();
        componentProperties.put(StorageConnectorUtils.StoragePlaceHoldersEnum.KONY_STORAGE_SQLSERVER_DEFAULT_SCHEMA.name(), this.defaultSchema);
        return componentProperties;
    }
}

