/*
 * Decompiled with CFR 0.152.
 */
package com.kony.middleware.db;

import com.kony.middleware.db.DatabaseHelper;
import com.kony.middleware.db.DatabaseMigrationHelper;
import com.konylabs.middleware.connectors.dataadapter.StorageConnectorUtils;
import com.konylabs.middleware.connectors.dataadapter.StorageDatabaseDetails;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

class MySQLDatabaseHelper
extends DatabaseHelper {
    private static final Logger LOGGER = Logger.getLogger(MySQLDatabaseHelper.class);

    public MySQLDatabaseHelper(StorageDatabaseDetails storageDatabaseDetails) {
        super(storageDatabaseDetails);
    }

    @Override
    public boolean executeDatabaseMigrationScripts(String scriptLocation, String[] databaseNames, Map<String, String> componentProperties, boolean validateOnMigrate) throws SQLException {
        return DatabaseMigrationHelper.executeFlywayMigrate(this.getJdbcConnectionUrl(), this.getStorageDatabaseDetails().getUsername(), this.getStorageDatabaseDetails().getPassword(), scriptLocation, databaseNames, componentProperties, validateOnMigrate);
    }

    @Override
    public Connection getDatabaseConnection() throws SQLException {
        try {
            Class.forName(this.getDriver());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Error while fetching MySQL class object.", (Throwable)e);
        }
        return DriverManager.getConnection(this.getJdbcConnectionUrl(), this.getStorageDatabaseDetails().getUsername(), this.getStorageDatabaseDetails().getPassword());
    }

    @Override
    public Connection getSystemDatabaseConnection() throws SQLException {
        try {
            Class.forName(this.getDriver());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Error while fetching MySQL class object.", (Throwable)e);
        }
        return DriverManager.getConnection(this.getJdbcConnectionUrl(), this.getStorageDatabaseDetails().getUsername(), this.getStorageDatabaseDetails().getPassword());
    }

    @Override
    protected String[] getDatabaseCreateQuery(String databaseName, String databasePassword) {
        return new String[]{String.format("CREATE DATABASE IF NOT EXISTS %s CHARACTER SET utf8 COLLATE utf8_unicode_ci", databaseName)};
    }

    @Override
    protected String getDatabaseDeleteQuery(String databaseName) {
        return String.format("DROP DATABASE %s", databaseName);
    }

    @Override
    public String getDriver() {
        return "com.mysql.jdbc.Driver";
    }

    @Override
    protected Connection getJdbcConnectionDatabase(String databaseName) throws SQLException {
        try {
            Class.forName(this.getDriver());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Error while fetching MySQL class object.", (Throwable)e);
        }
        return DriverManager.getConnection(String.format("jdbc:mysql://%s:%s/%s", this.getHostIP(), this.getPort(), databaseName), this.getStorageDatabaseDetails().getUsername(), this.getStorageDatabaseDetails().getPassword());
    }

    @Override
    public String getJdbcConnectionUrl() {
        return String.format("jdbc:mysql://%s:%s", this.getHostIP(), this.getPort());
    }

    @Override
    public String getJdbcUrlWithDatabaseName(String databaseName) {
        return this.getJdbcConnectionUrl();
    }

    @Override
    public String getDatabaseType() {
        return StorageConnectorUtils.StorageDatabaseType.mysql.name();
    }

    @Override
    public Map<String, String> getComponentProperties() {
        return null;
    }
}

