/*
 * Decompiled with CFR 0.152.
 */
package com.kony.middleware.db;

import com.kony.middleware.db.DatabaseHelper;
import com.kony.middleware.db.DatabaseMigrationHelper;
import com.konylabs.middleware.connectors.dataadapter.StorageConnectorUtils;
import com.konylabs.middleware.connectors.dataadapter.StorageDatabaseDetails;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

class OracleDatabaseHelper
extends DatabaseHelper {
    private static final Logger LOGGER = Logger.getLogger(OracleDatabaseHelper.class);

    public OracleDatabaseHelper(StorageDatabaseDetails storageDatabaseDetails) {
        super(storageDatabaseDetails);
    }

    @Override
    public boolean executeDatabaseMigrationScripts(String scriptLocation, String[] databaseNames, Map<String, String> componentProperties, boolean validateOnMigrate) throws SQLException {
        return DatabaseMigrationHelper.executeFlywayMigrate(this.getJdbcConnectionUrl(), this.getStorageDatabaseDetails().getUsername(), this.getStorageDatabaseDetails().getPassword(), scriptLocation, databaseNames, componentProperties, validateOnMigrate);
    }

    @Override
    public Connection getDatabaseConnection() throws SQLException {
        try {
            Class.forName(this.getDriver());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Error while fetching Oracle class object.", (Throwable)e);
        }
        return DriverManager.getConnection(this.getJdbcConnectionUrl(), this.getStorageDatabaseDetails().getUsername(), this.getStorageDatabaseDetails().getPassword());
    }

    @Override
    public Connection getSystemDatabaseConnection() throws SQLException {
        try {
            Class.forName(this.getDriver());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Error while fetching Oracle class object.", (Throwable)e);
        }
        return this.getDatabaseConnection();
    }

    @Override
    protected String[] getDatabaseCreateQuery(String databaseName, String databasePassword) {
        return new String[]{this.getCreateUserQuery(databaseName, databasePassword), this.getAlterUserOnDataTableSpaceQuery(databaseName), this.getAlterUserOnIndexTableSpaceQuery(databaseName), this.getAlterUserOnLOBTableSpaceQuery(databaseName), this.getAlterUserOnUserTableSpaceQuery(databaseName), this.getGrantUserConnectResoureceAndViewPrivilegesQuery(databaseName)};
    }

    @Override
    protected String getDatabaseDeleteQuery(String databaseName) {
        return String.format("DROP USER \"%s\" CASCADE", databaseName);
    }

    @Override
    public String getDriver() {
        return "oracle.jdbc.driver.OracleDriver";
    }

    @Override
    protected Connection getJdbcConnectionDatabase(String databaseName) throws SQLException {
        try {
            Class.forName(this.getDriver());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Error while fetching Oracle class object.", (Throwable)e);
        }
        return DriverManager.getConnection(this.getJdbcConnectionUrl(), databaseName, this.getStorageDatabaseDetails().getPassword());
    }

    @Override
    protected boolean executeSqlQuery(String sqlQuery) {
        boolean result = false;
        try {
            result = this.executeQuery(sqlQuery);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"Creation of database user failed.", (Throwable)e);
        }
        this.logExecuteSqlResult(sqlQuery, result);
        return result;
    }

    @Override
    protected void logExecuteSqlResult(String sqlQuery, boolean result) {
        if (result) {
            LOGGER.info((Object)"Successfully executed create user query.");
        } else {
            LOGGER.error((Object)"Failed to execute create user query.");
        }
    }

    @Override
    public String getJdbcConnectionUrl() {
        return String.format("jdbc:oracle:thin:@%s:%s/%s", this.getHostIP(), this.getPort(), this.storageDatabaseDetails.getInstanceName());
    }

    private String getCreateUserQuery(String databaseName, String databasePassword) {
        return String.format("CREATE USER \"%s\" identified by \"%s\"", databaseName, databasePassword);
    }

    private String getAlterUserOnDataTableSpaceQuery(String databaseName) {
        return String.format("ALTER USER \"%s\" QUOTA UNLIMITED ON %s", databaseName, this.getStorageDatabaseDetails().getDataTablespace());
    }

    private String getAlterUserOnUserTableSpaceQuery(String databaseName) {
        return String.format("ALTER USER \"%s\" QUOTA UNLIMITED ON USERS", databaseName);
    }

    private String getAlterUserOnIndexTableSpaceQuery(String databaseName) {
        return String.format("ALTER USER \"%s\" QUOTA UNLIMITED ON %s", databaseName, this.getStorageDatabaseDetails().getIndexTablespace());
    }

    private String getAlterUserOnLOBTableSpaceQuery(String databaseName) {
        return String.format("ALTER USER \"%s\" QUOTA UNLIMITED ON %s", databaseName, this.getStorageDatabaseDetails().getLobTablespace());
    }

    private String getGrantUserConnectResoureceAndViewPrivilegesQuery(String databaseName) {
        return String.format("GRANT CONNECT,RESOURCE,CREATE VIEW TO \"%s\"", databaseName);
    }

    @Override
    public String getJdbcUrlWithDatabaseName(String databaseName) {
        return this.getJdbcConnectionUrl();
    }

    @Override
    public String getDatabaseType() {
        return StorageConnectorUtils.StorageDatabaseType.oracle.name();
    }

    @Override
    public Map<String, String> getComponentProperties() {
        HashMap<String, String> componentProperties = new HashMap<String, String>();
        componentProperties.put(StorageConnectorUtils.StoragePlaceHoldersEnum.KONY_STORAGE_DATA_TABLESPACE.name(), this.getStorageDatabaseDetails().getDataTablespace());
        componentProperties.put(StorageConnectorUtils.StoragePlaceHoldersEnum.KONY_STORAGE_INDEX_TABLESPACE.name(), this.getStorageDatabaseDetails().getIndexTablespace());
        componentProperties.put(StorageConnectorUtils.StoragePlaceHoldersEnum.KONY_STORAGE_LOB_TABLESPACE.name(), this.getStorageDatabaseDetails().getLobTablespace());
        return componentProperties;
    }

    @Override
    public ArrayList<String> getMissingFields() {
        ArrayList<String> missingFields = super.getMissingFields();
        this.addIfNull(missingFields, this.storageDatabaseDetails.getInstanceName(), "storage_database_instance");
        return missingFields;
    }

    @Override
    protected void logError(String sqlQuery, SQLException e) {
        LOGGER.error((Object)"Creation of database user failed.", (Throwable)e);
    }
}

