/*
 * Decompiled with CFR 0.152.
 */
package com.kony.scrapper.gc;

import com.kony.scrapper.gc.ScraperException;
import com.konylabs.middleware.registry.vo.Dataset;
import com.konylabs.middleware.registry.vo.Param;
import com.konylabs.middleware.utilities.EncodeUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.sax.HtmlParser;
import nu.validator.htmlparser.sax.XmlSerializer;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public final class ScrapperHelper {
    private static final Logger LOGGER = Logger.getLogger(ScrapperHelper.class);

    private ScrapperHelper() {
    }

    public static Dataset mainConvertHashToDataset(Map inputHash) {
        Dataset dataset = ScrapperHelper.convertHashToDataset(inputHash);
        if (inputHash.containsKey("innerrecord")) {
            List innerrecord = (List)inputHash.get("innerrecord");
            ArrayList<Dataset> arraydataset = new ArrayList<Dataset>();
            int innerrecordSize = innerrecord.size();
            if (innerrecordSize > 0) {
                for (int i = 0; i < innerrecordSize; ++i) {
                    Map inrec = (Map)innerrecord.get(i);
                    Dataset innerdataset = ScrapperHelper.convertHashToDataset(inrec);
                    arraydataset.add(innerdataset);
                }
                dataset.setDatasets(arraydataset);
            }
        }
        return dataset;
    }

    public static Dataset convertHashToDataset(Map inputHash) {
        String mainKey = inputHash.get("recid").toString();
        Dataset dataset = new Dataset();
        dataset.setSource(inputHash.get("xpath").toString());
        dataset.setId(mainKey);
        List recordFields = (List)inputHash.get("fields");
        int recordFieldsLength = recordFields.size();
        if (recordFieldsLength > 0) {
            ArrayList<Param> params = new ArrayList<Param>();
            for (int i = 0; i < recordFieldsLength; ++i) {
                Map field = (Map)recordFields.get(i);
                String name = field.get("fldname").toString();
                String source = field.get("xpath").toString();
                params.add(ScrapperHelper.getKonyParam(name, source));
            }
            dataset.setParams(params);
        }
        return dataset;
    }

    private static Param getKonyParam(String name, String value) {
        Param param = new Param();
        param.setName(name);
        param.setSource(value);
        return param;
    }

    public static String convertHTML2XML(String inputFileContent) throws ScraperException {
        ByteArrayInputStream in = null;
        OutputStream out = null;
        try {
            in = new ByteArrayInputStream(EncodeUtils.getBytes((String)inputFileContent));
            out = new ByteArrayOutputStream();
            XmlSerializer serializer = new XmlSerializer(out);
            HtmlParser parser = new HtmlParser(XmlViolationPolicy.ALTER_INFOSET);
            parser.setContentHandler((ContentHandler)serializer);
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", (Object)serializer);
            parser.parse(new InputSource(in));
            String string = EncodeUtils.getString((byte[])((ByteArrayOutputStream)out).toByteArray());
            return string;
        }
        catch (Exception e) {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    out.flush();
                    ((ByteArrayOutputStream)out).close();
                }
            }
            catch (Exception e1) {
                LOGGER.error((Object)e, (Throwable)e);
            }
            throw new ScraperException("11132", e.getMessage(), e);
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    out.flush();
                    ((ByteArrayOutputStream)out).close();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e, (Throwable)e);
            }
        }
    }

    public static String convertDoc2xml(Document doc) {
        String xmlString = "";
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            transfac.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            NodeList list = doc.getElementsByTagName("body");
            Node node = list.item(0);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(node);
            trans.transform(source, result);
            xmlString = sw.toString();
        }
        catch (Exception e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        return xmlString;
    }
}

