/*
 * Decompiled with CFR 0.152.
 */
package com.kony.scrapper.gc;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.kony.scrapper.gc.ScraperException;
import com.kony.scrapper.gc.ScrapperHelper;
import com.kony.scrapper.gc.ScrapperMain;
import com.kony.scrapper.gc.ScrapperUtil;
import com.kony.scrapper.gc.ServiceDSL;
import com.kony.scrapper.gc.UrlUtil;
import com.kony.scrapper.gc.XmlUtils;
import com.konylabs.middleware.connectors.XPathEngine;
import com.konylabs.middleware.connectors.XPathEngineImpl;
import com.konylabs.middleware.connectors.XPathUtil;
import com.konylabs.middleware.dataobject.Param;
import com.konylabs.middleware.dataobject.Record;
import com.konylabs.middleware.registry.vo.Dataset;
import com.konylabs.middleware.utilities.EncodeUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScrapperLogic {
    private static final Logger LOGGER = Logger.getLogger(ScrapperLogic.class);
    protected static final String NEW_PARSING_DATASET_KEY_PREFIX = "newparsingdataset";
    protected static final String PARSING_DATASET_KEY_PREFIX = "parsingdataset";
    static final String context_reset_id = "{{reset}}";
    private static String channel_seperator_string = "\n";
    private static final String reg_index_expr = "\\[(\\d+)\\]";

    public static String evaluateField(HashMap fld, Object startctx, Boolean expr_possible) throws ScraperException {
        int idx;
        Pattern p;
        Matcher m;
        String result = "";
        String xpath = (String)fld.get("xpath");
        if (!expr_possible.booleanValue()) {
            NodeList res = null;
            try {
                res = XmlUtils.evalXPath(xpath, (Node)startctx);
            }
            catch (Exception e) {
                throw new ScraperException("11131", e.toString() + " problem in X-Path : " + xpath, e);
            }
            if (res != null && res.getLength() > 0) {
                result = res.item(0).getTextContent().trim();
            }
        } else if ((xpath = xpath.trim()).startsWith("[") && (m = (p = Pattern.compile(reg_index_expr)).matcher(xpath)).matches() && (idx = Integer.parseInt(m.group(1))) < ((NodeList)startctx).getLength()) {
            result = ((NodeList)startctx).item(idx).getTextContent().trim();
        }
        return result;
    }

    private static HashMap evaluate_context(HashMap ctx, Object node) throws ScraperException {
        Object curcontext;
        Boolean expr_possible;
        HashMap result = new HashMap();
        List fields = (List)ctx.get("fields");
        String xpath = (String)ctx.get("xpath");
        if (xpath.equals(context_reset_id)) {
            expr_possible = false;
            curcontext = node;
        } else {
            expr_possible = true;
            try {
                curcontext = XmlUtils.evalXPath(xpath, (Node)node);
            }
            catch (Exception e) {
                throw new ScraperException("11131", " problem in X-Path : " + xpath, e);
            }
        }
        for (Object f : fields) {
            result.put(((HashMap)f).get("fldname"), ScrapperLogic.evaluateField((HashMap)f, curcontext, expr_possible));
        }
        return result;
    }

    private static List evaluate_innerrecord(HashMap rec, Node doc) throws ScraperException {
        ArrayList<Object> result;
        block8: {
            result = new ArrayList<Object>();
            String xpstr = (String)rec.get("xpath");
            NodeList rowsets = null;
            try {
                rowsets = XmlUtils.evalXPath(xpstr, doc);
            }
            catch (Exception e) {
                throw new ScraperException("11131", " problem in X-Path :" + xpstr, e);
            }
            int rowsets_length = rowsets.getLength();
            if (rowsets_length <= 0) break block8;
            List fields = (List)rec.get("fields");
            List contexts = (List)rec.get("contexts");
            if (fields.size() == 0 && contexts.size() == 0) {
                for (int i = 0; i < rowsets.getLength(); ++i) {
                    result.add(rowsets.item(i).getTextContent().trim());
                }
            } else {
                for (int i = 0; i < rowsets.getLength(); ++i) {
                    Object res;
                    HashMap h = new HashMap();
                    for (Object f : fields) {
                        res = "";
                        res = ScrapperLogic.evaluateField((HashMap)f, rowsets.item(i), false);
                        h.put(((HashMap)f).get("fldname"), res);
                    }
                    for (Object c : contexts) {
                        res = ScrapperLogic.evaluate_context((HashMap)c, rowsets.item(i));
                        h.putAll(res);
                    }
                    result.add(h);
                }
            }
        }
        return result;
    }

    private static List evaluate_record(HashMap rec, Document doc) throws ScraperException {
        ArrayList result = new ArrayList();
        String xpstr = (String)rec.get("xpath");
        NodeList rowsets = null;
        try {
            rowsets = XmlUtils.evalXPath(xpstr, doc);
        }
        catch (Exception e) {
            throw new ScraperException("11131", " problem in X-Path : " + xpstr, e);
        }
        if (rowsets != null && rowsets.getLength() > 0) {
            List fields = (List)rec.get("fields");
            List contexts = (List)rec.get("contexts");
            List innerrecord = (List)rec.get("innerrecord");
            if (fields.size() != 0 || contexts.size() != 0 || innerrecord.size() != 0) {
                for (int i = 0; i < rowsets.getLength(); ++i) {
                    Object res;
                    HashMap<Object, Object> h = new HashMap<Object, Object>();
                    for (Object f : fields) {
                        res = ScrapperLogic.evaluateField((HashMap)f, rowsets.item(i), false);
                        h.put(((HashMap)f).get("fldname"), res);
                    }
                    for (Object c : contexts) {
                        res = ScrapperLogic.evaluate_context((HashMap)c, rowsets.item(i));
                        h.putAll((Map<Object, Object>)res);
                    }
                    int innerrecord_size = innerrecord.size();
                    if (innerrecord_size > 0) {
                        HashMap<String, List> put_data = new HashMap<String, List>();
                        for (int c = 0; c < innerrecord_size; ++c) {
                            List inner_rec = ScrapperLogic.evaluate_innerrecord((HashMap)innerrecord.get(c), rowsets.item(i));
                            String inner_rec_name = (String)((HashMap)innerrecord.get(c)).get("recid");
                            put_data.put(inner_rec_name, inner_rec);
                            h.put("innerrecord", put_data);
                        }
                    }
                    result.add(h);
                }
            }
        }
        return result;
    }

    private static List evaluateRecord(HashMap rec, XPathEngine xPathEngine) throws ScraperException {
        ArrayList<List<com.konylabs.middleware.dataobject.Dataset>> result = new ArrayList<List<com.konylabs.middleware.dataobject.Dataset>>();
        Dataset sdataset = ScrapperHelper.mainConvertHashToDataset(rec);
        ArrayList<Dataset> datasetArray = new ArrayList<Dataset>();
        datasetArray.add(sdataset);
        try {
            List<com.konylabs.middleware.dataobject.Dataset> final_rec = xPathEngine.fillDatasets(datasetArray);
            result.add(final_rec);
            return result;
        }
        catch (Exception e) {
            throw new ScraperException("11140", e.getMessage(), e);
        }
    }

    private static String evaluate_regex_for_field(String regex, String htmltext, String regexFlag) {
        StringBuffer res = new StringBuffer();
        Pattern p = Pattern.compile(regex, 106);
        Matcher m = p.matcher(htmltext);
        String ret = "";
        if (regexFlag.equalsIgnoreCase("repregex")) {
            while (m.find()) {
                res.append(m.group(1)).append("`");
            }
            ret = res.toString();
            int lastIndexOfDelimiter = ret.lastIndexOf("`");
            if (lastIndexOfDelimiter >= 0) {
                ret = res.substring(0, lastIndexOfDelimiter);
            }
        } else if (m.find()) {
            ret = m.group(1);
        }
        return ret;
    }

    public static String replacejunkdata(String input) {
        String res = input.replaceAll("\\n|\\s{2,}|\\t|\\r|\\&nbsp;", " ");
        return res;
    }

    private static HashMap evaluateCommandTree(HashMap tree, Document doc, String htmlString, BufferedWriter writer) throws ScraperException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String error_string = "";
        boolean printBody = true;
        String xmlString = ScrapperHelper.convertDoc2xml(doc);
        xmlString = xmlString.trim();
        XPathEngineImpl xpathEngine = null;
        Document document = null;
        try {
            xmlString = StringUtils.isNotBlank((String)ScrapperMain.RES_CHARSET_ENCODING) ? "<?xml version = \"1.0\" encoding=\"" + ScrapperMain.RES_CHARSET_ENCODING + "\"?>\n" + xmlString : "<?xml version = \"1.0\" encoding=\"iso-8859-1\"?>\n" + xmlString;
            document = XPathUtil.createDocument(xmlString, "UTF-8");
            xpathEngine = new XPathEngineImpl(document);
        }
        catch (Exception e) {
            throw new ScraperException("11140", e.getMessage(), e);
        }
        List flds_only = (List)tree.get("flds_only");
        HashMap<String, Object> h = new HashMap<String, Object>();
        result.put("flds_only", h);
        for (Object f : flds_only) {
            long startTimeField = System.currentTimeMillis();
            String extras = ((String)((HashMap)f).get("extras")).trim();
            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                ScrapperUtil.print("EXTRAS :::  " + extras, writer);
                ScrapperUtil.print(((HashMap)f).get("xpath").toString().trim(), writer);
            }
            String res = "";
            if (extras.equalsIgnoreCase("regex")) {
                res = ScrapperLogic.evaluate_regex_for_field(((String)((HashMap)f).get("xpath")).trim(), htmlString, "regex");
            } else if (extras.equalsIgnoreCase("repregex")) {
                res = ScrapperLogic.evaluate_regex_for_field(((String)((HashMap)f).get("xpath")).trim(), htmlString, "repregex");
            } else if (extras.equalsIgnoreCase("colparsing")) {
                if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL") && printBody) {
                    ScrapperUtil.print("================Printing HTML body for colparsing========================", writer);
                    ScrapperUtil.print(xmlString, writer);
                    ScrapperUtil.print("=================================End of HTML body========================", writer);
                    printBody = false;
                }
                res = xpathEngine.evalXPath(((String)((HashMap)f).get("xpath")).trim());
            } else if (extras.equalsIgnoreCase("colparsingnew")) {
                if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL") && printBody) {
                    ScrapperUtil.print("================Printing HTML body for colparsing========================", writer);
                    ScrapperUtil.print(xmlString, writer);
                    ScrapperUtil.print("=================================End of HTML body========================", writer);
                    printBody = false;
                }
                try {
                    res = ScrapperLogic.evalParamNew(((String)((HashMap)f).get("xpath")).trim(), document);
                }
                catch (Exception e) {
                    res = "";
                    ScrapperUtil.print("Error Evaluating Field", writer);
                }
            } else {
                res = ScrapperLogic.evaluateField((HashMap)f, doc, false);
            }
            long endTimeField = System.currentTimeMillis();
            String fld_only_key = (String)((HashMap)f).get("fldname");
            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                ScrapperUtil.print("Time to parse Field :::" + fld_only_key + "  " + (endTimeField - startTimeField), writer);
            }
            if (fld_only_key.toLowerCase().startsWith(ScrapperMain.ERRORMSG) && StringUtils.isNotBlank((String)res)) {
                error_string = error_string + res + channel_seperator_string;
            }
            h.put(fld_only_key, res);
        }
        List records = (List)tree.get("records");
        h = new HashMap();
        result.put("records", h);
        for (Object r : records) {
            List res;
            long starttime;
            String extras;
            String rcid;
            block36: {
                rcid = (String)((HashMap)r).get("recid");
                extras = (String)((HashMap)r).get("extras");
                starttime = System.currentTimeMillis();
                res = null;
                if (extras.equalsIgnoreCase("colparsing")) {
                    if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL") && printBody) {
                        ScrapperUtil.print("================Printing HTML body for colparsing========================", writer);
                        ScrapperUtil.print(xmlString, writer);
                        ScrapperUtil.print("=================================End of HTML body========================", writer);
                        printBody = false;
                    }
                    res = ScrapperLogic.evaluateRecord((HashMap)r, xpathEngine);
                } else if (extras.equalsIgnoreCase("colparsingnew")) {
                    if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL") && printBody) {
                        ScrapperUtil.print("================Printing HTML body for colparsing========================", writer);
                        ScrapperUtil.print(xmlString, writer);
                        ScrapperUtil.print("=================================End of HTML body========================", writer);
                        printBody = false;
                    }
                    try {
                        if (rcid.endsWith("hiddenkeyvalue")) {
                            res = ScrapperLogic.evaluateRecordNew((HashMap)r, xpathEngine, document);
                            break block36;
                        }
                        res = ScrapperLogic.evaluateRecordNewDataset((HashMap)r, xpathEngine, document);
                    }
                    catch (Exception e) {
                        res = new ArrayList();
                        LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    }
                } else {
                    res = ScrapperLogic.evaluate_record((HashMap)r, doc);
                }
            }
            long endtime = System.currentTimeMillis();
            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                ScrapperUtil.print("TIME TO evaluate_record :::" + rcid + "   " + (endtime - starttime), writer);
            }
            if (rcid.toLowerCase().startsWith(ScrapperMain.ERRORMSG) && res != null && res.size() > 0) {
                for (int i = 0; i < res.size(); ++i) {
                    HashMap first_record = (HashMap)res.get(i);
                    for (Object key : first_record.keySet()) {
                        String value = (String)first_record.get(key);
                        error_string = error_string + value + channel_seperator_string;
                    }
                }
            }
            if ("colparsing".equalsIgnoreCase(extras) && res != null && res.size() > 0) {
                result.put(PARSING_DATASET_KEY_PREFIX + rcid, res);
                continue;
            }
            if ("colparsingnew".equalsIgnoreCase(extras) && res != null && res.size() > 0) {
                if (rcid.endsWith("hiddenkeyvalue")) {
                    h.put(rcid, res);
                    continue;
                }
                result.put(NEW_PARSING_DATASET_KEY_PREFIX + rcid, res);
                continue;
            }
            h.put(rcid, res);
        }
        if (error_string.trim().length() > 0) {
            error_string = error_string.substring(0, error_string.length() - channel_seperator_string.length());
        }
        result.put("founderror", error_string);
        return result;
    }

    private static HashMap inputHiddenParam(HashMap post) throws ScraperException {
        try {
            Iterator it = post.entrySet().iterator();
            String hiddenKey = "";
            Object objectKey = null;
            String key = "";
            while (it.hasNext()) {
                Map.Entry o = it.next();
                objectKey = o.getKey();
                if (null == objectKey || !(key = (String)objectKey).endsWith("_hiddenjson")) continue;
                hiddenKey = key;
            }
            if (hiddenKey.length() > 0) {
                if (post.get(hiddenKey) != null) {
                    String hiddenjson = (String)post.get(hiddenKey);
                    Gson gson = new Gson();
                    Type listType = new TypeToken<HashMap<String, String>>(){}.getType();
                    HashMap obj = (HashMap)gson.fromJson(hiddenjson, listType);
                    post.putAll(obj);
                }
                post.remove(hiddenKey);
            }
        }
        catch (Exception e) {
            throw new ScraperException("11136", e.getMessage(), e);
        }
        return post;
    }

    private static HashMap inputCookieParam(HashMap header, BufferedWriter writeruniq) throws ScraperException {
        try {
            String cookie = "";
            ArrayList putheaderkey = new ArrayList();
            for (Object key : header.keySet()) {
                if (null == key) continue;
                Object header_value = header.get(key);
                if (null == header_value) {
                    LOGGER.warn((Object)("Header value for " + key + " coming null"));
                    if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                        ScrapperUtil.print("Header value for " + key + " coming null", writeruniq);
                    }
                    putheaderkey.add(key);
                    continue;
                }
                if (!((String)key).endsWith("_cookie")) continue;
                cookie = cookie + (String)header_value;
                putheaderkey.add(key);
            }
            for (Object l : putheaderkey) {
                header.remove(l);
            }
            if (!cookie.equals("")) {
                header.put("Cookie", cookie);
            }
        }
        catch (Exception e) {
            throw new ScraperException("11137", e.getMessage(), e);
        }
        return header;
    }

    static List getUrlDataCookie(HashMap inputdata, HashMap postdata, String serviceid, String appid, String apiVersion, String postparamstr, String nativeapppath, String logfolderpath, Map tMap, Integer socketTimeOut, BufferedWriter writeruniq) throws ScraperException {
        ArrayList output = new ArrayList();
        long startTime = 0L;
        long endTime = 0L;
        if (inputdata.containsKey("file")) {
            String fileName = inputdata.get("file").toString();
            output.add(ScrapperMain.loadScraperFile(appid, apiVersion, nativeapppath, fileName));
            output.add("");
            output.add("");
            return output;
        }
        List urllist = (List)inputdata.get("urllist");
        List paramlist = (List)inputdata.get("paramkey");
        List headerlist = (List)inputdata.get("headerkey");
        List urlparamlist = (List)inputdata.get("repurlparamkey");
        List propkeyname = (List)inputdata.get("propkeyname");
        ArrayList<BasicNameValuePair> repeatedArrayFormation = null;
        HashMap<String, String> repeatedParamForUrlConnection = null;
        if (inputdata.containsKey("repeatpostparamkey")) {
            String repeatValue;
            String repeatKey;
            int i;
            List repeatpostparamlist;
            if (ScrapperMain.connectionLibrary.equals("urlconnection")) {
                repeatedParamForUrlConnection = new HashMap<String, String>();
                repeatpostparamlist = (List)inputdata.get("repeatpostparamkey");
                for (i = 0; i < repeatpostparamlist.size(); ++i) {
                    repeatKey = (String)repeatpostparamlist.get(i);
                    if (!postdata.containsKey(repeatKey)) {
                        throw new ScraperException("11117", "Pass comma seperated values for repeatpostparam " + repeatKey);
                    }
                    repeatValue = (String)postdata.get(repeatKey);
                    repeatedParamForUrlConnection.put(repeatKey, repeatValue);
                    postdata.remove(repeatKey);
                }
            } else {
                repeatedArrayFormation = new ArrayList<BasicNameValuePair>();
                repeatpostparamlist = (List)inputdata.get("repeatpostparamkey");
                for (i = 0; i < repeatpostparamlist.size(); ++i) {
                    repeatKey = (String)repeatpostparamlist.get(i);
                    if (postdata.containsKey(repeatKey)) {
                        repeatValue = (String)postdata.get(repeatKey);
                        String[] repeatPostParamArray = repeatValue.split(",");
                        int repeatPostParamArraylength = repeatPostParamArray.length;
                        for (int j = 0; j < repeatPostParamArraylength; ++j) {
                            String str = repeatPostParamArray[j].trim();
                            BasicNameValuePair p = new BasicNameValuePair(repeatKey, str);
                            repeatedArrayFormation.add(p);
                        }
                    } else {
                        throw new ScraperException("11117", "Pass comma seperated values for repeatpostparam " + repeatKey);
                    }
                    postdata.remove(repeatKey);
                }
            }
        }
        HashMap post = new HashMap();
        for (int j = 0; j < paramlist.size(); ++j) {
            String k = (String)paramlist.get(j);
            String[] kSplit = k.split("`");
            if (kSplit.length == 1) {
                if (postdata.containsKey(k)) {
                    post.put(k, postdata.get(k));
                    continue;
                }
                if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                    ScrapperUtil.print("Post Param key not found:::" + k, writeruniq);
                }
                throw new ScraperException("11118", "Param key " + k + " not found");
            }
            if (postdata.containsKey(kSplit[0])) {
                post.put(kSplit[1], postdata.get(kSplit[0]));
                continue;
            }
            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                ScrapperUtil.print("Post Param key not found:::" + kSplit[0], writeruniq);
            }
            throw new ScraperException("11118", "Param key " + kSplit[0] + " not found in postdata");
        }
        if (postparamstr.trim().length() > 0) {
            String dynamicStr = (String)postdata.get(postparamstr);
            String[] splitter = dynamicStr.split(",");
            String delimiter = ScrapperMain.DYNAMIC_POSTPARAM_DELIMITER;
            if (delimiter.trim().length() == 0) {
                delimiter = ":";
            }
            ScrapperUtil.print("Dynamic postparamstr delimiter " + delimiter, writeruniq);
            for (int i = 0; i < splitter.length; ++i) {
                String value;
                String key;
                String[] keyvalue = splitter[i].trim().split(delimiter);
                if (keyvalue.length == 1) {
                    key = keyvalue[0].trim();
                    value = "";
                    post.put(key, value);
                }
                if (keyvalue.length != 2) continue;
                key = keyvalue[0].trim();
                value = keyvalue[1].trim();
                post.put(key, value);
            }
        }
        HashMap newpost = new HashMap();
        newpost = ScrapperLogic.inputHiddenParam(post);
        newpost.putAll((HashMap)inputdata.get("optionalpostparam"));
        HashMap headers = new HashMap();
        for (int j = 0; j < headerlist.size(); ++j) {
            String k = (String)headerlist.get(j);
            if (!postdata.containsKey(k)) {
                if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                    ScrapperUtil.print("Header key " + k + " not found", writeruniq);
                }
                throw new ScraperException("11118", "Header key " + k + " not found in postdata");
            }
            headers.put(k, postdata.get(k));
        }
        HashMap newheaders = new HashMap();
        newheaders = ScrapperLogic.inputCookieParam(headers, writeruniq);
        newheaders.putAll((HashMap)inputdata.get("optionalheaderparam"));
        if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
            ScrapperUtil.print("User-Agent Boolean value " + ScrapperMain.USERAGENT, writeruniq);
        }
        if (!ScrapperMain.USERAGENT) {
            newheaders.put("User-Agent", "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_5_5; en-us) AppleWebKit/525.27.1 (KHTML, like Gecko) Version/3.2.1 Safari/525.27.1");
        } else if (!newheaders.containsKey("User-Agent") || newheaders.get("User-Agent") == null || newheaders.get("User-Agent").toString().trim().length() == 0) {
            newheaders.put("User-Agent", "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_5_5; en-us) AppleWebKit/525.27.1 (KHTML, like Gecko) Version/3.2.1 Safari/525.27.1");
        }
        if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
            ScrapperUtil.print("Headers ::: " + newheaders, writeruniq);
        }
        if (urllist != null && urllist.size() > 0) {
            for (int i = 0; i < urllist.size(); ++i) {
                BufferedWriter writer;
                OutputStreamWriter out;
                String conLib;
                String targetURL;
                String javascrenbl;
                String calltype;
                block79: {
                    String value;
                    HashMap u1 = (HashMap)urllist.get(i);
                    calltype = (String)u1.get("calltype");
                    javascrenbl = (String)u1.get("javascriptswitch");
                    targetURL = (String)u1.get("url");
                    conLib = "";
                    if (u1.containsKey("conlib")) {
                        conLib = (String)u1.get("conlib");
                    }
                    boolean isEncodingReq = false;
                    if (u1.containsKey("encode") && (value = (String)u1.get("encode")).equalsIgnoreCase("encode")) {
                        isEncodingReq = true;
                    }
                    if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                        ScrapperUtil.print("isEncodingReq ::: " + isEncodingReq, writeruniq);
                    }
                    if (propkeyname != null && propkeyname.size() > 0) {
                        String propFileName = appid + ".properties";
                        String propFileContent = ScrapperMain.loadScraperFile(appid, apiVersion, nativeapppath, propFileName);
                        if (StringUtils.isNotBlank((String)propFileContent)) {
                            Properties scraperProps = new Properties();
                            try {
                                scraperProps.load(new StringReader(propFileContent));
                            }
                            catch (IOException e) {
                                throw new ScraperException("11110", e.getMessage(), e);
                            }
                            for (int j = 0; j < propkeyname.size(); ++j) {
                                String propkey = ((String)propkeyname.get(j)).trim();
                                if (targetURL == null || !targetURL.contains(propkey)) continue;
                                String propvalue = scraperProps.getProperty(propkey);
                                if (propvalue == null) {
                                    throw new ScraperException("11107", propkey + "   key value pair not find in " + appid + ".properties");
                                }
                                targetURL = targetURL.replace(propkey, propvalue);
                            }
                        } else {
                            throw new ScraperException("11110", propFileName + " file not found");
                        }
                    }
                    targetURL = ScrapperLogic.replaceDynamicParamsInURL(targetURL, postdata, urlparamlist, newpost, writeruniq);
                    if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                        ScrapperUtil.print("targetURL :::::" + targetURL, writeruniq);
                    }
                    if (isEncodingReq) {
                        try {
                            targetURL = ScrapperLogic.urlencoder(targetURL);
                        }
                        catch (Exception e) {
                            if (!ScrapperMain.DEBUG.equalsIgnoreCase("ALL") && !ScrapperMain.DEBUG.equalsIgnoreCase("ERROR")) break block79;
                            ScrapperUtil.print("problem with target URL:::::" + targetURL + "   Exception is :" + e.getMessage(), writeruniq);
                        }
                    }
                }
                if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                    ScrapperUtil.print("targetURL after Encoding:::::" + targetURL, writeruniq);
                }
                if (calltype.equalsIgnoreCase("get")) {
                    if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                        ScrapperUtil.print("Enter Inside GET", writeruniq);
                    }
                    output.clear();
                    startTime = System.currentTimeMillis();
                    if (!conLib.equalsIgnoreCase("")) {
                        if (conLib.equals("urlconnection")) {
                            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                                ScrapperUtil.print("Enter Inside urlconnection", writeruniq);
                            }
                            output = UrlUtil.urlConnGetMethod(targetURL, newheaders, javascrenbl, socketTimeOut, writeruniq);
                        } else {
                            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                                ScrapperUtil.print("Enter Inside httpclient", writeruniq);
                            }
                            output = UrlUtil.httpClientGet(targetURL, newheaders, javascrenbl, socketTimeOut, writeruniq);
                        }
                    } else if (ScrapperMain.connectionLibrary.equals("urlconnection")) {
                        if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                            ScrapperUtil.print("Enter Inside urlconnection", writeruniq);
                        }
                        output = UrlUtil.urlConnGetMethod(targetURL, newheaders, javascrenbl, socketTimeOut, writeruniq);
                    } else {
                        if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                            ScrapperUtil.print("Enter Inside httpclient", writeruniq);
                        }
                        output = UrlUtil.httpClientGet(targetURL, newheaders, javascrenbl, socketTimeOut, writeruniq);
                    }
                    endTime = System.currentTimeMillis();
                    if (tMap != null) {
                        tMap.put("serviceExecTime", endTime - startTime + "");
                    }
                    if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                        try {
                            if (logfolderpath != null) {
                                out = new OutputStreamWriter((OutputStream)new FileOutputStream(logfolderpath + File.separator + serviceid + "_url_" + i + ".html"), "UTF-8");
                                writer = new BufferedWriter(out);
                                ScrapperUtil.print(output.get(0).toString(), writer);
                                writer.close();
                            }
                            ScrapperUtil.print("Cookies ::: _url_" + i + "    >>>  " + output.get(1).toString(), writeruniq);
                            ScrapperUtil.print("TargerUrl output ---->>>>" + output.get(2), writeruniq);
                            ScrapperUtil.print("TIME DOWNLOAD >>   " + (endTime - startTime), writeruniq);
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)e.getMessage(), (Throwable)e);
                            throw new ScraperException("11142", e.getMessage(), e);
                        }
                    }
                    newheaders.clear();
                    continue;
                }
                if (!calltype.equals("post")) continue;
                if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                    ScrapperUtil.print("Enter Inside POST", writeruniq);
                    ScrapperUtil.printMap("POST PARAM :::  ", newpost, writeruniq);
                }
                output.clear();
                startTime = System.currentTimeMillis();
                if (!conLib.equalsIgnoreCase("")) {
                    if (conLib.equals("urlconnection")) {
                        if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                            ScrapperUtil.print("Enter Inside urlconnection", writeruniq);
                        }
                        output = UrlUtil.urlConnPostMethod(targetURL, newpost, newheaders, javascrenbl, repeatedParamForUrlConnection, socketTimeOut, writeruniq);
                    } else {
                        if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                            ScrapperUtil.print("Enter Inside httpclient", writeruniq);
                        }
                        output = UrlUtil.httpClientPost(targetURL, newpost, newheaders, javascrenbl, repeatedArrayFormation, socketTimeOut, writeruniq);
                    }
                } else if (ScrapperMain.connectionLibrary.equals("urlconnection")) {
                    if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                        ScrapperUtil.print("Enter Inside urlconnection", writeruniq);
                    }
                    output = UrlUtil.urlConnPostMethod(targetURL, newpost, newheaders, javascrenbl, repeatedParamForUrlConnection, socketTimeOut, writeruniq);
                } else {
                    if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                        ScrapperUtil.print("Enter Inside httpclient", writeruniq);
                    }
                    output = UrlUtil.httpClientPost(targetURL, newpost, newheaders, javascrenbl, repeatedArrayFormation, socketTimeOut, writeruniq);
                }
                endTime = System.currentTimeMillis();
                if (tMap != null) {
                    tMap.put("serviceExecTime", endTime - startTime + "");
                }
                if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                    try {
                        out = new OutputStreamWriter((OutputStream)new FileOutputStream(logfolderpath + File.separator + serviceid + "_url_" + i + ".html"), "UTF-8");
                        writer = new BufferedWriter(out);
                        ScrapperUtil.print(output.get(0).toString(), writer);
                        ScrapperUtil.print("Cookies ::: _url_" + i + "    >>>  " + output.get(1).toString(), writeruniq);
                        ScrapperUtil.print("TargerUrl output ---->>>>" + output.get(2), writeruniq);
                        ScrapperUtil.print("TIME DOWNLOAD >>   " + (endTime - startTime), writeruniq);
                        writer.close();
                    }
                    catch (Exception e) {
                        throw new ScraperException("11142", e.getMessage(), e);
                    }
                }
                newheaders.clear();
                newpost.clear();
            }
        } else {
            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                ScrapperUtil.print("post param should be 0", writeruniq);
            }
            throw new ScraperException("11119", "pass atleast one url in dsl file");
        }
        return output;
    }

    public static String replaceDynamicParamsInURL(String targetURL, HashMap postdata, List urlparamlist, HashMap newpost, BufferedWriter writer) throws ScraperException {
        for (int j = 0; j < urlparamlist.size(); ++j) {
            String replKey = ((String)urlparamlist.get(j)).trim();
            if (targetURL == null || !targetURL.contains(replKey)) continue;
            String postdataParam = (String)postdata.get(replKey);
            if (postdataParam != null) {
                targetURL = targetURL.replace(replKey, postdataParam);
                newpost.remove(replKey);
                continue;
            }
            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                ScrapperUtil.print("repurlparam key " + replKey + " not found", writer);
            }
            throw new ScraperException("11118", "repurlparam key " + replKey + " not found in postdata");
        }
        return targetURL;
    }

    private static String urlencoder(String url) {
        String tempUrl = "";
        if (url != null && url.contains("?")) {
            String[] parts = url.split("\\?");
            String[] input = parts[1].split("&");
            for (int i = 0; i < input.length; ++i) {
                String[] keyvalue = input[i].split("=");
                tempUrl = keyvalue.length == 1 && input[i].contains("=") ? tempUrl + keyvalue[0] + "=&" : tempUrl + keyvalue[0] + "=" + EncodeUtils.encode((String)keyvalue[1]) + "&";
            }
            url = parts[0] + "?" + tempUrl.substring(0, tempUrl.length() - 1);
            return url;
        }
        return url;
    }

    private static HashMap checkHiddenKeyValue(HashMap input, String serviceid) throws ScraperException {
        HashMap finaljson = new HashMap();
        HashSet<String> jsonrecords = new HashSet<String>();
        try {
            Iterator it = ((HashMap)input.get("records")).entrySet().iterator();
            Object objectKey = null;
            String key = "";
            while (it.hasNext()) {
                Map.Entry o = it.next();
                objectKey = o.getKey();
                if (null == objectKey || !(key = (String)objectKey).endsWith("hiddenkeyvalue")) continue;
                List keyvalue = (List)((HashMap)input.get("records")).get(key);
                if (keyvalue != null && keyvalue.size() > 0) {
                    for (int i = 0; i < keyvalue.size(); ++i) {
                        HashMap f = (HashMap)keyvalue.get(i);
                        if (((String)f.get("hiddenkey")).trim().length() == 0) continue;
                        if (!finaljson.containsKey(f.get("hiddenkey"))) {
                            finaljson.put(f.get("hiddenkey"), f.get("hiddenvalue"));
                            continue;
                        }
                        String temp = "";
                        temp = (String)finaljson.get(f.get("hiddenkey"));
                        temp = temp + "`" + f.get("hiddenvalue");
                        finaljson.put(f.get("hiddenkey"), temp);
                    }
                }
                jsonrecords.add(key);
                Gson gson = new Gson();
                String hidden_serviceid = gson.toJson(finaljson);
                int hidden_index = key.indexOf("hiddenkeyvalue");
                if (hidden_index == 0) {
                    ((HashMap)input.get("flds_only")).put(serviceid + "_hiddenjson", hidden_serviceid);
                } else {
                    ((HashMap)input.get("flds_only")).put(key.substring(0, hidden_index) + "hiddenjson", hidden_serviceid);
                }
                ((HashMap)input.get("records")).remove(key);
                break;
            }
        }
        catch (Exception e) {
            throw new ScraperException("11134", e.getMessage(), e);
        }
        return input;
    }

    public static HashMap scrapperMain(HashMap serviceIDAppID, HashMap postdata, HashMap tMap, ServiceDSL serviceDSL) throws ScraperException {
        HashMap<String, String> flds_only;
        String serviceid = "";
        String nativeapppath = "";
        String logfolderpath = "";
        String appid = "";
        String httpStatusCode = "-1";
        boolean isFile = true;
        Document doc = null;
        HashMap output = new HashMap();
        BufferedWriter writer = null;
        String htmlString = "";
        boolean normalSpace = false;
        long startTime = 0L;
        long endTime = 0L;
        List fileContent = null;
        try {
            String isNtlm;
            writer = (BufferedWriter)serviceIDAppID.get("bufferedwriter");
            serviceid = (String)serviceIDAppID.get("serviceid");
            nativeapppath = (String)serviceIDAppID.get("nativeapppath");
            logfolderpath = (String)serviceIDAppID.get("logfolderpath");
            appid = (String)serviceIDAppID.get("appid");
            Integer socketTimeOut = (Integer)serviceIDAppID.get("sockettimeout");
            channel_seperator_string = (String)serviceIDAppID.get("channel");
            String inputDSLLogic = serviceDSL.getInputString();
            serviceDSL.setInputTree(inputDSLLogic, postdata, writer);
            HashMap<?, ?> inputTreeHash = serviceDSL.getInputTree();
            if (!inputTreeHash.containsKey("file")) {
                List urlList = (List)inputTreeHash.get("urllist");
                HashMap url = (HashMap)urlList.get(0);
                if (url.containsKey("normalspace")) {
                    normalSpace = true;
                }
                isFile = false;
            }
            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                ScrapperUtil.printMap("POSTDATA FROM MIDDLEWARE  ::::   ", postdata, writer);
                ScrapperUtil.print("INPUT DSL FILE TREE   " + inputTreeHash, writer);
            }
            if ("true".equals(isNtlm = (String)postdata.get(ScrapperMain.RQ_IS_NTLM))) {
                String nt_domain = (String)postdata.get("ntlm_domain");
                String nt_host = (String)postdata.get("ntlm_host");
                String nt_user = (String)postdata.get("ntlm_user");
                String nt_pass = (String)postdata.get("ntlm_pass");
                ScrapperMain.NT_MODE = "ntlm";
                if (nt_domain != null) {
                    ScrapperMain.NT_DOMAIN = nt_domain;
                }
                if (nt_host != null) {
                    ScrapperMain.NT_HOST = nt_host;
                }
                if (nt_user != null) {
                    ScrapperMain.NT_USER = nt_user;
                }
                if (nt_pass != null) {
                    ScrapperMain.NT_PASS = nt_pass;
                }
                UrlUtil.populateConfigMap();
                postdata.remove(ScrapperMain.RQ_IS_NTLM);
                postdata.remove("ntlm_domain");
                postdata.remove("ntlm_host");
                postdata.remove("ntlm_user");
                postdata.remove("ntlm_pass");
                if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                    ScrapperUtil.printMap("AFTER REMOVING THE NTLM DETAILS IN POSTDATA FROM MIDDLEWARE  ::::   ", postdata, writer);
                }
            }
            HashMap<String, String> map = new HashMap<String, String>();
            String ignorehttpProxy = (String)serviceIDAppID.get("ignorehttpproxy");
            if (StringUtils.isNotBlank((String)ignorehttpProxy)) {
                map.put("ignorehttpproxy", serviceIDAppID.get("ignorehttpproxy").toString());
            }
            UrlUtil.populateConfigMap(map);
            String postparamstr = (String)inputTreeHash.get("postparamstr");
            String appVersion = (String)serviceIDAppID.get("X-Kony-API-Version");
            fileContent = ScrapperLogic.getUrlDataCookie(inputTreeHash, postdata, serviceid, appid, appVersion, postparamstr, nativeapppath, logfolderpath, tMap, socketTimeOut, writer);
            if (inputTreeHash != null) {
                inputTreeHash.clear();
                inputTreeHash = null;
            }
            if (postdata != null) {
                postdata.clear();
                postdata = null;
            }
        }
        catch (ScraperException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL") || ScrapperMain.DEBUG.equalsIgnoreCase("ERROR")) {
                ScrapperUtil.print(ScrapperUtil.getStackTrace(e), writer);
                ScrapperUtil.print(e.getErrorCode() + " " + e.getErrorMessage(), writer);
            }
            output = new HashMap();
            HashMap<String, String> flds_only2 = new HashMap<String, String>();
            flds_only2.put("errmsg", e.getErrorMessage());
            flds_only2.put("opstatus", e.getErrorCode());
            output.put("flds_only", flds_only2);
            return output;
        }
        String htmlRawString = (String)fileContent.get(0);
        if (normalSpace) {
            htmlString = htmlRawString;
            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL") || ScrapperMain.DEBUG.equalsIgnoreCase("ERROR")) {
                ScrapperUtil.print("NormalSpace flag is enabled: Extraction will be done on Raw data", writer);
            }
        } else {
            htmlString = ScrapperLogic.replacejunkdata((String)fileContent.get(0));
        }
        String cookie = (String)fileContent.get(1);
        String targetUrl = (String)fileContent.get(2);
        if (!isFile) {
            httpStatusCode = String.valueOf(fileContent.get(3));
        }
        try {
            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                startTime = System.currentTimeMillis();
            }
            doc = XmlUtils.getDocument(htmlString, writer);
            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                endTime = System.currentTimeMillis();
                ScrapperUtil.print("DOCUMENT FORMATION TIME ---->>>>" + (endTime - startTime), writer);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL") || ScrapperMain.DEBUG.equalsIgnoreCase("ERROR")) {
                ScrapperUtil.print(ScrapperUtil.getStackTrace(e), writer);
                ScrapperUtil.print("opstatus:11130 " + e.toString(), writer);
            }
            output = new HashMap();
            flds_only = new HashMap<String, String>();
            flds_only.put("errmsg", e.toString());
            flds_only.put("opstatus", "11130");
            if (!isFile) {
                flds_only.put("httpStatusCode", httpStatusCode);
            }
            output.put("flds_only", flds_only);
            return output;
        }
        try {
            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                startTime = System.currentTimeMillis();
            }
            HashMap<?, ?> inputCommandTree = serviceDSL.getOutputTree();
            output = ScrapperLogic.evaluateCommandTree(inputCommandTree, doc, htmlString, writer);
            output = ScrapperLogic.checkHiddenKeyValue(output, serviceid);
            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                endTime = System.currentTimeMillis();
                ScrapperUtil.print("Total Time Taken to parse Tree  ::::  " + (endTime - startTime), writer);
            }
            if (inputCommandTree.containsKey("cookie")) {
                String cookieNameStr = (String)inputCommandTree.get("cookie");
                if (cookieNameStr.equals("")) {
                    ((HashMap)output.get("flds_only")).put(serviceid + "_cookie", cookie);
                } else {
                    ((HashMap)output.get("flds_only")).put(cookieNameStr + "_cookie", cookie);
                }
            }
            ((HashMap)output.get("flds_only")).put(serviceid + "_url", targetUrl);
            ((HashMap)output.get("flds_only")).put("opstatus", "0");
            if (!isFile) {
                ((HashMap)output.get("flds_only")).put("httpStatusCode", httpStatusCode);
            }
        }
        catch (ScraperException e) {
            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL") || ScrapperMain.DEBUG.equalsIgnoreCase("ERROR")) {
                ScrapperUtil.print(ScrapperUtil.getStackTrace(e), writer);
                ScrapperUtil.print(e.getErrorCode() + " " + e.getErrorMessage(), writer);
            }
            output = new HashMap();
            flds_only = new HashMap();
            flds_only.put("errmsg", e.getErrorMessage());
            flds_only.put("opstatus", e.getErrorCode());
            if (!isFile) {
                flds_only.put("httpStatusCode", httpStatusCode);
            }
            output.put("flds_only", flds_only);
            return output;
        }
        return output;
    }

    public static List evaluateRecordNew(HashMap r, XPathEngine xpathEngine, Document document) throws Exception {
        List fields = (List)r.get("fields");
        ArrayList fieldResults = new ArrayList();
        HashMap innerRecord = null;
        if (((List)r.get("innerrecord")).size() > 0) {
            innerRecord = (HashMap)((List)r.get("innerrecord")).get(0);
        }
        List innerFields = null;
        String innerRecId = "";
        String innerXpath = "";
        if (innerRecord != null && innerRecord.size() > 0) {
            innerRecId = (String)innerRecord.get("recid");
            innerXpath = (String)innerRecord.get("xpath");
            innerFields = (List)innerRecord.get("fields");
        }
        String recXpath = (String)r.get("xpath");
        NodeList nodeList = XPathUtil.evaluateAsNodeList(document, recXpath, null);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            HashMap<String, Object> fieldVals = new HashMap<String, Object>();
            for (HashMap fmap : fields) {
                String fXpath = (String)fmap.get("xpath");
                String name = (String)fmap.get("fldname");
                String value = XPathUtil.evaluateAsString(node, fXpath, null);
                fieldVals.put(name, value);
            }
            if (innerRecord != null && innerRecord.size() > 0) {
                NodeList innerNodeList = XPathUtil.evaluateAsNodeList(node, innerXpath, null);
                ArrayList innerRecordSave = new ArrayList();
                for (int j = 0; j < innerNodeList.getLength(); ++j) {
                    Node innerNode = innerNodeList.item(j);
                    HashMap<String, String> innerfieldVals = new HashMap<String, String>();
                    for (HashMap fmap : innerFields) {
                        String fXpath = (String)fmap.get("xpath");
                        String name = (String)fmap.get("fldname");
                        String value = XPathUtil.evaluateAsString(innerNode, fXpath, null);
                        innerfieldVals.put(name, value);
                    }
                    innerRecordSave.add(innerfieldVals);
                }
                HashMap InnerRecordMapping = new HashMap();
                InnerRecordMapping.put(innerRecId, innerRecordSave);
                fieldVals.put("innerrecord", InnerRecordMapping);
            }
            fieldResults.add(fieldVals);
        }
        return fieldResults;
    }

    private static String evalParamNew(String fXpath, Document document) {
        String value = "";
        try {
            value = XPathUtil.evaluateAsString(document, fXpath, null);
            value = value.replaceAll("<(.*?)>|</\\w*>|<\\w*/>", "");
            value = value.replaceAll("\n|\r|\t|\b", " ");
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return value;
    }

    public static List evaluateRecordNewDataset(HashMap r, XPathEngine xpathEngine, Document document) throws Exception {
        String recId = (String)r.get("recid");
        com.konylabs.middleware.dataobject.Dataset dset = new com.konylabs.middleware.dataobject.Dataset();
        dset.setId(recId);
        List fields = (List)r.get("fields");
        HashMap innerRecord = null;
        if (((List)r.get("innerrecord")).size() > 0) {
            innerRecord = (HashMap)((List)r.get("innerrecord")).get(0);
        }
        List innerFields = null;
        String innerRecId = "";
        String innerXpath = "";
        if (innerRecord != null && innerRecord.size() > 0) {
            innerRecId = (String)innerRecord.get("recid");
            innerXpath = (String)innerRecord.get("xpath");
            innerFields = (List)innerRecord.get("fields");
        }
        String recXpath = (String)r.get("xpath");
        NodeList nodeList = XPathUtil.evaluateAsNodeList(document, recXpath, null);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            Record record = new Record();
            for (HashMap fmap : fields) {
                String fXpath = (String)fmap.get("xpath");
                String name = (String)fmap.get("fldname");
                String value = XPathUtil.evaluateAsString(node, fXpath, null);
                record.addParam(new Param(name, value, "String"));
            }
            if (innerRecord != null && innerRecord.size() > 0) {
                NodeList innerNodeList = XPathUtil.evaluateAsNodeList(node, innerXpath, null);
                com.konylabs.middleware.dataobject.Dataset dsetInner = new com.konylabs.middleware.dataobject.Dataset();
                dsetInner.setId(innerRecId);
                for (int j = 0; j < innerNodeList.getLength(); ++j) {
                    Node innerNode = innerNodeList.item(j);
                    Record recordInner = new Record();
                    for (HashMap fmap : innerFields) {
                        String fXpath = (String)fmap.get("xpath");
                        String name = (String)fmap.get("fldname");
                        String value = XPathUtil.evaluateAsString(innerNode, fXpath, null);
                        recordInner.addParam(new Param(name, value, "String"));
                    }
                    dsetInner.addRecord(recordInner);
                }
                record.addDataset(dsetInner);
            }
            dset.addRecord(record);
        }
        ArrayList<com.konylabs.middleware.dataobject.Dataset> res = new ArrayList<com.konylabs.middleware.dataobject.Dataset>();
        res.add(dset);
        return res;
    }
}

