/*
 * Decompiled with CFR 0.152.
 */
package com.kony.scrapper.gc;

import com.kony.scrapper.gc.ScraperException;
import com.kony.scrapper.gc.ScrapperLogic;
import com.kony.scrapper.gc.ScrapperUtil;
import com.kony.scrapper.gc.ServiceDSL;
import com.kony.scrapper.gc.UrlUtil;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.asset.AssetType;
import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.common.MWConstants;
import com.konylabs.middleware.common.MiddlewareValidationListener;
import com.konylabs.middleware.dataobject.Dataset;
import com.konylabs.middleware.dataobject.Param;
import com.konylabs.middleware.dataobject.Record;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.dataobject.ResultToJSON;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.utilities.ConfigPathUtil;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ScrapperMain {
    public static final String HTTPCLIENT_DEFAULT = "httpclient";
    public static String connectionLibrary = "httpclient";
    public static final String DEBUG_DISABLE = "0";
    public static final String ALL = "ALL";
    public static final String ERROR = "ERROR";
    public static String DEBUG = "0";
    public static String ERRORMSG = "error";
    public static final int HTTPNOCONTENT_DEFAULT = 0;
    public static int HTTPNOCONTENT = 0;
    public static final boolean USERAGENT_DEFAULT = false;
    public static boolean USERAGENT = false;
    public static final int HTTPNOCONTENTIMER_DEFAULT = 0;
    public static int HTTPNOCONTENTTIMER = 0;
    public static String REQ_CHARSET_ENCODING = "";
    public static String RES_CHARSET_ENCODING = "";
    public static String HTTP_PROXY_HOST = "";
    private static final int HTTP_PROXY_PORT_DEFAULT = 80;
    public static int HTTP_PROXY_PORT = 80;
    public static String HTTP_PROXY_UNAME = "";
    public static String HTTP_PROXY_PASSWD = "";
    static String MODE = "server";
    public static String DYNAMIC_POSTPARAM_DELIMITER = "";
    public static String RQ_IS_NTLM = "is_ntlm";
    public static final String RQ_NT_HOST = "ntlm_host";
    public static final String RQ_NT_USER = "ntlm_user";
    public static final String RQ_NT_PASS = "ntlm_pass";
    public static final String RQ_NT_DOMAIN = "ntlm_domain";
    public static String NT_HOST = "NT_HOST";
    public static String NT_USER = "NT_USER";
    public static String NT_PASS = "NT_PASS";
    public static String NT_DOMAIN = "NT_DOMAIN";
    public static String NT_MODE = "NT_MODE";
    static final String dsl_delimiter = "`";
    static final String context_reset_id = "{{reset}}";
    static final String user_agent = "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_5_5; en-us) AppleWebKit/525.27.1 (KHTML, like Gecko) Version/3.2.1 Safari/525.27.1";
    static final String SCRAPPER_HOME = System.getProperty("middleware.home", "/home/core/install");
    static final String HTTPCLIENT = "httpclient";
    static final String URLCONNECTION = "urlconnection";
    static final String REGEX = "regex";
    static final String REPREGEX = "repregex";
    static final String COLPARSING = "colparsing";
    static final String COLPARSINGB = "colparsingnew";
    static final String NormalSpace = "NormalSpace";
    static final String appID_ERROR = "11101";
    static final String serviceID_ERROR = "11102";
    static final String channel_ERROR = "11103";
    static final String path_ERROR = "11104";
    static final String NativePath_ERROR = "11105";
    static final String seperater_ERROR = "11106";
    static final String prop_key_Not_Found_ERROR = "11107";
    static final String prop_file_Not_Found_ERROR = "11110";
    static final String Input_param_not_supported_ERROR = "11111";
    static final String Input_args_not_supported_ERROR = "11112";
    static final String Optheaderparam_ERROR1 = "11113";
    static final String Optheaderparam_ERROR2 = "11114";
    static final String Optpostparam_ERROR1 = "11115";
    static final String Optpostparam_ERROR2 = "11116";
    static final String repeatparam_not_found_ERROR = "11117";
    static final String postdata_key_Not_Found_ERROR = "11118";
    static final String url_param_Not_Found_ERROR = "11119";
    static final String file_param_ERROR = "11120";
    static final String Output_params_not_supported_ERROR = "11121";
    static final String Field_record_key_repeat_ERROR = "11123";
    static final String Ouput_args_not_supported_ERROR = "11122";
    static final String Context_not_inside_Record_ERROR = "11124";
    static final String Innerrecord_not_inside_Record_ERROR = "11125";
    static final String Cookie_param_repeat_ERROR = "11126";
    static final String Context_Empty_ERROR = "11127";
    static final String String_to_Dom_Conversion_ERROR = "11130";
    static final String Xpath_Not_Supported_ERROR = "11131";
    static final String html2xml_Conversion_ERROR = "11132";
    static final String Dataset_fill_ERROR = "11133";
    static final String gson_parser_ERROR = "11134";
    public static final String print_ERROR = "11135";
    static final String hidden_param_ERROR = "11136";
    static final String cookie_param_ERROR = "11137";
    static final String XML_parser_ERROR = "11140";
    static final String HTML_file_ERROR = "11142";
    static final String Log_file_ERROR = "11143";
    static final String Network_IO_ERROR = "9001";
    static final String Http_Exception_ERROR = "9000";
    static final String urlutil_ERROR = "11138";
    static final String UNKNOWN_ERRORS = "11143";
    private static final Logger logger = Logger.getLogger(ScrapperMain.class);
    private static AppCache appCache;

    public static void setAppCache(AppCache appCache) {
        ScrapperMain.appCache = appCache;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static HashMap getDSLContent(HashMap serviceIdAppId, BufferedWriter writer) throws ScraperException {
        HashMap<String, String> output = new HashMap<String, String>();
        if (!serviceIdAppId.containsKey("nativeapppath")) throw new ScraperException(NativePath_ERROR, "nativeapppath not found in serviceIdAppId");
        String nativeapppath = serviceIdAppId.get("nativeapppath").toString();
        String appId = serviceIdAppId.get("appid").toString();
        String serviceid = serviceIdAppId.get("serviceid").toString();
        String dslFileName = serviceid + ".dsl";
        try {
            String apiVersion = (String)serviceIdAppId.get("X-Kony-API-Version");
            logger.debug((Object)("AppId : " + appId));
            logger.debug((Object)("API Version : " + apiVersion));
            logger.debug((Object)("ServiceId : " + serviceid));
            String dslContent = ScrapperMain.loadScraperFile(appId, apiVersion, nativeapppath, dslFileName);
            if (StringUtils.isBlank((String)dslContent)) {
                throw new ScraperException(prop_file_Not_Found_ERROR, dslFileName + " file not found");
            }
            output.put("dslcontent", dslContent);
            if (!DEBUG.equalsIgnoreCase(ALL)) return output;
            ScrapperUtil.print("DSL FILE CONTENT :::::  " + dslContent, writer);
            return output;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            if (!DEBUG.equalsIgnoreCase(ALL)) throw new ScraperException(path_ERROR, e.toString());
            ScrapperUtil.print(ScrapperUtil.getStackTrace(e), writer);
            ScrapperUtil.print("DSL file path not correct.....", writer);
            throw new ScraperException(path_ERROR, e.toString());
        }
    }

    static void readPropertiesFile(String appID, String apiVersion, String nativeapppath) throws ScraperException {
        String propFileName = appID + ".properties";
        String propFileContent = ScrapperMain.loadScraperFile(appID, apiVersion, nativeapppath, propFileName);
        if (StringUtils.isNotBlank((String)propFileContent)) {
            Properties scraperProps = new Properties();
            try {
                scraperProps.load(new StringReader(propFileContent));
            }
            catch (IOException e) {
                throw new ScraperException(prop_file_Not_Found_ERROR, e.getMessage(), e);
            }
            for (String key : scraperProps.stringPropertyNames()) {
                try {
                    String value = ((String)scraperProps.get(key)).trim();
                    try {
                        if (key.equalsIgnoreCase("debug")) {
                            DEBUG = value == null || value.trim().length() == 0 ? DEBUG_DISABLE : value;
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    try {
                        if (key.equalsIgnoreCase("connlib")) {
                            connectionLibrary = value == null || value.trim().length() == 0 ? "httpclient" : value;
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    try {
                        if (key.equalsIgnoreCase("httpnocontent") && StringUtils.isNotBlank((String)value)) {
                            HTTPNOCONTENT = Integer.parseInt(value);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        HTTPNOCONTENT = 0;
                    }
                    try {
                        if (key.equalsIgnoreCase("httpnocontenttimer") && StringUtils.isNotBlank((String)value)) {
                            HTTPNOCONTENTTIMER = Integer.parseInt(value);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        HTTPNOCONTENTTIMER = 0;
                    }
                    try {
                        if (key.equalsIgnoreCase("user-agent") && value != null) {
                            USERAGENT = Boolean.parseBoolean(value.toLowerCase());
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        USERAGENT = false;
                    }
                    try {
                        if (key.equalsIgnoreCase("http.proxyhost")) {
                            HTTP_PROXY_HOST = value == null || value.trim().length() == 0 ? "" : value;
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    try {
                        if (key.equalsIgnoreCase("http.proxyport") && StringUtils.isNotBlank((String)value)) {
                            HTTP_PROXY_PORT = Integer.parseInt(value);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        HTTP_PROXY_PORT = 80;
                    }
                    try {
                        if (key.equalsIgnoreCase("http.proxyuser")) {
                            HTTP_PROXY_UNAME = value == null || value.trim().length() == 0 ? "" : value;
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    try {
                        if (key.equalsIgnoreCase("http.proxypassword")) {
                            HTTP_PROXY_PASSWD = value == null || value.trim().length() == 0 ? "" : value;
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    try {
                        if (key.equalsIgnoreCase("ntlm.domain")) {
                            NT_DOMAIN = value == null || value.trim().length() == 0 ? "" : value;
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    try {
                        if (key.equalsIgnoreCase("ntlm.host")) {
                            NT_HOST = value == null || value.trim().length() == 0 ? "" : value;
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    try {
                        if (key.equalsIgnoreCase("request.charset.encoding")) {
                            REQ_CHARSET_ENCODING = value == null || value.trim().length() == 0 ? "" : value;
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    try {
                        if (key.equalsIgnoreCase("response.charset.encoding")) {
                            RES_CHARSET_ENCODING = value == null || value.trim().length() == 0 ? "" : value;
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    try {
                        if (!key.equalsIgnoreCase("dynamic.postparam.delimiter")) continue;
                        if (value == null || value.trim().length() == 0) {
                            DYNAMIC_POSTPARAM_DELIMITER = "";
                            continue;
                        }
                        DYNAMIC_POSTPARAM_DELIMITER = value;
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        UrlUtil.populateConfigMap();
    }

    public static String loadScraperFile(String appId, String apiVersion, String nativeapppath, String fileName) {
        AppVersion appIdVersion = new AppVersion(appId, apiVersion);
        logger.debug((Object)("Loading assets for application Id : " + appIdVersion.getAppId() + ", version : " + appIdVersion.getVersion()));
        ApplicationMetadata appMetadata = (ApplicationMetadata)appCache.getAppMetadata(appIdVersion);
        logger.debug((Object)("Loading asset from application metadata : " + fileName));
        String assetType = AssetType.SCRAPPER.getType();
        String fileContent = (String)appMetadata.getAssetByName(assetType, fileName);
        if (fileContent == null) {
            logger.debug((Object)("Asset content is not found in metadata cache " + fileName));
            if (!MiddlewareUtils.isAmazonS3Support()) {
                try {
                    File filePath = new File(nativeapppath + fileName);
                    if (filePath.exists()) {
                        logger.debug((Object)("Loading asset from location : " + filePath.getAbsolutePath()));
                        fileContent = IOUtils.toString((InputStream)new FileInputStream(filePath));
                        HashMap<String, String> assetNameValueMap = new HashMap<String, String>();
                        assetNameValueMap.put(fileName, fileContent);
                        appMetadata.getAssetMap().put(assetType, assetNameValueMap);
                    }
                }
                catch (Exception e) {
                    logger.debug((Object)("Error while loading scrapper file : " + fileName), (Throwable)e);
                }
            }
        }
        return fileContent;
    }

    static ServiceDSL loadInitializeDSLs(String appID, String serviceID, HashMap serviceIdAppId, BufferedWriter writer) throws ScraperException {
        HashMap content = ScrapperMain.getDSLContent(serviceIdAppId, writer);
        String dslContent = (String)content.get("dslcontent");
        String[] splitDSLData = dslContent.split("-----");
        int splitDSLDataLength = splitDSLData.length;
        if (splitDSLDataLength < 2) {
            if (DEBUG.equalsIgnoreCase(ALL)) {
                ScrapperUtil.print("splitDSLDataLength ::  " + splitDSLDataLength, writer);
            }
            throw new ScraperException(seperater_ERROR, "splitDSLDataLength is " + splitDSLDataLength + " please seperate input and xpath by -----");
        }
        String inputDSLLogic = splitDSLData[0];
        String outputDSLLogic = splitDSLData[1];
        ServiceDSL serdsl = new ServiceDSL();
        serdsl.setInputString(inputDSLLogic);
        serdsl.setOutputTree(outputDSLLogic, writer);
        return serdsl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static HashMap getServiceIdAppId(HashMap config) throws ScraperException {
        String socketString;
        String appID = "";
        String apiVersion = "";
        String serviceID = "";
        String channel = "\n";
        HashMap<String, Object> output = null;
        OutputStreamWriter out = null;
        BufferedWriter writer = null;
        String nativeapppath = "";
        String logfolderpath = "";
        if (!config.containsKey("appID")) throw new ScraperException(appID_ERROR, "appID param not get in config parameters ");
        output = new HashMap<String, Object>();
        appID = (String)config.get("appID");
        output.put("appid", appID);
        if (config.containsKey("X-Kony-API-Version")) {
            apiVersion = (String)config.get("X-Kony-API-Version");
        }
        if (StringUtils.isBlank((String)apiVersion)) {
            apiVersion = MiddlewareUtils.getRuntimeVersion(appCache, appID);
        }
        output.put("X-Kony-API-Version", apiVersion);
        if (!config.containsKey("serviceID")) throw new ScraperException(serviceID_ERROR, "serviceID param not found in config parameters ");
        serviceID = (String)config.get("serviceID");
        output.put("serviceid", serviceID);
        if (config.containsKey("ignorehttpproxy")) {
            output.put("ignorehttpproxy", config.get("ignorehttpproxy").toString());
        }
        if (MODE.equalsIgnoreCase("IDE")) {
            nativeapppath = SCRAPPER_HOME + File.separator + appID + File.separator + "services" + File.separator + "webconnector" + File.separator + "dsl" + File.separator;
            logfolderpath = SCRAPPER_HOME + File.separator + "temp" + File.separator + appID + File.separator + "scraper" + File.separator + "logs";
        } else {
            nativeapppath = ConfigPathUtil.getMiddlewareHome() + File.separator + "genericscrapper" + File.separator + appID + File.separator;
            logfolderpath = nativeapppath + "logs";
        }
        if (MiddlewareUtils.isAmazonS3Support()) {
            nativeapppath = appID + File.separator + "services" + File.separator + "webconnector" + File.separator;
            logfolderpath = System.getProperty("catalina.home") + File.separator + "logs" + File.separator + "scraper" + File.separator + appID + File.separator;
        }
        logger.info((Object)("Scraper files folder path <<<< ::::::: >>>> " + nativeapppath));
        logger.info((Object)("Scraper logs folder path <<<< ::::::: >>>> " + logfolderpath));
        output.put("nativeapppath", nativeapppath);
        output.put("logfolderpath", logfolderpath);
        Integer socketTime = MWConstants.DEFAULT_TIMEOUT_VALUE;
        if (config.containsKey("sockettimeout") && StringUtils.isNotBlank((String)(socketString = (String)config.get("sockettimeout")))) {
            socketTime = Integer.valueOf(socketString);
        }
        output.put("sockettimeout", socketTime);
        ScrapperMain.readPropertiesFile(appID, apiVersion, nativeapppath);
        if (logfolderpath != null && (DEBUG.equalsIgnoreCase(ALL) || DEBUG.equalsIgnoreCase(ERROR))) {
            try {
                new File(logfolderpath).mkdirs();
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(logfolderpath + File.separator + serviceID + ".log", true), "UTF-8");
                if (writer == null) {
                    writer = new BufferedWriter(out);
                }
                Date date = new Date();
                writer.newLine();
                ScrapperUtil.print(date.toString() + " <<<< ::::::: >>>>" + serviceID, writer);
                if (DEBUG.equalsIgnoreCase(ALL)) {
                    ScrapperUtil.print("CONFIG PARAM  FROM MIDDLEWARE ::: " + config, writer);
                }
                output.put("bufferedwriter", writer);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new ScraperException("11143", e.getMessage());
            }
        }
        if (!config.containsKey("channel")) throw new ScraperException(channel_ERROR, "channel param not found in config parameters ");
        String channel_key = (String)config.get("channel");
        if ("tc".equalsIgnoreCase(channel_key)) {
            channel = "<br>";
        } else if ("rc".equalsIgnoreCase(channel_key)) {
            channel = "\n";
        } else if ("wap".equalsIgnoreCase(channel_key)) {
            channel = "<br>";
        }
        output.put("channel", channel);
        return output;
    }

    public static Result getGenericScrapperData(HashMap config, HashMap postdata, HashMap tMap, boolean flag) throws ScraperException {
        if (flag) {
            MODE = "IDE";
        }
        return ScrapperMain.getGenericScrapperData(config, postdata, tMap);
    }

    public static Result getGenericScrapperData(HashMap config, HashMap postdata, HashMap tMap) throws ScraperException {
        HashMap input = null;
        BufferedWriter writer = null;
        boolean writerClosingFlag = true;
        try {
            String error_value;
            HashMap hashOfRecords;
            int hashOfRecordsLength;
            HashMap serviceIdAppId = ScrapperMain.getServiceIdAppId(config);
            writer = (BufferedWriter)serviceIdAppId.get("bufferedwriter");
            String serviceID = (String)serviceIdAppId.get("serviceid");
            String appID = (String)serviceIdAppId.get("appid");
            System.out.println("ServiceID= " + serviceID + " AppID = " + appID);
            ServiceDSL serviceDslObj = ScrapperMain.loadInitializeDSLs(appID, serviceID, serviceIdAppId, writer);
            input = ScrapperLogic.scrapperMain(serviceIdAppId, postdata, tMap, serviceDslObj);
            if (serviceIdAppId != null) {
                serviceIdAppId.clear();
                serviceIdAppId = null;
            }
            Result result = new Result();
            for (String key : input.keySet()) {
                List final_rec;
                if (input.get(key) != null && key.startsWith("parsingdataset")) {
                    final_rec = (List)input.get(key);
                    int arraySize = final_rec.size();
                    if (arraySize != 1) {
                        throw new Exception("Error in internal processing of VTD data");
                    }
                    List datasetArray = (List)final_rec.get(0);
                    int datasetArrayLen = datasetArray.size();
                    for (int i = 0; i < datasetArrayLen; ++i) {
                        Dataset dt = (Dataset)datasetArray.get(i);
                        result.addDataset(dt);
                    }
                    continue;
                }
                if (input.get(key) == null || !key.startsWith("newparsingdataset")) continue;
                final_rec = (List)input.get(key);
                Dataset dt = (Dataset)final_rec.get(0);
                result.addDataset(dt);
            }
            HashMap flds_only = (HashMap)input.get("flds_only");
            int flds_onlyLength = flds_only.size();
            if (flds_onlyLength > 0) {
                for (String key : flds_only.keySet()) {
                    String value = "";
                    if (flds_only.get(key) != null) {
                        value = (String)flds_only.get(key);
                    }
                    if (key.equalsIgnoreCase("opstatus")) {
                        result.addParam(ScrapperUtil.getKonyParam(key, value, "int"));
                        continue;
                    }
                    if (key.equalsIgnoreCase("httpStatusCode")) {
                        result.addParam(ScrapperUtil.getKonyParam(key, value, "int"));
                        continue;
                    }
                    result.addParam(ScrapperUtil.getKonyParam(key, value));
                }
            }
            if (((String)flds_only.get("opstatus")).equalsIgnoreCase(DEBUG_DISABLE) && input.containsKey("records") && (hashOfRecordsLength = (hashOfRecords = (HashMap)input.get("records")).size()) > 0) {
                for (String mainKey : hashOfRecords.keySet()) {
                    Dataset dataset = new Dataset();
                    dataset.setId(mainKey);
                    List arrayofhash = (List)hashOfRecords.get(mainKey);
                    int arrayofhashLength = arrayofhash.size();
                    if (arrayofhashLength > 0) {
                        for (int j = 0; j < arrayofhashLength; ++j) {
                            Record rec = new Record();
                            HashMap subHash = (HashMap)arrayofhash.get(j);
                            for (String key : subHash.keySet()) {
                                if (key.equals("innerrecord")) {
                                    HashMap inner_record_hash = (HashMap)subHash.get(key);
                                    int inner_record_hash_length = inner_record_hash.size();
                                    if (inner_record_hash_length <= 0) continue;
                                    for (String inner_rec_main_key : inner_record_hash.keySet()) {
                                        Dataset inner_rec_dataset = new Dataset();
                                        inner_rec_dataset.setId(inner_rec_main_key);
                                        List array_of_inner_rec = (List)inner_record_hash.get(inner_rec_main_key);
                                        int array_of_inner_rec_len = array_of_inner_rec.size();
                                        if (array_of_inner_rec_len > 0) {
                                            for (int k = 0; k < array_of_inner_rec_len; ++k) {
                                                Record inner_rec = new Record();
                                                HashMap inner_sub_hash = (HashMap)array_of_inner_rec.get(k);
                                                for (String inner_sub_key : inner_sub_hash.keySet()) {
                                                    String inner_sub_value = (String)inner_sub_hash.get(inner_sub_key);
                                                    inner_rec.addParam(ScrapperUtil.getKonyParam(inner_sub_key, inner_sub_value));
                                                }
                                                inner_rec_dataset.addRecord(inner_rec);
                                            }
                                        }
                                        rec.addDataset(inner_rec_dataset);
                                    }
                                    continue;
                                }
                                String value = (String)subHash.get(key);
                                rec.addParam(ScrapperUtil.getKonyParam(key, value));
                            }
                            dataset.addRecord(rec);
                        }
                    }
                    result.addDataset(dataset);
                }
            }
            if (input.containsKey("founderror") && (error_value = ((String)input.get("founderror")).trim()).length() != 0) {
                result.addParam(ScrapperUtil.getKonyParam("errmsg", error_value));
                result.getParamByName("opstatus").setValue("1");
            }
            if (DEBUG.equalsIgnoreCase(ALL)) {
                Result copyResult = result;
                for (String key : MiddlewareValidationListener.getKeyList()) {
                    for (Param param : copyResult.getAllParams()) {
                        if (!key.equals(param.getName())) continue;
                        param.setValue("****");
                    }
                }
                if (writer != null && writerClosingFlag) {
                    ScrapperUtil.print("Final JSON RESULT :::  " + ResultToJSON.convert((Result)copyResult), writer);
                    writer.close();
                    writerClosingFlag = false;
                }
            }
            if (input != null) {
                input.clear();
                input = null;
            }
            Result result2 = result;
            return result2;
        }
        catch (ScraperException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            if ((DEBUG.equalsIgnoreCase(ALL) || DEBUG.equalsIgnoreCase(ERROR)) && writer != null && writerClosingFlag) {
                ScrapperUtil.print(ScrapperUtil.getStackTrace(e), writer);
                ScrapperUtil.print(e.getErrorCode() + " " + e.getErrorMessage(), writer);
                Closer.closeQuietly((Closeable)writer);
                writerClosingFlag = false;
            }
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            if ((DEBUG.equalsIgnoreCase(ALL) || DEBUG.equalsIgnoreCase(ERROR)) && writer != null && writerClosingFlag) {
                ScrapperUtil.print(ScrapperUtil.getStackTrace(e), writer);
                ScrapperUtil.print("11143 " + e.getMessage(), writer);
                Closer.closeQuietly((Closeable)writer);
                writerClosingFlag = false;
            }
            throw new ScraperException("11143", e.getMessage(), e);
        }
        finally {
            if ((DEBUG.equalsIgnoreCase(ALL) || DEBUG.equalsIgnoreCase(ERROR)) && writer != null && writerClosingFlag) {
                ScrapperUtil.print("finally block of main method", writer);
                Closer.closeQuietly((Closeable)writer);
                writerClosingFlag = false;
            }
        }
    }

    public static void clearDSLHash() {
        DEBUG = DEBUG_DISABLE;
        connectionLibrary = "httpclient";
        HTTPNOCONTENT = 0;
        USERAGENT = false;
        HTTPNOCONTENTTIMER = 0;
        HTTP_PROXY_HOST = "";
        HTTP_PROXY_PORT = 80;
        HTTP_PROXY_UNAME = "";
        HTTP_PROXY_PASSWD = "";
    }

    public static Dataset addDatasetsToResult(HashMap input, String datasetKey) {
        Dataset dataset = new Dataset();
        List list = (List)input.get(datasetKey);
        for (HashMap map : list) {
            Record record = new Record();
            for (String key : map.keySet()) {
                Object val = map.get(key);
                if (val instanceof String) {
                    record.addParam(new Param(key, (String)val, "String"));
                    continue;
                }
                if (!(val instanceof HashMap) || !key.equalsIgnoreCase("innerrecord")) continue;
                List<Dataset> innerDataset = ScrapperMain.getInnerRecord((HashMap)val);
                Iterator<Dataset> innerIt = innerDataset.iterator();
                while (innerIt.hasNext()) {
                    record.addDataset(innerIt.next());
                }
            }
            dataset.addRecord(record);
        }
        return dataset;
    }

    private static List<Dataset> getInnerRecord(HashMap innerMap) {
        ArrayList<Dataset> dataset = new ArrayList<Dataset>();
        for (String key : innerMap.keySet()) {
            Object val = innerMap.get(key);
            if (!(val instanceof List)) continue;
            Dataset datasetInner = ScrapperMain.addDatasetsToResult(innerMap, key);
            datasetInner.setId(key);
            dataset.add(datasetInner);
        }
        return dataset;
    }
}

