/*
 * Decompiled with CFR 0.152.
 */
package com.kony.scrapper.gc;

import com.kony.scrapper.gc.ScraperException;
import com.kony.scrapper.gc.ScrapperMain;
import com.kony.scrapper.gc.ScrapperUtil;
import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.common.MWConstants;
import com.konylabs.middleware.common.MiddlewareValidationListener;
import com.konylabs.middleware.connectors.ConnectorUtils;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.controller.impl.DataControllerResponseImpl;
import com.konylabs.middleware.utilities.MaskUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;

public class UrlUtil {
    private static final HostnameVerifier verify = new MyVerifier();
    private static HashMap<String, String> configMap = new HashMap();

    public static void populateConfigMap() {
        configMap.put(ConnectorUtils.PROXY_HOST, ScrapperMain.HTTP_PROXY_HOST);
        configMap.put(ConnectorUtils.PROXY_PORT, ScrapperMain.HTTP_PROXY_PORT + "");
        configMap.put(ConnectorUtils.PROXY_PWD, ScrapperMain.HTTP_PROXY_PASSWD);
        configMap.put(ConnectorUtils.PROXY_USERID, ScrapperMain.HTTP_PROXY_UNAME);
        configMap.put("sockettimeout", String.valueOf(MWConstants.DEFAULT_TIMEOUT_VALUE));
        if ("ntlm".equals(ScrapperMain.NT_MODE)) {
            configMap.put("server.auth.mode", ScrapperMain.NT_MODE);
            configMap.put("userid", ScrapperMain.NT_USER);
            configMap.put("pwd", ScrapperMain.NT_PASS);
            configMap.put("server.auth.ntlm.domain", ScrapperMain.NT_DOMAIN);
            configMap.put("server.auth.host", ScrapperMain.NT_HOST);
        }
    }

    private static String stream2String(InputStream in, int contentLength, String Charset2) throws Exception {
        int len;
        if (contentLength > 0) {
            byte[] buffer = new byte[contentLength];
            DataInputStream dis = new DataInputStream(in);
            dis.readFully(buffer);
            return new String(buffer, Charset2);
        }
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, Charset2));
        char[] chBuf = new char[1000];
        while ((len = reader.read(chBuf)) > 0) {
            buffer.append(chBuf, 0, len);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(HttpURLConnection conn, HashMap contentHash, HashMap headers, HashMap repteatedPostParam, BufferedWriter writer) throws Exception {
        int response_code;
        Set s = headers.entrySet();
        for (Map.Entry o : s) {
            Object headerKey = o.getKey();
            Object headerValue = o.getValue();
            if (headerKey == null || headerValue == null) continue;
            conn.setRequestProperty((String)headerKey, (String)headerValue);
        }
        if (contentHash != null && contentHash.size() != 0) {
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setInstanceFollowRedirects(false);
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            StringBuffer content = new StringBuffer();
            Iterator e = contentHash.keySet().iterator();
            boolean first = true;
            while (e.hasNext()) {
                Object key = e.next();
                Object value = contentHash.get(key);
                if (!first) {
                    content.append("&");
                }
                if (repteatedPostParam != null && repteatedPostParam.size() > 0) {
                    for (Map.Entry o : repteatedPostParam.entrySet()) {
                        String repeatedKey = o.getKey().toString();
                        String[] commaSplitter = o.getValue().toString().split(",");
                        for (int i = 0; i < commaSplitter.length; ++i) {
                            content.append(repeatedKey).append("=").append(URLEncoder.encode(commaSplitter[i].toString()));
                        }
                    }
                }
                if (((String)value).contains("`")) {
                    String[] values = ((String)value).split("`");
                    for (int i = 0; i < values.length; ++i) {
                        content.append((String)key).append("=").append(URLEncoder.encode(values[i]));
                    }
                } else {
                    content.append((String)key).append("=").append(URLEncoder.encode((String)value));
                }
                first = false;
            }
            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                ScrapperUtil.print("content parameters in getContent() method of UrlUtil::::" + content.toString(), writer);
            }
            out.writeBytes(content.toString());
            out.flush();
            out.close();
        }
        InputStream in = conn.getInputStream();
        for (int i = 0; i < 3 && (response_code = conn.getResponseCode()) == 204; ++i) {
            in = conn.getInputStream();
        }
        String contentType = conn.getHeaderField("Content-Type");
        String charset = "";
        if (contentType != null) {
            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                ScrapperUtil.print("Response Charset from server:::  " + contentType, writer);
            }
            charset = UrlUtil.getCharset(contentType);
        }
        if (charset.trim().length() == 0) {
            charset = "UTF-8";
        }
        if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
            ScrapperUtil.print("Response Charset :::  " + charset, writer);
        }
        try {
            String string = UrlUtil.stream2String(in, conn.getContentLength(), charset);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static ArrayList urlConnGetMethod(String targetURL, HashMap headers, String javascrenbl, Integer socketTimeOut, BufferedWriter writer) throws ScraperException {
        ArrayList output = new ArrayList();
        String cookie = "";
        String htmlContent = "";
        String tempTargetUrl = targetURL;
        try {
            int lastIndexOfSemiColon;
            if (ScrapperMain.HTTP_PROXY_HOST.length() > 0) {
                System.setProperty("http.proxyHost", ScrapperMain.HTTP_PROXY_HOST);
                System.setProperty("http.proxyPort", Integer.toString(ScrapperMain.HTTP_PROXY_PORT));
                if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                    ScrapperUtil.print("HTTP_PROXY_HOST : " + ScrapperMain.HTTP_PROXY_HOST + "  HTTP_PROXY_PORT: " + ScrapperMain.HTTP_PROXY_PORT + "  HTTP_PROXY_UNAME: " + ScrapperMain.HTTP_PROXY_UNAME + "  HTTP_PROXY_PASSWD: " + ScrapperMain.HTTP_PROXY_PASSWD, writer);
                }
            }
            URL url = new URL(targetURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(socketTimeOut);
            if ("mr".equalsIgnoreCase(javascrenbl)) {
                HttpURLConnection.setFollowRedirects(false);
            }
            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                ScrapperUtil.print("header parameters in getMethod of UrlUtil::::" + headers.toString(), writer);
            }
            if (conn instanceof HttpsURLConnection) {
                if (ScrapperMain.HTTP_PROXY_HOST.length() > 0) {
                    System.setProperty("https.proxyHost", ScrapperMain.HTTP_PROXY_HOST);
                    System.setProperty("https.proxyPort", Integer.toString(ScrapperMain.HTTP_PROXY_PORT));
                    if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                        ScrapperUtil.print("HTTP_PROXY_HOST : " + ScrapperMain.HTTP_PROXY_HOST + "  HTTP_PROXY_PORT: " + ScrapperMain.HTTP_PROXY_PORT + "  HTTP_PROXY_UNAME: " + ScrapperMain.HTTP_PROXY_UNAME + "  HTTP_PROXY_PASSWD: " + ScrapperMain.HTTP_PROXY_PASSWD, writer);
                    }
                }
                HttpsURLConnection httpconn = (HttpsURLConnection)conn;
                httpconn.setHostnameVerifier(verify);
                htmlContent = UrlUtil.getContent(httpconn, null, headers, null, writer);
                int i = 0;
                while (true) {
                    String headerName = conn.getHeaderFieldKey(i);
                    String headerValue = conn.getHeaderField(i);
                    if (headerName != null || headerValue != null) {
                        if ("Set-Cookie".equalsIgnoreCase(headerName)) {
                            String[] splitter = headerValue.split(";");
                            cookie = splitter.length > 0 ? cookie + splitter[0] + "; " : cookie + headerValue + "; ";
                        }
                        if ("location".equalsIgnoreCase(headerName)) {
                            targetURL = headerValue;
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                htmlContent = UrlUtil.getContent(conn, null, headers, null, writer);
                int i = 0;
                while (true) {
                    String headerName = conn.getHeaderFieldKey(i);
                    String headerValue = conn.getHeaderField(i);
                    if (headerName == null && headerValue == null) break;
                    if ("Set-Cookie".equalsIgnoreCase(headerName)) {
                        String[] splitter = headerValue.split(";");
                        cookie = splitter.length > 0 ? cookie + splitter[0] + ";" : cookie + headerValue + ";";
                    }
                    if ("location".equalsIgnoreCase(headerName)) {
                        targetURL = headerValue;
                    }
                    ++i;
                }
            }
            if ((lastIndexOfSemiColon = cookie.lastIndexOf(";")) >= 0) {
                cookie = cookie.substring(0, lastIndexOfSemiColon);
            }
            if (headers.containsKey("Cookie")) {
                Object cookieObj = headers.get("Cookie");
                if (cookieObj != null) {
                    cookie = UrlUtil.getCombinedCookies((String)cookieObj, cookie);
                }
                headers.put("Cookie", cookie);
            }
            output.add(htmlContent);
            output.add(cookie);
            output.add(targetURL);
            int responsecode = conn.getResponseCode();
            output.add(responsecode);
            if ("mr".equalsIgnoreCase(javascrenbl) && (responsecode == 302 || responsecode == 301 || responsecode == 303)) {
                if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                    ScrapperUtil.print("location param in getMethod()of UrlUtil::::" + targetURL, writer);
                    ScrapperUtil.print("new header params for Location in getMethod()of UrlUtil::::" + headers.toString(), writer);
                }
                if (!targetURL.toLowerCase().startsWith("http://") && !targetURL.toLowerCase().startsWith("https://")) {
                    targetURL = UrlUtil.extractDomain(tempTargetUrl, targetURL);
                }
                output.clear();
                output = UrlUtil.urlConnGetMethod(targetURL, headers, javascrenbl, socketTimeOut, writer);
            }
        }
        catch (IOException e) {
            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL") || ScrapperMain.DEBUG.equalsIgnoreCase("ERROR")) {
                ScrapperUtil.print(ScrapperUtil.getStackTrace(e), writer);
            }
            throw new ScraperException("9001", e.getMessage());
        }
        catch (Exception e) {
            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL") || ScrapperMain.DEBUG.equalsIgnoreCase("ERROR")) {
                ScrapperUtil.print(ScrapperUtil.getStackTrace(e), writer);
            }
            throw new ScraperException("11138", e.getMessage());
        }
        return output;
    }

    public static ArrayList urlConnPostMethod(String targetURL, HashMap postdata, HashMap headers, String javascrenbl, HashMap repteatedPostParam, Integer socketTimeOut, BufferedWriter writer) throws ScraperException {
        ArrayList output = new ArrayList();
        String cookie = "";
        String htmlContent = "";
        String tempTargetUrl = targetURL;
        try {
            int lastIndexOfSemiColon;
            if (ScrapperMain.HTTP_PROXY_HOST.length() > 0) {
                System.setProperty("http.proxyHost", ScrapperMain.HTTP_PROXY_HOST);
                System.setProperty("http.proxyPort", Integer.toString(ScrapperMain.HTTP_PROXY_PORT));
                if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                    ScrapperUtil.print("HTTP_PROXY_HOST : " + ScrapperMain.HTTP_PROXY_HOST + "  HTTP_PROXY_PORT: " + ScrapperMain.HTTP_PROXY_PORT + "  HTTP_PROXY_UNAME: " + ScrapperMain.HTTP_PROXY_UNAME + "  HTTP_PROXY_PASSWD: " + ScrapperMain.HTTP_PROXY_PASSWD, writer);
                }
            }
            URL url = new URL(targetURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(socketTimeOut);
            if ("mr".equalsIgnoreCase(javascrenbl)) {
                HttpURLConnection.setFollowRedirects(false);
            }
            HashMap<String, String> newPostData = new HashMap<String, String>();
            if (postdata.size() > 0) {
                for (Map.Entry o : postdata.entrySet()) {
                    String key = "";
                    String value = "";
                    key = null == o.getKey() ? "null" : o.getKey().toString();
                    value = null == o.getValue() ? "null" : o.getValue().toString();
                    newPostData.put(key, value);
                }
                postdata.clear();
            }
            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                ScrapperUtil.printMap("post parameters in postMethod of UrlUtil::::", newPostData, writer);
                ScrapperUtil.print("header parameters in postMethod of UrlUtil::::" + headers.toString(), writer);
            }
            if (conn instanceof HttpsURLConnection) {
                if (ScrapperMain.HTTP_PROXY_HOST.length() > 0) {
                    System.setProperty("https.proxyHost", ScrapperMain.HTTP_PROXY_HOST);
                    System.setProperty("https.proxyPort", Integer.toString(ScrapperMain.HTTP_PROXY_PORT));
                    if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                        ScrapperUtil.print("HTTP_PROXY_HOST : " + ScrapperMain.HTTP_PROXY_HOST + "  HTTP_PROXY_PORT: " + ScrapperMain.HTTP_PROXY_PORT + "  HTTP_PROXY_UNAME: " + ScrapperMain.HTTP_PROXY_UNAME + "  HTTP_PROXY_PASSWD: " + ScrapperMain.HTTP_PROXY_PASSWD, writer);
                    }
                }
                HttpsURLConnection httpconn = (HttpsURLConnection)conn;
                httpconn.setHostnameVerifier(verify);
                htmlContent = UrlUtil.getContent(httpconn, newPostData, headers, repteatedPostParam, writer);
                int i = 0;
                while (true) {
                    String headerName = conn.getHeaderFieldKey(i);
                    String headerValue = conn.getHeaderField(i);
                    if (headerName != null || headerValue != null) {
                        if ("Set-Cookie".equalsIgnoreCase(headerName)) {
                            String[] splitter = headerValue.split(";");
                            cookie = splitter.length > 0 ? cookie + splitter[0] + ";" : cookie + headerValue + ";";
                        }
                        if ("location".equalsIgnoreCase(headerName)) {
                            targetURL = headerValue;
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                htmlContent = UrlUtil.getContent(conn, newPostData, headers, repteatedPostParam, writer);
                int i = 0;
                while (true) {
                    String headerName = conn.getHeaderFieldKey(i);
                    String headerValue = conn.getHeaderField(i);
                    if (headerName == null && headerValue == null) break;
                    if ("Set-Cookie".equalsIgnoreCase(headerName)) {
                        String[] splitter = headerValue.split(";");
                        cookie = splitter.length > 0 ? cookie + splitter[0] + ";" : cookie + headerValue + ";";
                    }
                    if ("location".equalsIgnoreCase(headerName)) {
                        targetURL = headerValue;
                    }
                    ++i;
                }
            }
            if ((lastIndexOfSemiColon = cookie.lastIndexOf(";")) >= 0) {
                cookie = cookie.substring(0, lastIndexOfSemiColon);
            }
            if (headers.containsKey("Cookie")) {
                Object cookieObj = headers.get("Cookie");
                if (cookieObj != null) {
                    cookie = UrlUtil.getCombinedCookies((String)cookieObj, cookie);
                }
                headers.put("Cookie", cookie);
            }
            output.add(htmlContent);
            output.add(cookie);
            output.add(targetURL);
            int responsecode = conn.getResponseCode();
            output.add(responsecode);
            if ("mr".equalsIgnoreCase(javascrenbl) && (responsecode == 302 || responsecode == 301 || responsecode == 303)) {
                if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                    ScrapperUtil.print("location param in getMethod()of UrlUtil::::" + targetURL, writer);
                    ScrapperUtil.print("new header params for Location in getMethod()of UrlUtil::::" + headers.toString(), writer);
                }
                if (!targetURL.toLowerCase().startsWith("http://") && !targetURL.toLowerCase().startsWith("https://")) {
                    targetURL = UrlUtil.extractDomain(tempTargetUrl, targetURL);
                }
                output.clear();
                output = UrlUtil.urlConnGetMethod(targetURL, headers, javascrenbl, socketTimeOut, writer);
            }
        }
        catch (IOException e) {
            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL") || ScrapperMain.DEBUG.equalsIgnoreCase("ERROR")) {
                ScrapperUtil.print(ScrapperUtil.getStackTrace(e), writer);
            }
            throw new ScraperException("9001", e.getMessage());
        }
        catch (Exception e) {
            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL") || ScrapperMain.DEBUG.equalsIgnoreCase("ERROR")) {
                ScrapperUtil.print(ScrapperUtil.getStackTrace(e), writer);
            }
            throw new ScraperException("11138", e.getMessage());
        }
        return output;
    }

    public static ArrayList httpClientPost(String targetUrl, HashMap postdata, HashMap headers, String javascrenbl, ArrayList repeatedArrayFormation, Integer socketTimeOut, BufferedWriter writer) throws ScraperException {
        ArrayList output;
        block50: {
            output = new ArrayList();
            HttpPost post = null;
            CloseableHttpClient defaultHttpClient = null;
            try {
                post = new HttpPost(targetUrl);
                ConnectorUtils.disableEnableRedirect((HttpRequestBase)post, javascrenbl);
                defaultHttpClient = ConnectorUtils.getSingleHttpClient();
                int postdataSize = repeatedArrayFormation.size() + postdata.size();
                ArrayList<Object> parameters = new ArrayList<Object>(postdataSize);
                if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                    ScrapperUtil.print("Size of NameValue Pair to be passed in HTTPPOST  ::: " + postdataSize, writer);
                }
                if (postdata.size() > 0) {
                    for (Map.Entry o : postdata.entrySet()) {
                        String key = "";
                        String value = "";
                        key = null == o.getKey() ? "null" : o.getKey().toString();
                        value = null == o.getValue() ? "null" : o.getValue().toString();
                        if (value.contains("`")) {
                            String[] values = value.split("`");
                            for (int i = 0; i < values.length; ++i) {
                                parameters.add(new BasicNameValuePair(key, values[i]));
                            }
                            continue;
                        }
                        parameters.add(new BasicNameValuePair(key, value));
                    }
                }
                if (repeatedArrayFormation.size() > 0) {
                    for (int i = 0; i < repeatedArrayFormation.size(); ++i) {
                        parameters.add((NameValuePair)repeatedArrayFormation.get(i));
                    }
                }
                UrlEncodedFormEntity entity = null;
                if (StringUtils.isNotBlank((String)ScrapperMain.REQ_CHARSET_ENCODING)) {
                    ScrapperUtil.print("Charset Encoding in urlutil " + ScrapperMain.REQ_CHARSET_ENCODING, writer);
                    entity = new UrlEncodedFormEntity(parameters, ScrapperMain.REQ_CHARSET_ENCODING);
                } else {
                    entity = new UrlEncodedFormEntity(parameters);
                }
                post.setEntity((HttpEntity)entity);
                if (headers.size() > 0) {
                    Set keySet = headers.keySet();
                    for (String key : keySet) {
                        post.addHeader(key, (String)headers.get(key));
                    }
                }
                if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                    int i;
                    for (i = 0; i < post.getAllHeaders().length; ++i) {
                        ScrapperUtil.print("header parameters passing to httpClientPost in urlutil  ::::" + post.getAllHeaders()[i].getName() + " : " + post.getAllHeaders()[i].getValue(), writer);
                    }
                    for (i = 0; i < parameters.size(); ++i) {
                        if (MiddlewareValidationListener.getKeyList().contains(((NameValuePair)parameters.get(i)).getName())) {
                            ScrapperUtil.print("Post parameters passing to httpClientPost in urlutil  ::::" + ((NameValuePair)parameters.get(i)).getName() + "=" + MaskUtils.maskString((String[])new String[]{((NameValuePair)parameters.get(i)).getValue()}), writer);
                            continue;
                        }
                        ScrapperUtil.print("Post parameters passing to httpClientPost in urlutil  ::::" + ((NameValuePair)parameters.get(i)).getName() + "=" + ((NameValuePair)parameters.get(i)).getValue(), writer);
                    }
                }
                repeatedArrayFormation.clear();
                postdata.clear();
                if ("1".equals(javascrenbl)) {
                    break block50;
                }
                try {
                    DataControllerResponseImpl response = new DataControllerResponseImpl();
                    BasicCookieStore cookieStore = new BasicCookieStore();
                    ConnectorUtils.executeMethodAndRetrieveCookies(defaultHttpClient, (HttpRequestBase)post, (DataControllerResponse)response, configMap, (CookieStore)cookieStore, "UTF-8", null);
                    int responseCode = response.getStatusCode();
                    if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                        ScrapperUtil.print("Response Code of page before SC_NO_CONTENT:::  " + responseCode, writer);
                    }
                    if (responseCode == 204) {
                        if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                            ScrapperUtil.print("HTTP_NO_CONTENT iterate for: " + ScrapperMain.HTTPNOCONTENT, writer);
                            ScrapperUtil.print("HTTP_NO_CONTENT_TIMER for each iteration: " + ScrapperMain.HTTPNOCONTENTTIMER, writer);
                        }
                        for (int i = 0; i < ScrapperMain.HTTPNOCONTENT; ++i) {
                            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                                ScrapperUtil.print("Response Code inside for loop : " + responseCode, writer);
                            }
                            Thread.sleep(ScrapperMain.HTTPNOCONTENTTIMER);
                            response = new DataControllerResponseImpl();
                            cookieStore = new BasicCookieStore();
                            ConnectorUtils.executeMethodAndRetrieveCookies(defaultHttpClient, (HttpRequestBase)post, (DataControllerResponse)response, configMap, (CookieStore)cookieStore, "UTF-8", null);
                            responseCode = response.getStatusCode();
                            if (responseCode == 200) break;
                        }
                    }
                    if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                        ScrapperUtil.print("Response Code of page After SC_NO_CONTENT:::  " + responseCode, writer);
                    }
                    String htmlContent = response.getResponse();
                    output.add(htmlContent);
                    List cookies = response.getCookies();
                    String cookie = "";
                    if (cookies != null) {
                        cookie = UrlUtil.getCookieStringFromCookieArray(cookies);
                    }
                    if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                        ScrapperUtil.print("Output Cookie of Active service without addition of previous >> " + cookie, writer);
                    }
                    if (headers.containsKey("Cookie")) {
                        Object cookieObj = headers.get("Cookie");
                        if (cookieObj != null) {
                            cookie = UrlUtil.getCombinedCookies((String)cookieObj, cookie);
                        }
                        headers.put("Cookie", cookie);
                    }
                    output.add(cookie);
                    output.add(targetUrl);
                    output.add(response.getStatusCode());
                    if ("mr".equalsIgnoreCase(javascrenbl) && (responseCode == 302 || responseCode == 301 || responseCode == 303 || responseCode == 307)) {
                        String tempTargetUrl = targetUrl;
                        targetUrl = response.getLocation();
                        if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                            ScrapperUtil.print("targetURL for manual Redirection:::::" + targetUrl, writer);
                        }
                        if (!targetUrl.toLowerCase().startsWith("http://") && !targetUrl.toLowerCase().startsWith("https://")) {
                            targetUrl = UrlUtil.extractDomain(tempTargetUrl, targetUrl);
                        }
                        output.clear();
                        output = UrlUtil.httpClientGet(targetUrl, headers, javascrenbl, socketTimeOut, writer);
                    }
                    if (headers != null) {
                        headers.clear();
                    }
                }
                catch (IOException e) {
                    if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL") || ScrapperMain.DEBUG.equalsIgnoreCase("ERROR")) {
                        ScrapperUtil.print(ScrapperUtil.getStackTrace(e), writer);
                    }
                    throw new ScraperException("9001", e.getMessage());
                }
                catch (Exception e) {
                    if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL") || ScrapperMain.DEBUG.equalsIgnoreCase("ERROR")) {
                        ScrapperUtil.print(ScrapperUtil.getStackTrace(e), writer);
                    }
                    throw new ScraperException("11138", e.getMessage());
                }
            }
            catch (ScraperException e) {
                throw new ScraperException(e.getErrorCode(), e.getErrorMessage());
            }
            catch (Exception e) {
                if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL") || ScrapperMain.DEBUG.equalsIgnoreCase("ERROR")) {
                    ScrapperUtil.print(ScrapperUtil.getStackTrace(e), writer);
                }
                throw new ScraperException("11138", e.getMessage());
            }
            finally {
                if (headers != null) {
                    headers.clear();
                }
                if (postdata != null) {
                    postdata.clear();
                }
                if (repeatedArrayFormation != null) {
                    repeatedArrayFormation.clear();
                }
                try {
                    if (post != null) {
                        post.releaseConnection();
                    }
                }
                catch (Exception exception) {}
                Closer.closeQuietly((Closeable)defaultHttpClient);
            }
        }
        return output;
    }

    public static ArrayList httpClientGet(String targetUrl, HashMap headers, String javascrenbl, Integer socketTimeOut, BufferedWriter writer) throws ScraperException {
        ArrayList output;
        block41: {
            output = new ArrayList();
            HttpGet get = null;
            CloseableHttpClient defaultHttpClient = null;
            try {
                get = new HttpGet(targetUrl);
                ConnectorUtils.disableEnableRedirect((HttpRequestBase)get, javascrenbl);
                defaultHttpClient = ConnectorUtils.getSingleHttpClient();
                if (headers.size() > 0) {
                    Set keySet = headers.keySet();
                    for (String key : keySet) {
                        get.addHeader(key, (String)headers.get(key));
                    }
                }
                if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                    for (int i = 0; i < get.getAllHeaders().length; ++i) {
                        ScrapperUtil.print("header parameters passing to httpClientGet in urlutil  ::::" + get.getAllHeaders()[i].getName() + " : " + get.getAllHeaders()[i].getValue(), writer);
                    }
                }
                if ("1".equals(javascrenbl)) {
                    break block41;
                }
                try {
                    DataControllerResponseImpl response = new DataControllerResponseImpl();
                    BasicCookieStore cookieStore = new BasicCookieStore();
                    ConnectorUtils.executeMethodAndRetrieveCookies(defaultHttpClient, (HttpRequestBase)get, (DataControllerResponse)response, configMap, (CookieStore)cookieStore, "UTF-8", null);
                    int responsecode = response.getStatusCode();
                    if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                        ScrapperUtil.print("Response Code of page before:::  " + responsecode, writer);
                    }
                    if (responsecode == 204) {
                        if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                            ScrapperUtil.print("HTTP_NO_CONTENT iterate for: " + ScrapperMain.HTTPNOCONTENT, writer);
                            ScrapperUtil.print("HTTP_NO_CONTENT_TIMER for each iteration: " + ScrapperMain.HTTPNOCONTENTTIMER, writer);
                        }
                        for (int i = 0; i < ScrapperMain.HTTPNOCONTENT; ++i) {
                            if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                                ScrapperUtil.print("Response Code inside for loop : " + responsecode, writer);
                            }
                            Thread.sleep(ScrapperMain.HTTPNOCONTENTTIMER);
                            response = new DataControllerResponseImpl();
                            cookieStore = new BasicCookieStore();
                            ConnectorUtils.executeMethodAndRetrieveCookies(defaultHttpClient, (HttpRequestBase)get, (DataControllerResponse)response, configMap, (CookieStore)cookieStore, "UTF-8", null);
                            responsecode = response.getStatusCode();
                            if (responsecode == 200) break;
                        }
                    }
                    if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                        ScrapperUtil.print("Response Code of page After :::  " + responsecode, writer);
                    }
                    String htmlContent = response.getResponse();
                    output.add(htmlContent);
                    List cookies = response.getCookies();
                    String cookie = "";
                    if (cookies != null) {
                        cookie = UrlUtil.getCookieStringFromCookieArray(cookies);
                    }
                    if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                        ScrapperUtil.print("Output Cookie of Active service without addition of previous >> " + cookie, writer);
                    }
                    if (headers.containsKey("Cookie")) {
                        Object cookieObj = headers.get("Cookie");
                        if (cookieObj != null) {
                            cookie = UrlUtil.getCombinedCookies((String)cookieObj, cookie);
                        }
                        headers.put("Cookie", cookie);
                    }
                    output.add(cookie);
                    output.add(targetUrl);
                    output.add(response.getStatusCode());
                    if ("mr".equalsIgnoreCase(javascrenbl) && (responsecode == 302 || responsecode == 301 || responsecode == 303 || responsecode == 307)) {
                        String tempTargetUrl = targetUrl;
                        targetUrl = response.getLocation();
                        if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL")) {
                            ScrapperUtil.print("targetURL for manual Redirection:::::" + targetUrl, writer);
                        }
                        if (!targetUrl.toLowerCase().startsWith("http://") && !targetUrl.toLowerCase().startsWith("https://")) {
                            targetUrl = UrlUtil.extractDomain(tempTargetUrl, targetUrl);
                        }
                        output.clear();
                        output = UrlUtil.httpClientGet(targetUrl, headers, javascrenbl, socketTimeOut, writer);
                    }
                    if (headers != null) {
                        headers.clear();
                    }
                }
                catch (IOException e) {
                    if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL") || ScrapperMain.DEBUG.equalsIgnoreCase("ERROR")) {
                        ScrapperUtil.print(ScrapperUtil.getStackTrace(e), writer);
                    }
                    throw new ScraperException("9001", e.getMessage());
                }
                catch (Exception e) {
                    if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL") || ScrapperMain.DEBUG.equalsIgnoreCase("ERROR")) {
                        ScrapperUtil.print(ScrapperUtil.getStackTrace(e), writer);
                    }
                    throw new ScraperException("11138", e.getMessage());
                }
            }
            catch (ScraperException e) {
                throw new ScraperException(e.getErrorCode(), e.getErrorMessage());
            }
            catch (Exception e) {
                if (ScrapperMain.DEBUG.equalsIgnoreCase("ALL") || ScrapperMain.DEBUG.equalsIgnoreCase("ERROR")) {
                    ScrapperUtil.print(ScrapperUtil.getStackTrace(e), writer);
                }
                throw new ScraperException("11138", e.getMessage());
            }
            finally {
                if (headers != null) {
                    headers.clear();
                }
                try {
                    if (get != null) {
                        get.releaseConnection();
                    }
                }
                catch (Exception e1) {
                    throw new ScraperException("11138", e1.getMessage());
                }
                try {
                    Closer.closeQuietly((Closeable)defaultHttpClient);
                }
                catch (Exception e1) {
                    throw new ScraperException("11138", e1.getMessage());
                }
            }
        }
        return output;
    }

    private static String getCookieStringFromCookieArray(List<Cookie> cookieArray) {
        StringBuffer cookie = new StringBuffer();
        for (int i = 0; i < cookieArray.size(); ++i) {
            String cookieName = cookieArray.get(i).getName();
            String cookieValue = cookieArray.get(i).getValue();
            cookie = cookie.append(cookieName).append("=").append(cookieValue).append(";");
        }
        String retCookie = "";
        int lastIndexOfSemiColon = cookie.lastIndexOf(";");
        if (lastIndexOfSemiColon >= 0) {
            retCookie = cookie.substring(0, lastIndexOfSemiColon);
        }
        return retCookie;
    }

    private static HashMap getCookieHashFromString(String cookies) {
        HashMap<String, String> cookieMap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)cookies)) {
            String[] splitCookieByColon = cookies.split(";");
            int splitCookieByColonSize = splitCookieByColon.length;
            for (int j = 0; j < splitCookieByColonSize; ++j) {
                String[] splitByEqual = splitCookieByColon[j].split("=", 2);
                int splitByEqualSize = splitByEqual.length;
                if (splitByEqualSize <= 0) continue;
                String cookieKey = splitByEqual[0];
                String cookieValue = "";
                for (int k = 1; k < splitByEqualSize; ++k) {
                    cookieValue = cookieValue + splitByEqual[k] + "=";
                }
                int lastIndexOfEqual = cookieValue.lastIndexOf("=");
                if (lastIndexOfEqual >= 0) {
                    cookieValue = cookieValue.substring(0, lastIndexOfEqual);
                }
                cookieMap.put(cookieKey, cookieValue);
            }
        }
        return cookieMap;
    }

    private static String getCookieStringFromHash(HashMap cookieMap) {
        String cookie = "";
        if (cookieMap != null) {
            for (Object keyObj : cookieMap.keySet()) {
                if (null == keyObj) continue;
                String keyStr = keyObj.toString();
                Object keyObjVal = cookieMap.get(keyObj);
                if (null == keyObjVal) continue;
                String keyStrVal = keyObjVal.toString();
                cookie = cookie + keyStr + "=" + keyStrVal + ";";
            }
            int lastIndexOfSemiColon = cookie.lastIndexOf(";");
            if (lastIndexOfSemiColon >= 0) {
                cookie = cookie.substring(0, lastIndexOfSemiColon);
            }
        }
        return cookie;
    }

    private static String getCombinedCookies(String oldCookies, String newCookies) {
        HashMap oldCookieMap = UrlUtil.getCookieHashFromString(oldCookies);
        HashMap newCookiesMap = UrlUtil.getCookieHashFromString(newCookies);
        oldCookieMap.putAll(newCookiesMap);
        String cookie = UrlUtil.getCookieStringFromHash(oldCookieMap);
        return cookie;
    }

    private static String extractDomain(String targetURL, String newLocation) {
        String httpORhttps = "https://";
        if (targetURL.toLowerCase().startsWith("http://")) {
            httpORhttps = "http://";
        }
        String tempURL = targetURL.replace("http://", "").replace("https://", "");
        int firstIndexOfSlash = tempURL.indexOf("/");
        String urlDomain = tempURL;
        if (firstIndexOfSlash >= 0) {
            urlDomain = tempURL.substring(0, firstIndexOfSlash);
        }
        urlDomain = newLocation.startsWith("/") ? httpORhttps + urlDomain + newLocation : httpORhttps + urlDomain + "/" + newLocation;
        return urlDomain;
    }

    private static String getCharset(String responseCharset) {
        String Charset2 = "";
        String[] parts = responseCharset.split(";");
        for (int i = 0; i < parts.length; ++i) {
            if (!parts[i].trim().contains("charset")) continue;
            int len = parts[i].indexOf("=");
            Charset2 = parts[i].substring(len + 1, parts[i].length()).trim();
        }
        return Charset2;
    }

    public static void populateConfigMap(Map map) {
        configMap.putAll(map);
        UrlUtil.populateConfigMap();
    }

    public static class MyVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

