/*
 * Decompiled with CFR 0.152.
 */
package com.kony.scrapper.gc;

import com.kony.scrapper.gc.ScraperException;
import com.kony.scrapper.gc.ScrapperMain;
import com.kony.scrapper.gc.ScrapperUtil;
import com.kony.scrapper.gc.XPNSContext;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.dom.HtmlDocumentBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    private static final Logger LOGGER = Logger.getLogger(XmlUtils.class);
    private static Map<String, XPathExpression> compiledXpathCache = new HashMap<String, XPathExpression>();
    private static XPathFactory factory = XPathFactory.newInstance();

    public static Document getDocument(Reader inreader) {
        HtmlDocumentBuilder bldr = new HtmlDocumentBuilder(XmlViolationPolicy.ALTER_INFOSET);
        bldr.setIgnoringComments(true);
        InputSource input = new InputSource(inreader);
        if (StringUtils.isNotBlank((String)ScrapperMain.REQ_CHARSET_ENCODING)) {
            input.setEncoding(ScrapperMain.REQ_CHARSET_ENCODING);
        }
        Document doc = null;
        try {
            doc = bldr.parse(input);
        }
        catch (SAXException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        return doc;
    }

    public static Document getDocument(Reader inreader, BufferedWriter writer) throws ScraperException {
        HtmlDocumentBuilder bldr = new HtmlDocumentBuilder(XmlViolationPolicy.ALTER_INFOSET);
        bldr.setIgnoringComments(true);
        InputSource input = new InputSource(inreader);
        if (StringUtils.isNotBlank((String)ScrapperMain.RES_CHARSET_ENCODING)) {
            ScrapperUtil.print("response charset encoding " + ScrapperMain.RES_CHARSET_ENCODING, writer);
            input.setEncoding(ScrapperMain.RES_CHARSET_ENCODING);
        }
        Document doc = null;
        try {
            doc = bldr.parse(input);
        }
        catch (SAXException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        return doc;
    }

    public static Document getDocument(String s, BufferedWriter writer) throws Exception {
        return XmlUtils.getDocument(new StringReader(s), writer);
    }

    public static Document getDocument(String s) throws Exception {
        return XmlUtils.getDocument(new StringReader(s));
    }

    public static NodeList evalXPath(String xpstr, Node startNode) throws Exception {
        XPathExpression expr = null;
        if (compiledXpathCache.containsKey(xpstr)) {
            expr = compiledXpathCache.get(xpstr);
        } else {
            XPath xpath = factory.newXPath();
            Document doc = null;
            doc = startNode instanceof Document ? (Document)startNode : startNode.getOwnerDocument();
            String namespaceUri = doc.getDocumentElement().getNamespaceURI();
            XPNSContext xpctx = new XPNSContext(namespaceUri);
            xpath.setNamespaceContext(xpctx);
            expr = xpath.compile(xpstr);
            compiledXpathCache.put(xpstr, expr);
        }
        NodeList nodes = XmlUtils.evalCompiledXPath(expr, startNode);
        return nodes;
    }

    public static NodeList evalCompiledXPath(XPathExpression expr, Node startNode) throws Exception {
        Object result = expr.evaluate(startNode, XPathConstants.NODESET);
        NodeList nodes = (NodeList)result;
        return nodes;
    }

    public static ArrayList nodeList2ArrayList(NodeList nodes) throws Exception {
        ArrayList<Node> result = new ArrayList<Node>();
        if (nodes != null) {
            int l = nodes.getLength();
            for (int i = 0; i < l; ++i) {
                result.add(nodes.item(i));
            }
        }
        return result;
    }

    public static String getStringFromDocument(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException ex) {
            LOGGER.error((Object)ex, (Throwable)ex);
            return null;
        }
    }
}

