/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.devicecentral.client;

import com.konylabs.commons.exception.KonyDeviceCentralException;
import com.konylabs.commons.vo.Device;
import com.konylabs.devicecentral.api.DeviceCentralAccess;
import com.konylabs.devicecentral.api.apiimpl.DCAConsumerAPIImpl;
import com.konylabs.devicecentral.cache.DBCacheManager;
import com.konylabs.middleware.common.Closer;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class DeviceDBClientManager {
    private static final Logger LOGGER = Logger.getLogger(DeviceDBClientManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInitalSetIntoCache() {
        DBCacheManager dbCache = DBCacheManager.getInstance();
        DCAConsumerAPIImpl apiImpl = new DCAConsumerAPIImpl();
        Connection konyCentralConnection = DeviceCentralAccess.getConnection();
        try {
            ArrayList devices = apiImpl.getPopularDevices(konyCentralConnection);
            if (devices != null && !devices.isEmpty()) {
                this.updateCache(dbCache, devices);
            }
        }
        catch (KonyDeviceCentralException kdce) {
            LOGGER.error((Object)kdce.getMessage(), (Throwable)kdce);
        }
        finally {
            Closer.closeQuietly((AutoCloseable)konyCentralConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDevicesIntoCache() {
        DBCacheManager dbCache = DBCacheManager.getInstance();
        HashMap map = dbCache.getDeviceUAMap();
        if (map != null) {
            DCAConsumerAPIImpl apiImpl = new DCAConsumerAPIImpl();
            Connection konyCentralConnection = DeviceCentralAccess.getConnection();
            Set userAgentSet = map.keySet();
            String[] userAgentList = (String[])userAgentSet.toArray();
            try {
                ArrayList devices = apiImpl.getDevices(konyCentralConnection, userAgentList);
                if (devices != null && !devices.isEmpty()) {
                    this.updateCache(dbCache, devices);
                }
            }
            catch (KonyDeviceCentralException kdce) {
                LOGGER.error((Object)kdce.getMessage(), (Throwable)kdce);
            }
            finally {
                Closer.closeQuietly((AutoCloseable)konyCentralConnection);
            }
        }
    }

    private void updateCache(DBCacheManager dbCache, ArrayList<Device> devices) {
        boolean updated = false;
        Device updatedDevice = null;
        for (int i = 0; i < devices.size(); ++i) {
            updatedDevice = devices.get(i);
            updated = dbCache.putDevice(updatedDevice.getDeviceid(), updatedDevice);
            if (!updated) continue;
            dbCache.updateDeviceUAMap(updatedDevice.getUseragent(), updatedDevice.getDeviceid());
        }
    }
}

