/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.jsonpath;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class JsonUtil {
    private static final Logger LOGGER = Logger.getLogger(JsonUtil.class);

    public static Map<String, String> jsonToMap(String jsonString) {
        return (Map)new Gson().fromJson(jsonString, new TypeToken<HashMap<String, String>>(){}.getType());
    }

    public static String getPrettyJsonIfValid(String string) {
        try {
            JsonParser parser = new JsonParser();
            JsonObject jsonObj = parser.parse(string).getAsJsonObject();
            Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
            return gson.toJson((JsonElement)jsonObj);
        }
        catch (Exception e) {
            LOGGER.error((Object)"recorded response is not a valid json");
            return string;
        }
    }

    public static JsonObject jsonToObject(String jsonString) {
        return new JsonParser().parse(jsonString).getAsJsonObject();
    }

    public static String toJSON(Object object) {
        return new Gson().toJson(object);
    }

    public static <T> T fromJSON(String jsonString, Class<T> clazz) {
        return (T)new Gson().fromJson(jsonString, clazz);
    }
}

