/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.api;

import com.konylabs.middleware.exceptions.ConnectorException;

public final class ExceptionSourceUtils {
    private ExceptionSourceUtils() {
    }

    public static ServiceExecutionStateEnum getExceptionSource(Exception exception) {
        if (exception instanceof ConnectorException) {
            String exceptionSource = ((ConnectorException)((Object)exception)).getConnectorType();
            ServiceExecutionStateEnum serviceExecutionStatesEnum = ServiceExecutionStateEnum.getServiceExecutionState(exceptionSource);
            return serviceExecutionStatesEnum != null ? serviceExecutionStatesEnum : ServiceExecutionStateEnum.SERVICE;
        }
        return ServiceExecutionStateEnum.SERVICE;
    }

    public static enum ServiceExecutionStateEnum {
        PREPROCESSOR("PreProcessor"),
        SERVICE("Service"),
        POSTPROCESSOR("PostProcessor");

        private final String sourceType;

        private ServiceExecutionStateEnum(String sourceType) {
            this.sourceType = sourceType;
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public static ServiceExecutionStateEnum getServiceExecutionState(String sourceType) {
            for (ServiceExecutionStateEnum serviceExecuterState : ServiceExecutionStateEnum.values()) {
                if (!serviceExecuterState.getSourceType().equals(sourceType)) continue;
                return serviceExecuterState;
            }
            return null;
        }
    }
}

