/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.api;

import com.konylabs.middleware.api.OperationData;
import com.konylabs.middleware.api.OperationDataBuilder;
import com.konylabs.middleware.api.OperationsEnum;
import com.konylabs.middleware.api.ServiceOutputWrapper;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.request.builder.RequestContext;
import com.konylabs.middleware.request.validator.IntegrationRequestValidator;
import com.konylabs.middleware.request.validator.ObjectServiceRequestValidator;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import org.apache.log4j.Logger;

public class OperationDataBuilderImpl
implements OperationDataBuilder {
    private static final Logger LOGGER = Logger.getLogger(OperationDataBuilderImpl.class);
    private AppCache appCache;
    private String serviceId;
    private String version;
    private String operationId;
    private String objectId;
    private OperationsEnum operation;

    public OperationDataBuilderImpl(AppCache appCache) {
        this.appCache = appCache;
    }

    public OperationDataBuilder withServiceId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public OperationDataBuilder withOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    public OperationDataBuilder withObjectId(String objectId) {
        this.objectId = objectId;
        return this;
    }

    @Deprecated
    public OperationDataBuilder withOperation(OperationsEnum operation) {
        this.operation = operation;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    @Deprecated
    public String getVerison() {
        return this.getVersion();
    }

    public OperationDataBuilder withVersion(String appVersion) {
        this.version = appVersion;
        return this;
    }

    @Deprecated
    public OperationDataBuilder withVerison(String appVersion) {
        return this.withVersion(appVersion);
    }

    public OperationData build() throws AppRegistryException {
        LOGGER.debug((Object)"Inside build()");
        OperationData serviceDataObject = new OperationData();
        serviceDataObject.setServiceId(this.serviceId);
        serviceDataObject.setOperationId(this.operationId);
        serviceDataObject.setObjectId(this.objectId);
        serviceDataObject.setVersion(this.version);
        if (!this.isObjectService()) {
            RequestContext rc = this.getRequestContext();
            new IntegrationRequestValidator().validateRequest(rc);
            ServiceOutputWrapper serviceOutputWrapper = new ServiceOutputWrapper(rc.getAppMetadata().getServiceMetadata(this.operationId).getService().getServiceOutput());
            serviceDataObject.setServiceOutputWrapper(serviceOutputWrapper);
        } else {
            new ObjectServiceRequestValidator().validateRequest(this.getRequestContext());
        }
        return serviceDataObject;
    }

    public OperationData buildQuietly() {
        LOGGER.debug((Object)"Inside buildQuietly()");
        try {
            return this.build();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while validating service details", (Throwable)e);
            OperationData serviceDataObject = new OperationData();
            serviceDataObject.setServiceId(this.serviceId);
            serviceDataObject.setOperationId(this.operationId);
            serviceDataObject.setObjectId(this.objectId);
            serviceDataObject.setVersion(this.version);
            return serviceDataObject;
        }
    }

    private RequestContext getRequestContext() {
        RequestContext requestContext = new RequestContext();
        requestContext.setAppId(this.serviceId);
        requestContext.setServiceId(this.operationId);
        requestContext.setApiVersion(this.getVersionInternal());
        requestContext.setObjectId(this.objectId);
        if (this.operation != null) {
            requestContext.setDefaultOperation(this.operation.name());
        }
        requestContext.setAppCache(this.appCache);
        return requestContext;
    }

    private String getVersionInternal() {
        return this.version != null ? this.version : MiddlewareUtils.getRuntimeVersion(this.appCache, this.serviceId);
    }

    private boolean isObjectService() {
        return this.objectId != null;
    }
}

