/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.api;

import com.konylabs.middleware.api.OperationData;
import com.konylabs.middleware.api.ServiceRequest;
import com.konylabs.middleware.api.ServiceRequestBuilder;
import com.konylabs.middleware.api.ServiceRequestImpl;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.tenant.TenantBean;
import java.util.HashMap;
import java.util.Map;

public class ServiceRequestBuilderImpl
implements ServiceRequestBuilder {
    private DataControllerRequest dcRequest;
    private OperationData operationData;
    private Map<String, Object> inputMap = new HashMap<String, Object>();
    private Map<String, Object> headerMap = new HashMap<String, Object>();
    private Map<String, Object> attributesMap = new HashMap<String, Object>();
    private TenantBean<AppCache> tenantBean;

    public ServiceRequestBuilderImpl(OperationData operationData, TenantBean<AppCache> tenantBean) {
        this.operationData = operationData;
        this.tenantBean = tenantBean;
    }

    public ServiceRequestBuilder withDCRRequest(DataControllerRequest dcrReq) {
        this.dcRequest = dcrReq;
        return this;
    }

    public ServiceRequestBuilder withInputs(Map<String, Object> inputMap) {
        this.inputMap = inputMap != null ? inputMap : this.inputMap;
        return this;
    }

    public ServiceRequestBuilder withHeaders(Map<String, Object> headerMap) {
        this.headerMap = headerMap != null ? headerMap : this.headerMap;
        return this;
    }

    public ServiceRequestBuilder withAttributes(Map<String, Object> attributesMap) {
        this.attributesMap = attributesMap != null ? attributesMap : this.attributesMap;
        return this;
    }

    public DataControllerRequest getDCRequest() {
        return this.dcRequest;
    }

    public Map<String, Object> getInputMap() {
        return this.inputMap;
    }

    public Map<String, Object> getHeaderMap() {
        return this.headerMap;
    }

    public Map<String, Object> getAttributesMap() {
        return this.attributesMap;
    }

    public ServiceRequest build() {
        ServiceRequestImpl integrationRequest = new ServiceRequestImpl(this.tenantBean);
        this.addDefaults();
        integrationRequest.setInputMap(this.getInputMap());
        integrationRequest.setHeaderMap(this.getHeaderMap());
        integrationRequest.setAttributesMap(this.getAttributesMap());
        integrationRequest.setDcrRequest(this.getDCRequest());
        return integrationRequest;
    }

    private void addDefaults() {
        this.getInputMap().put("appID", this.operationData.getServiceId());
        this.getInputMap().put("serviceID", this.operationData.getOperationId());
        this.getInputMap().put("channel", "rc");
        this.getInputMap().put("current_appID", this.operationData.getServiceId());
        this.getInputMap().put("current_serviceID", this.operationData.getOperationId());
        this.getInputMap().put("curent_apiVersion", this.operationData.getVersion());
        this.getHeaderMap().put("X-Kony-API-Version", this.operationData.getVersion());
    }
}

