/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.api;

import com.kony.mobilefabric.exceptions.MobileFabricRuntimeException;
import com.konylabs.middleware.api.RequestAttributesHolder;
import com.konylabs.middleware.api.ServiceRequest;
import com.konylabs.middleware.api.TypeParser;
import com.konylabs.middleware.controller.DataController;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerRequestFactory;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.controller.impl.DataControllerResponseImpl;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.dataobject.ResultToJSON;
import com.konylabs.middleware.exceptions.ControllerException;
import com.konylabs.middleware.exceptions.ControllerInitializationException;
import com.konylabs.middleware.exceptions.ExceptionUtil;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.exceptions.ProcessorException;
import com.konylabs.middleware.processor.Processor;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.tenant.TenantBean;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.BufferedHttpEntity;

public class ServiceRequestImpl
implements ServiceRequest {
    private Map<String, Cookie> cookies;
    private DataControllerRequest dcrReq;
    private DataControllerResponse dcrRes;
    private Map<String, Object> inputMap = new HashMap<String, Object>();
    private Map<String, Object> headerMap = new HashMap<String, Object>();
    private Map<String, Object> attributesMap = new HashMap<String, Object>();
    private TenantBean<AppCache> tenantBean;
    private String operation;

    public ServiceRequestImpl(TenantBean<AppCache> tenantBean) {
        this.tenantBean = tenantBean;
    }

    public Map<String, Object> getInputMap() {
        return this.inputMap;
    }

    public void setInputMap(Map<String, Object> inputMap) {
        this.inputMap = inputMap;
    }

    public Map<String, Object> getHeaderMap() {
        return this.headerMap;
    }

    public void setHeaderMap(Map<String, Object> headerMap) {
        this.headerMap = headerMap;
    }

    public Map<String, Object> getAttributesMap() {
        return this.attributesMap;
    }

    public void setAttributesMap(Map<String, Object> attributesMap) {
        this.attributesMap = attributesMap;
    }

    public DataControllerRequest getDCRequest() {
        return this.dcrReq;
    }

    public void setDcrRequest(DataControllerRequest dcrReq) {
        this.dcrReq = dcrReq;
    }

    public DataControllerResponse getDcrResponse() {
        return this.dcrRes;
    }

    public void setDcrRes(DataControllerResponse dcrRes) {
        this.dcrRes = dcrRes;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String invokeServiceAndGetJson() throws MiddlewareException {
        return (String)this.invokeService(false);
    }

    public BufferedHttpEntity invokePassThroughServiceAndGetEntity() throws MiddlewareException {
        return (BufferedHttpEntity)this.invokeService(true);
    }

    public <R> R invokePassThroughServiceAndGetEntity(Function<InputStream, R> typeParser) throws MiddlewareException {
        try {
            return TypeParser.getStreamParser().andThen(typeParser).apply(this.invokeService(true), StandardCharsets.UTF_8.name());
        }
        catch (MobileFabricRuntimeException e) {
            throw new MiddlewareException("14050", e.getMessage());
        }
    }

    public Result invokeServiceAndGetResult() throws MiddlewareException {
        DataControllerRequest dataControllerRequest = this.getDCRequest() != null ? this.getDCRequest().clone() : this.createDCR();
        DataControllerResponseImpl dataControllerResponse = new DataControllerResponseImpl();
        dataControllerRequest.addRequestParam_("appID", (String)this.getInputMap().get("appID"));
        dataControllerRequest.addRequestParam_("serviceID", (String)this.getInputMap().get("serviceID"));
        dataControllerRequest.getHeaderMap().put("X-Kony-API-Version", this.getHeaderMap().get("X-Kony-API-Version"));
        DataController dc = DataController.InstanceManager.getInstance();
        try {
            Processor processor = dc.getProcessor("ServiceDelegator");
            processor.execute(dataControllerRequest, (DataControllerResponse)dataControllerResponse);
        }
        catch (ControllerInitializationException | ProcessorException e) {
            if (this.getDCRequest() != null) {
                Result result = this.handleException(dataControllerRequest, (MiddlewareException)e);
                this.getDCRequest().setAttribute("results", (Object)result);
            }
            throw e;
        }
        return (Result)dataControllerRequest.getAttribute("results");
    }

    private <T> T invokeService(Boolean isPassthrough) throws MiddlewareException {
        this.setCookies(this.getDCRequest() != null ? this.getDCRequest().getCookies() : null);
        DataControllerRequest dataControllerRequest = this.createDCR();
        RequestAttributesHolder attributesHolder = new RequestAttributesHolder();
        attributesHolder.setAttribMap(this.getAttributesMap());
        dataControllerRequest.setAttribute("requestAttributesHolder", (Object)attributesHolder);
        DataController dc = DataController.InstanceManager.getInstance();
        DataControllerResponseImpl dataControllerResponse = new DataControllerResponseImpl();
        try {
            dataControllerResponse = dc.processDataRequest(dataControllerRequest);
        }
        catch (ControllerException | ControllerInitializationException e) {
            if (!isPassthrough.booleanValue() && this.getDCRequest() != null) {
                Result result = this.handleException(dataControllerRequest, (MiddlewareException)e);
                this.getDCRequest().setAttribute("chunkedresults_json", (Object)ResultToJSON.convert((Result)result, (DataControllerResponse)dataControllerResponse));
            }
            throw e;
        }
        return (T)dataControllerResponse.getAttribute("chunkedresults_json");
    }

    private Map<String, Cookie> getCookies() {
        return this.cookies;
    }

    private void setCookies(Map<String, Cookie> cookies) {
        this.cookies = cookies;
    }

    private Result handleException(DataControllerRequest dataControllerRequest, MiddlewareException e) {
        Object result = dataControllerRequest.getAttribute("ResultOnException") != null ? dataControllerRequest.getAttribute("ResultOnException") : new Result();
        ExceptionUtil.addErrorAttributes((Result)result, (MiddlewareException)e);
        return result;
    }

    private DataControllerRequest createDCR() {
        DataControllerRequest dataControllerRequest = DataControllerRequestFactory.newInstance(this.getInputMap(), this.getHeaderMap(), null, this.getCookies());
        dataControllerRequest.setAttribute("tenantBean", this.tenantBean);
        return dataControllerRequest;
    }
}

