/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.api;

import com.kony.mobilefabric.cache.director.CacheDirector;
import com.konylabs.middleware.api.ConfigurableParametersHelper;
import com.konylabs.middleware.api.OperationData;
import com.konylabs.middleware.api.OperationDataBuilder;
import com.konylabs.middleware.api.OperationDataBuilderImpl;
import com.konylabs.middleware.api.ServiceRequestBuilder;
import com.konylabs.middleware.api.ServiceRequestBuilderImpl;
import com.konylabs.middleware.api.ServicesManager;
import com.konylabs.middleware.cache.CacheProperties;
import com.konylabs.middleware.classloader.resources.ConfigurationProperties;
import com.konylabs.middleware.ehcache.ResultCache;
import com.konylabs.middleware.ehcache.ResultCacheImpl;
import com.konylabs.middleware.metrics.KonyCustomMetrics;
import com.konylabs.middleware.metrics.MetricsBean;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.tenant.TenantBean;
import org.apache.log4j.Logger;

public class ServicesManagerImpl
implements ServicesManager {
    private static final Logger LOGGER = Logger.getLogger(ServicesManagerImpl.class);
    private TenantBean<AppCache> tenantBean;
    private OperationData operationData;
    private MetricsBean metricsBean;
    private ConfigurationProperties configurationProperties;
    private CacheDirector cacheDirector;

    public ServicesManagerImpl(TenantBean<AppCache> tenantBean, OperationData operationData, MetricsBean metricsBean, ConfigurationProperties configurationProperties, CacheDirector director) {
        this.tenantBean = tenantBean;
        this.operationData = operationData;
        this.metricsBean = metricsBean;
        this.configurationProperties = configurationProperties;
        this.cacheDirector = director;
    }

    public ServicesManagerImpl(TenantBean<AppCache> tenantBean) {
        this.tenantBean = tenantBean;
    }

    public OperationData getOperationData() throws AppRegistryException {
        return this.operationData;
    }

    public ConfigurableParametersHelper getConfigurableParametersHelper() {
        return new ConfigurableParametersHelper(this.configurationProperties);
    }

    public OperationDataBuilder getOperationDataBuilder() {
        return new OperationDataBuilderImpl((AppCache)this.tenantBean.getAppCache());
    }

    public ServiceRequestBuilder getRequestBuilder(OperationData serviceDataObject) {
        return new ServiceRequestBuilderImpl(serviceDataObject, this.tenantBean);
    }

    public KonyCustomMetrics getKonyCustomMetrics() {
        return this.metricsBean.getKonyCustomMetrics();
    }

    public void updateOperation(String operation) {
        OperationData newOperationData;
        this.operationData = newOperationData = new OperationDataBuilderImpl((AppCache)this.tenantBean.getAppCache()).withServiceId(this.operationData.getServiceId()).withVersion(this.operationData.getVersion()).withObjectId(this.operationData.getObjectId()).withOperationId(operation).buildQuietly();
    }

    public ResultCache getResultCache() {
        LOGGER.debug((Object)("Retrieving the result cache with cache type " + CacheProperties.CACHE_TYPE.getFromConfig()));
        return new ResultCacheImpl(this.cacheDirector);
    }
}

