/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.common.constants;

import com.konylabs.middleware.http.HttpMethods;
import com.konylabs.middleware.request.builder.CreateOperationStrategy;
import com.konylabs.middleware.request.builder.DeleteOperationStrategy;
import com.konylabs.middleware.request.builder.OperationStrategy;
import com.konylabs.middleware.request.builder.UpdateOperationStrategy;

public enum OperationEnum {
    get,
    create,
    update{

        @Override
        public OperationStrategy getStrategy() {
            return new UpdateOperationStrategy();
        }
    }
    ,
    delete{

        @Override
        public OperationStrategy getStrategy() {
            return new DeleteOperationStrategy();
        }
    }
    ,
    partialupdate,
    createBinary,
    updateBinary,
    deleteBinary,
    getBinary,
    getupdated,
    getbatch,
    getbypk;

    private String operationName;

    public OperationStrategy getStrategy() {
        return new CreateOperationStrategy();
    }

    private OperationEnum() {
        this.operationName = this.name();
    }

    private OperationEnum(String operationName) {
        this.operationName = operationName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public static OperationEnum getObjectOperationByHttpmethod(String httpmethod) {
        HttpMethods method = HttpMethods.getHttpMethod((String)httpmethod);
        if (method != null) {
            switch (method) {
                case GET: {
                    return get;
                }
                case DELETE: {
                    return delete;
                }
                case POST: {
                    return create;
                }
                case PUT: {
                    return update;
                }
                case PATCH: {
                    return partialupdate;
                }
                case HEAD: {
                    break;
                }
                case CONNECT: {
                    break;
                }
                case OPTIONS: {
                    break;
                }
                case TRACE: {
                    break;
                }
            }
        }
        return null;
    }

    public static OperationEnum getBinaryOperationByHttpmethod(String httpmethod) {
        HttpMethods method = HttpMethods.getHttpMethod((String)httpmethod);
        if (method != null) {
            switch (method) {
                case GET: {
                    return getBinary;
                }
                case DELETE: {
                    return deleteBinary;
                }
                case POST: {
                    return createBinary;
                }
                case PUT: {
                    return updateBinary;
                }
                case PATCH: {
                    break;
                }
                case HEAD: {
                    break;
                }
                case CONNECT: {
                    break;
                }
                case OPTIONS: {
                    break;
                }
                case TRACE: {
                    break;
                }
            }
        }
        return null;
    }
}

