/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.common.dataaccess.dao;

import com.konylabs.middleware.appservices.common.constants.OperationEnum;
import com.konylabs.middleware.appservices.common.dataaccess.dao.LocalMetadataDao;
import com.konylabs.middleware.appservices.common.dataaccess.dto.ColumnDto;
import com.konylabs.middleware.appservices.common.dataaccess.dto.RelationshipDto;
import com.konylabs.middleware.appservices.common.dataaccess.dto.RelationshipFields;
import com.konylabs.middleware.appservices.common.dataaccess.dto.TableDto;
import com.konylabs.middleware.appservices.common.dataaccess.exception.DataAccessException;
import com.konylabs.middleware.objservices.runtime.metadata.FieldMetadata;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.registry.vo.Operationmapping;
import com.konylabs.middleware.utilities.MaskUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class LocalMetadataDaoImpl
implements LocalMetadataDao {
    private static final Logger logger = Logger.getLogger(LocalMetadataDaoImpl.class);

    private List<TableDto> getTableDto(ApplicationMetadata appMetadata, String objectId) throws DataAccessException {
        try {
            if (appMetadata != null) {
                ArrayList<TableDto> tableDtos = new ArrayList<TableDto>();
                if (StringUtils.isEmpty((String)objectId)) {
                    for (String objectName : appMetadata.getObjectNames()) {
                        tableDtos.add(this.getTableDtoFromObject(appMetadata, objectName));
                    }
                } else {
                    tableDtos.add(this.getTableDtoFromObject(appMetadata, objectId));
                }
                if (tableDtos.size() == 0) {
                    logger.error((Object)"Error in getTableDto, object not found");
                    throw new DataAccessException(404006, "Object not found", null);
                }
                return tableDtos;
            }
            logger.error((Object)"Error in getTableDto,object service not found");
            throw new DataAccessException(404005, "Object service not found", null);
        }
        catch (Exception ex) {
            logger.error((Object)"Error in getTableDto, while reading object def");
            MaskUtils.maskTrace((String)"Cannot Access Registry", (Throwable)ex);
            throw new DataAccessException(ex, 500005, "Error occurred while reading object def");
        }
    }

    private ColumnDto getColumnDtoFromField(FieldMetadata field, List<String> primaryKeyList) {
        ColumnDto columnDto = new ColumnDto();
        columnDto.setName(field.getName());
        columnDto.setSourceFieldName(field.getSourceFieldName());
        columnDto.setDisplayName(field.getDisplayName());
        columnDto.setDatatype(field.getDatatype());
        columnDto.setDisplayName(field.getName());
        if (primaryKeyList != null && primaryKeyList.contains(field.getName())) {
            columnDto.setPrimaryKey(true);
        }
        columnDto.setAuditColumn(field.isAuditColumn());
        columnDto.setHasIndex(field.isHasIndex());
        columnDto.setHasTranslation(field.isHasTranslation());
        columnDto.setCustomizable(field.isCustomizable());
        columnDto.setTable(field.getTable());
        columnDto.setUpdateable(field.isUpdateable());
        columnDto.setDescription(field.getDescription());
        columnDto.setSourceDatatype(field.getSourceDatatype());
        columnDto.setNullable(field.isNullable());
        columnDto.setCreateable(field.isCreatable());
        columnDto.setLength(field.getLength());
        return columnDto;
    }

    private RelationshipDto getChildRelationshipDtoFromRelation(com.konylabs.middleware.objservices.metadata.RelationshipDto relation, String entytName) {
        RelationshipDto relationshipDto = new RelationshipDto();
        relationshipDto.setEntityName(entytName);
        relationshipDto.setRelationshipName(relation.getName());
        relationshipDto.setRelationshipType(relation.getType());
        relationshipDto.setRelatedEntity(relation.getTarget_object());
        ArrayList<RelationshipFields> relationshipFields = new ArrayList<RelationshipFields>();
        if (relation.getSource_fields() != null && relation.getTarget_fields() != null) {
            for (int i = 0; i < relation.getTarget_fields().size(); ++i) {
                RelationshipFields relationshipField = new RelationshipFields();
                relationshipField.setReferencingField(relation.getSource_fields().get(i));
                relationshipField.setReferencedField(relation.getTarget_fields().get(i));
                relationshipFields.add(relationshipField);
            }
            relationshipDto.setRelationshipFields(relationshipFields);
        }
        return relationshipDto;
    }

    private TableDto getTableDtoFromObject(ApplicationMetadata appMetadata, String objectID) throws DataAccessException {
        Map<String, FieldMetadata> fieldMetadataMap;
        ObjectMetadata objectMetadata = appMetadata.getObjectMetadata(objectID);
        String appId = appMetadata.getApplicationVersion().getAppId();
        Map<String, Operationmapping> map = appMetadata.getOperatonMapingsMap().get(objectID);
        TableDto tableDto = new TableDto();
        tableDto.setName(objectMetadata.getName());
        List<String> primaryKeyList = objectMetadata.getPrimaryKeys();
        tableDto.setPrimaryKey(objectMetadata.getPrimaryKeys());
        if (objectMetadata.getRelationshipMetadata() != null && objectMetadata.getRelationshipMetadata().size() > 0) {
            ArrayList<RelationshipDto> relationshipDtos = new ArrayList<RelationshipDto>();
            for (com.konylabs.middleware.objservices.metadata.RelationshipDto relationship : objectMetadata.getRelationshipMetadata()) {
                relationshipDtos.add(this.getChildRelationshipDtoFromRelation(relationship, objectMetadata.getName()));
            }
            tableDto.setRelationshipList(relationshipDtos);
        }
        if ((fieldMetadataMap = objectMetadata.getFieldMetadataMap()) != null) {
            ArrayList<ColumnDto> columns = new ArrayList<ColumnDto>();
            for (FieldMetadata field : fieldMetadataMap.values()) {
                ColumnDto colDto = this.getColumnDtoFromField(field, primaryKeyList);
                columns.add(colDto);
            }
            tableDto.setColumns(columns);
        }
        if (map != null) {
            block9: for (OperationEnum operationEnum : OperationEnum.values()) {
                if (map.get(operationEnum.name()) == null) continue;
                switch (operationEnum) {
                    case get: {
                        tableDto.setSelectServiceId(map.get(OperationEnum.get.name()).getServiceid());
                        continue block9;
                    }
                    case create: {
                        tableDto.setCreateServiceId(map.get(OperationEnum.create.name()).getServiceid());
                        continue block9;
                    }
                    case update: {
                        tableDto.setUpdateServiceId(map.get(OperationEnum.update.name()).getServiceid());
                        continue block9;
                    }
                    case delete: {
                        tableDto.setDeleteServiceId(map.get(OperationEnum.delete.name()).getServiceid());
                        continue block9;
                    }
                    case partialupdate: {
                        tableDto.setPartialUpdateServiceId(map.get(OperationEnum.partialupdate.name()).getServiceid());
                        continue block9;
                    }
                }
            }
        }
        tableDto.setAppId(appId);
        return tableDto;
    }

    @Override
    public TableDto getLocalMetaDataObjectFields(ApplicationMetadata appMetadata, String objectName) throws DataAccessException {
        TableDto tableDto = this.getTableDto(appMetadata, objectName).get(0);
        return tableDto;
    }

    @Override
    public List<TableDto> getLocalMetaData(ApplicationMetadata appMetadata) throws DataAccessException {
        return this.getTableDto(appMetadata, null);
    }
}

