/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.common.dataaccess.exception;

import com.konylabs.middleware.exceptions.ControllerException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class DataAccessException
extends Exception {
    private static final long serialVersionUID = 1L;
    private int errCode;
    private final long millis;
    private String detailMessage = "";
    private int httpstatus;
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy hh:mm:ss.SSS");
    private static final Logger logger = Logger.getLogger(DataAccessException.class);

    public int getHttpstatus() {
        return this.httpstatus;
    }

    public void setHttpstatus(int httpstatus) {
        this.httpstatus = httpstatus;
    }

    public long getTimeMillis() {
        return this.millis;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public void setErrCode(int errCode) {
        this.errCode = errCode;
    }

    public DataAccessException(int errCode, String errMsg) {
        super(errMsg);
        this.millis = System.currentTimeMillis();
        this.errCode = errCode;
        JSONObject detailJSON = new JSONObject();
        try {
            detailJSON.put("stackTrace", (Object)Arrays.toString(this.getStackTrace()));
        }
        catch (JSONException e) {
            logger.error((Object)"JSON exception occurred while converting middleware response to dae", (Throwable)e);
        }
        this.detailMessage = detailJSON.toString();
    }

    public DataAccessException(int errCode, String errMsg, String detailMessage) {
        super(errMsg);
        this.millis = System.currentTimeMillis();
        this.errCode = errCode;
        this.detailMessage = detailMessage;
    }

    public DataAccessException(Throwable e, int errCode, String msg) {
        super(msg + " due to " + e.getLocalizedMessage(), e);
        this.millis = System.currentTimeMillis();
        if (e instanceof DataAccessException) {
            this.errCode = ((DataAccessException)e).getErrCode();
            this.detailMessage = ((DataAccessException)e).detailMessage;
        } else {
            JSONObject detailJSON = new JSONObject();
            try {
                detailJSON.put("stackTrace", (Object)Arrays.toString(e.getStackTrace()));
                detailJSON.put("message", (Object)e.getMessage());
            }
            catch (JSONException e1) {
                logger.error((Object)"JSON exception occurred while converting middleware response to dae", (Throwable)e1);
            }
            this.detailMessage = detailJSON.toString();
            this.errCode = errCode;
        }
    }

    public DataAccessException(Throwable e) {
        super(e.getLocalizedMessage(), e);
        this.millis = System.currentTimeMillis();
        if (e instanceof DataAccessException) {
            this.errCode = ((DataAccessException)e).getErrCode();
            this.detailMessage = ((DataAccessException)e).detailMessage;
        } else {
            JSONObject detailJSON = new JSONObject();
            try {
                detailJSON.put("stackTrace", (Object)Arrays.toString(e.getStackTrace()));
                detailJSON.put("message", (Object)e.getMessage());
            }
            catch (JSONException e1) {
                logger.error((Object)"JSON exception occurred while converting middleware response to dae", (Throwable)e1);
            }
            this.detailMessage = detailJSON.toString();
            if (e instanceof ControllerException) {
                ControllerException ex = (ControllerException)e;
                this.errCode = ex.getErrorCode() != null ? Integer.parseInt(ex.getErrorCode()) : 500004;
                this.httpstatus = ex.getHttpStatusCode();
            } else {
                this.errCode = 500001;
            }
        }
    }

    public JSONObject getJson(String requestToken) {
        JSONObject jsonObject = new JSONObject();
        try {
            if (this.httpstatus == 0) {
                this.httpstatus = this.errCode / 1000;
            }
            jsonObject.put("errmsg", (Object)this.getMessage());
            jsonObject.put("opstatus", this.errCode);
            jsonObject.put("timeStamp", (Object)this.sdf.format(new Date(this.millis)));
            jsonObject.put("httpStatusCode", this.httpstatus);
            if (requestToken != null) {
                jsonObject.put("requestToken", (Object)requestToken);
            }
        }
        catch (JSONException ex) {
            logger.error((Object)"JSON exception occurred while converting middleware response to dae", (Throwable)ex);
        }
        return jsonObject;
    }
}

