/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.common.filters;

import com.konylabs.middleware.appservices.common.dataaccess.exception.DataAccessException;
import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.request.RemoveContentTypeHeaderWrapper;
import com.konylabs.middleware.servlet.filters.IntegrationCustomFilter;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.json.JSONObject;

@IntegrationCustomFilter(filterOrder=200, servletNames={"AppServices", "AppMetadataServices"}, defaultFilter=true)
public class AppServicesFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(AppServicesFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        response.setContentType("application/json");
        try {
            RemoveContentTypeHeaderWrapper wrapper = new RemoveContentTypeHeaderWrapper((HttpServletRequest)request);
            filterChain.doFilter((ServletRequest)wrapper, response);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Error while processing request", (Throwable)ex);
            Throwable t = ex.getCause();
            DataAccessException dae = null;
            dae = !(t instanceof DataAccessException) ? new DataAccessException(t) : (DataAccessException)t;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            JSONObject jsonObject = dae.getJson(null);
            httpServletResponse.setStatus(200);
            String responseString = jsonObject.toString();
            MiddlewareUtils.logDeviceResponse(request, responseString, false);
            ObjectServiceUtil.addResponseToPayloadHandlerIfExists(httpServletRequest, httpServletResponse, responseString);
        }
    }

    public void init(FilterConfig config) {
    }

    public void destroy() {
    }
}

