/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.common.filters;

import com.kony.mobilefabric.exceptions.MobileFabricRuntimeException;
import com.kony.mobilefabric.rest.ResourceTracer;
import com.kony.mobilefabric.rest.utils.ResourceTracerUtils;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.api.RequestAttributesHolder;
import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.frontendurls.FrontendResourceIdentifier;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.request.builder.IntegrationServiceUriContext;
import com.konylabs.middleware.request.builder.UriContext;
import com.konylabs.middleware.request.parser.UriParser;
import com.konylabs.middleware.servlet.filters.IntegrationCustomFilter;
import com.konylabs.middleware.utilities.RequestUtils;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@IntegrationCustomFilter(filterOrder=25, servletNames={"MWServlet"}, defaultFilter=true)
public class FrontendResolutionFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(FrontendResolutionFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        try {
            AppCache appCache = TenantUtilities.getAppCacheFromRequest((ServletRequest)httpRequest);
            String dynamicUrl = this.getDynamicUrl(httpRequest.getRequestURI(), httpRequest.getContextPath());
            String httpVerb = httpRequest.getMethod();
            String version = httpRequest.getHeader("X-Kony-API-Version");
            LOGGER.info((Object)String.format("Received request with URI : %s, http verb : %s, X-Kony-API-Version : %s ", dynamicUrl, httpVerb, version));
            UriContext uriContext = UriParser.getInstance().parse(httpRequest);
            boolean isMiddlewareService = this.isMiddlewareServiceRequest(httpRequest, uriContext, appCache);
            if (isMiddlewareService) {
                String[] uriParams = uriContext.getUriParams();
                LOGGER.debug((Object)String.format("URI : %s is matched with a middleware service %s and operation %s", dynamicUrl, uriParams[0], uriParams[1]));
            } else {
                LOGGER.debug((Object)String.format("URI : %s is not a middleware service", dynamicUrl));
                ResourceTracer resourceTracer = appCache.getResourceTracer();
                String configUrl = this.getConfiguredUrlQuietly(dynamicUrl, httpVerb, resourceTracer);
                if (StringUtils.isEmpty((String)configUrl)) {
                    LOGGER.info((Object)String.format("No frontendURL configured for URL : %s and with verb : %s", dynamicUrl, httpVerb));
                } else {
                    String serviceId = resourceTracer.getConfiguredResourceName(dynamicUrl, httpVerb);
                    Map params = resourceTracer.resolveToPathParamsByConfigUrl(configUrl, dynamicUrl);
                    LOGGER.info((Object)String.format("Identified configuredURL : %s, serviceId : %s", configUrl, serviceId));
                    LOGGER.info((Object)String.format("Requested X-Kony-API-Version : %s", version));
                    FrontendResourceIdentifier resourceIdentifier = appCache.getFrontendResourceIdentifier();
                    String operationId = resourceIdentifier.getOperation(serviceId, configUrl, httpVerb, version);
                    version = StringUtils.isNotBlank((String)version) ? version : resourceIdentifier.getHighestAvailableVersion(serviceId, configUrl, httpVerb);
                    LOGGER.info((Object)String.format("Served X-Kony-API-Version : %s", version));
                    UriContext frontEndUriContext = this.buildUriContext(serviceId, operationId);
                    this.updateDataInRequest(httpRequest, frontEndUriContext, params, version);
                }
            }
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpServletResponse);
        }
        catch (MobileFabricRuntimeException e) {
            LOGGER.error((Object)"MobileFabricRuntimeException occurred", (Throwable)e);
            String errorMsg = ObjectServiceUtil.getErrorMsg("10107", AppRegistryException.getErrorMessageForKey((String)"no_app_exists_withid_version"));
            ObjectServiceUtil.sendResponse(errorMsg, httpServletResponse);
        }
        catch (MiddlewareException e) {
            LOGGER.error((Object)"MiddlewareException occurred during validation", (Throwable)e);
            String errorMsg = ObjectServiceUtil.getErrorMsgByMiddlewareException(e);
            ObjectServiceUtil.sendResponse(errorMsg, httpServletResponse);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception occured while resolving frontend URL", (Throwable)e);
            httpServletResponse.setStatus(500);
        }
    }

    private UriContext buildUriContext(String serviceId, String operationId) {
        String[] uriParams = new String[]{serviceId, operationId};
        IntegrationServiceUriContext uriContext = new IntegrationServiceUriContext(uriParams);
        return uriContext;
    }

    private String getConfiguredUrlQuietly(String dynamicUrl, String httpVerb, ResourceTracer resourceTracer) {
        try {
            return resourceTracer.identifyConfiguredResourceUrl(dynamicUrl, httpVerb);
        }
        catch (MobileFabricRuntimeException e) {
            LOGGER.trace((Object)"Frontend url not configured", (Throwable)e);
            return null;
        }
    }

    private boolean isMiddlewareServiceRequest(HttpServletRequest httpRequest, UriContext uriContext, AppCache appCache) throws AppRegistryException {
        String version;
        String appId;
        ApplicationMetadata appMetadata;
        boolean isMiddlewareService = false;
        String[] uriParams = uriContext.getUriParams();
        if (uriParams.length > 0 && (appMetadata = (ApplicationMetadata)appCache.getAppMetadata(new AppVersion(appId = uriParams[0], version = this.getRequestVersion(httpRequest, appCache, appId)))) != null && uriParams.length > 1) {
            String serviceId = uriParams[1];
            LOGGER.debug((Object)String.format("Checking if a middleware service exists with appId %s, service id %s", appId, serviceId));
            this.updateDataInRequest(httpRequest, uriContext, null, version);
            ServiceMetadata servMetadata = appMetadata.getServiceMetadata(serviceId);
            isMiddlewareService = servMetadata != null;
        }
        return isMiddlewareService;
    }

    private String getRequestVersion(HttpServletRequest httpRequest, AppCache appCache, String appId) throws AppRegistryException {
        String version = httpRequest.getHeader("X-Kony-API-Version");
        String string = version = version != null ? version : appCache.getRuntimeVersion(appId);
        if (version == null) {
            String errorCode = "10101";
            String errorMessage = AppRegistryException.getErrorMessageForKey((String)"no_app_exists_withid");
            throw new AppRegistryException(errorCode, errorMessage);
        }
        return version;
    }

    private void updateDataInRequest(HttpServletRequest request, UriContext uriContext, Map<String, String> pathParams, String version) {
        RequestAttributesHolder attributesHolder = RequestUtils.getAttributeHolder((HttpServletRequest)request);
        attributesHolder.put("frontend_uri_context", (Object)uriContext);
        attributesHolder.put("frontend_path_params", pathParams);
        attributesHolder.put("X-Kony-API-Version", (Object)version);
    }

    private String getDynamicUrl(String requestUri, String contextPath) {
        return ResourceTracerUtils.removeTrailingSlash((String)requestUri.replace(contextPath, ""));
    }

    public void destroy() {
    }
}

