/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.common.filters;

import com.kony.mobilefabric.logger.DiagnosticContext;
import com.kony.mobilefabric.throttle.Throttle;
import com.kony.mobilefabric.throttle.ThrottleException;
import com.kony.mobilefabric.throttle.Throttles;
import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.cache.CacheUtils;
import com.konylabs.middleware.devicedb.TenantException;
import com.konylabs.middleware.environment.EnvironmentProperties;
import com.konylabs.middleware.exceptions.ExceptionUtil;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.servlet.filters.IntegrationCustomFilter;
import com.konylabs.middleware.tenant.ReadableTenantEnvManager;
import com.konylabs.middleware.tenant.TenantBean;
import com.konylabs.middleware.tenant.TenantThreadLocal;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.io.IOException;
import java.util.function.Function;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;

@IntegrationCustomFilter(filterOrder=6, servletNames={"MWServlet", "AppServices", "AppMetadataServices", "IST", "healthcheck", "CMS", "DeviceLog", "ClientConfiguration", "KonyFileService"}, defaultFilter=true)
public class MWTenantFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(MWTenantFilter.class);
    private Throttle<TenantBean<AppCache>> tenantThrottle;
    private ServletContext servletContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            LOGGER.debug((Object)"Middleware Tenant filter");
            TenantBean<AppCache> tenantBean = this.getTenantBeanAndAddToRequest(request);
            if (tenantBean != null) {
                DiagnosticContext.addCustomFields((String)"tenant", (String)tenantBean.getTenantIdentifier());
                TenantUtilities.setTenantIdentifierToThreadLocal(tenantBean);
                this.tenantThrottle.check(tenantBean);
            }
            chain.doFilter(request, response);
        }
        catch (ThrottleException te) {
            LOGGER.error((Object)te.getMessage(), (Throwable)te);
            String errorMsg = MiddlewareUtils.getResponseJsonString("14049", 429, te.getMessage());
            ObjectServiceUtil.sendResponse(errorMsg, (HttpServletResponse)response);
        }
        catch (MiddlewareException middlewareException) {
            LOGGER.error((Object)"Exception while fetching tenant", (Throwable)middlewareException);
            ExceptionUtil.prepareNotFoundResponse((ServletResponse)response, (MiddlewareException)middlewareException);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to process request", (Throwable)e);
            ((HttpServletResponse)response).setStatus(500);
        }
        finally {
            DiagnosticContext.remove();
            TenantThreadLocal.remove();
        }
    }

    public void init(FilterConfig fConfig) {
        this.servletContext = fConfig.getServletContext();
        this.tenantThrottle = this.isMultiTenant() ? Throttles.newVariableLimit((String)"Tenant Limit has been exceeded for tenant {0} at {1}. Please contact your administrator for more details.", (Function)new Function<TenantBean<AppCache>, Integer>(){

            @Override
            public Integer apply(TenantBean<AppCache> tenantBean) {
                return MWTenantFilter.getTenantThrottleLimit((TenantBean<AppCache>)tenantBean);
            }
        }) : Throttles.newNoLimit();
    }

    public void destroy() {
    }

    protected TenantBean<AppCache> getTenantBeanAndAddToRequest(ServletRequest request) throws TenantException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        ReadableTenantEnvManager tenantEnvManager = (ReadableTenantEnvManager)this.servletContext.getAttribute("tenantEnvManager");
        TenantBean<AppCache> tenantBean = TenantUtilities.getTenantBean(httpServletRequest, tenantEnvManager);
        LOGGER.debug((Object)"Tenant bean created successfully.");
        httpServletRequest.setAttribute("tenantBean", tenantBean);
        LOGGER.debug((Object)"Added cache director to request successfully.");
        CacheUtils.addCacheDirectorToRequest(httpServletRequest, this.servletContext);
        return tenantBean;
    }

    protected boolean isMultiTenant() {
        return TenantUtilities.isMultiTenant();
    }

    private static int getTenantThrottleLimit(TenantBean<AppCache> tenantBean) {
        int defaultLimit = 60;
        String limit = tenantBean.getEnvProperty(EnvironmentProperties.KONY_SERVER_MAX_REQUEST_PER_MIN.name());
        return NumberUtils.toInt((String)limit, (int)60);
    }
}

