/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.common.filters;

import com.kony.api.gateway.Gateway;
import com.kony.api.gateway.GatewayConfig;
import com.kony.api.gateway.GatewayException;
import com.kony.api.gateway.GatewayHelper;
import com.kony.api.gateway.util.ServiceType;
import com.kony.mobilefabric.logger.DiagnosticContext;
import com.konylabs.middleware.config.LoggerProperties;
import com.konylabs.middleware.http.HttpMethods;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.servlet.filters.IntegrationCustomFilter;
import com.konylabs.middleware.tenant.TenantBean;
import com.konylabs.middleware.utilities.LoggerUtility;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

@IntegrationCustomFilter(filterOrder=20, servletNames={"DeviceLog", "ClientConfiguration", "KonyFileService"}, defaultFilter=true)
public class MiddlewareAuthenticationFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(MiddlewareAuthenticationFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOGGER.debug((Object)"Executing MiddlewareAuthenticationFilter");
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            if (HttpMethods.OPTIONS.nameEquals(httpServletRequest.getMethod())) {
                return;
            }
            String authToken = httpServletRequest.getHeader("X-Kony-Authorization");
            String requestId = MiddlewareUtils.getRequestId(httpServletRequest);
            DiagnosticContext.setRequestId((String)requestId);
            TenantBean<AppCache> tenantBean = TenantUtilities.getTenantBeanFromRequest((ServletRequest)httpServletRequest);
            GatewayConfig gatewayConfig = this.createGatewayConfig(tenantBean);
            Gateway gateway = this.createGateway(gatewayConfig, authToken, requestId);
            if (gateway == null) {
                LOGGER.error((Object)"Unable to authenticate user.");
                ((HttpServletResponse)response).setStatus(401);
                return;
            }
            LOGGER.debug((Object)"User successfully authenticated.");
            LoggerUtility.matchAndSetDynamicLogLevel(httpServletRequest, httpServletResponse, null);
            String userId = gateway.getUserId();
            LoggerUtility.matchAndSetDynamicLogLevel(LoggerProperties.USER_ID_LOG_CRITERIA, userId);
            chain.doFilter(request, response);
        }
        catch (GatewayException e) {
            LOGGER.error((Object)"Unable to authenticate user.", (Throwable)e);
            ((HttpServletResponse)response).setStatus(401);
            return;
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig config) throws ServletException {
    }

    protected Gateway createGateway(GatewayConfig gatewayConfig, String authToken, String requestId) throws GatewayException {
        return GatewayHelper.createGateway((GatewayConfig)gatewayConfig, (String)authToken, (String)requestId);
    }

    protected GatewayConfig createGatewayConfig(TenantBean<AppCache> tenantBean) throws GatewayException {
        return GatewayHelper.createGatewayConfig((ServiceType)ServiceType.INTEGRATION, (String)tenantBean.getTenantId(), (Map)tenantBean.getGatewayConfigParams());
    }
}

