/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.common.helper;

import com.google.gson.GsonBuilder;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.appservices.common.dataaccess.dto.ResponseDto;
import com.konylabs.middleware.appservices.common.dataaccess.dto.TableDto;
import com.konylabs.middleware.appservices.common.dataaccess.exception.DataAccessException;
import com.konylabs.middleware.appservices.common.factory.LocalMetadataDaoFactory;
import com.konylabs.middleware.common.MWProperties;
import com.konylabs.middleware.exceptions.ObjectServicesException;
import com.konylabs.middleware.objservices.metadata.CustomSerializerForFieldDto;
import com.konylabs.middleware.objservices.metadata.FieldDto;
import com.konylabs.middleware.objservices.metadata.MetadataUtils;
import com.konylabs.middleware.objservices.metadata.ObjectServiceMetadataImpl;
import com.konylabs.middleware.request.parser.RequestData;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.List;
import net.sf.json.JSONObject;

public final class AfnServletHelper {
    public static String performGetMetadata(RequestData requestData, String requestURI) throws DataAccessException, IOException {
        String metadata = "";
        ResponseDto responseDto = null;
        Timestamp timestamp = requestData.getAppMetadata().getAppCache().getTimestamp(requestData.getAppVersion());
        String objectName = requestData.getObjectId();
        String metadataVersionRequested = (String)requestData.getCustomParam("X-Kony-Service-Version");
        if (objectName != null && "1.0".equals(metadataVersionRequested)) {
            responseDto = new ResponseDto();
            TableDto tableDto = LocalMetadataDaoFactory.getLocalMetadataDao().getLocalMetaDataObjectFields(requestData.getAppMetadata(), objectName);
            responseDto.setTable(tableDto);
            MetadataUtils.setResponseDto(responseDto, timestamp);
            metadata = "{\"Metadata\":" + JSONObject.fromObject((Object)responseDto) + "}";
        } else if ("2.0".equals(metadataVersionRequested)) {
            ObjectServiceMetadataImpl objectServiceMetadata = new ObjectServiceMetadataImpl();
            responseDto = objectServiceMetadata.getObjectServiceMetadata(requestData.getAppMetadata());
            MetadataUtils.setResponseDto(responseDto, timestamp);
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter(FieldDto.class, (Object)new CustomSerializerForFieldDto());
            metadata = MetadataUtils.getGsonStringFromResponseDto(responseDto, gsonBuilder);
        } else {
            responseDto = new ResponseDto();
            List<TableDto> tableDtos = LocalMetadataDaoFactory.getLocalMetadataDao().getLocalMetaData(requestData.getAppMetadata());
            responseDto.setTables(tableDtos);
            MetadataUtils.setResponseDto(responseDto, timestamp);
            metadata = "{\"Metadata\":" + JSONObject.fromObject((Object)responseDto) + "}";
        }
        return metadata;
    }

    public static String performGetIncrementalMetadata(AppVersion appVersion, String timestamp, String objectName, RequestData requestData) throws ObjectServicesException {
        Timestamp appDifftimestamp = new Timestamp(Long.parseLong(timestamp));
        String metadata = requestData.getAppMetadata().getAppCache().getAppDiffResult(appVersion, appDifftimestamp);
        if (metadata == null) {
            String errorMessage = MessageFormat.format(MWProperties.getInstance().getErrorMessage("invalid_timestamp"), timestamp);
            throw new ObjectServicesException("14058", errorMessage);
        }
        return metadata;
    }

    private AfnServletHelper() {
    }
}

