/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.common.helper;

import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.controller.AsyncHandler;
import com.konylabs.middleware.controller.AsyncHandlersChain;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.dataobject.ResultToJSON;
import com.konylabs.middleware.exceptions.ExceptionUtil;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.request.parser.RequestData;
import com.konylabs.middleware.utilities.ResponseUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DFWSExecuteRequestAsyncHandler
implements AsyncHandler,
AsyncHandlersChain {
    private static final Logger LOGGER = Logger.getLogger(DFWSExecuteRequestAsyncHandler.class);

    DFWSExecuteRequestAsyncHandler() {
    }

    @Override
    public void onSuccess(DataControllerRequest request, DataControllerResponse dcResponse, Context context) {
        RequestData requestData = (RequestData)context.get("requestData");
        HttpServletResponse response = (HttpServletResponse)context.get("response");
        Context parentContext = (Context)context.get("parentContext");
        DataControllerRequest dataControllerRequest = (DataControllerRequest)context.get("dataControllerRequest");
        if (requestData.getResponsePassThrough()) {
            ResponseUtils.addResponseHeadersToServletResponse((HttpServletResponse)response, (DataControllerResponse)dcResponse);
        } else {
            ResponseUtils.addResponseHeaders((HttpServletRequest)((HttpServletRequest)parentContext.get("httpServletRequest")), (HttpServletResponse)response, (Map)dcResponse.getDeviceHeaders());
        }
        this.getParentHandler(parentContext).onSuccess(dataControllerRequest, dcResponse, parentContext);
    }

    @Override
    public void onError(DataControllerRequest request, DataControllerResponse dcResponse, MiddlewareException exception, Context context) {
        LOGGER.error((Object)"caught error ", (Throwable)exception);
        RequestData requestData = (RequestData)context.get("requestData");
        HttpServletResponse response = (HttpServletResponse)context.get("response");
        Context parentContext = (Context)context.get("parentContext");
        DataControllerRequest dataControllerRequest = (DataControllerRequest)context.get("dataControllerRequest");
        if (requestData.getResponsePassThrough()) {
            ResponseUtils.updatePassThroughErrorResponse((HttpServletResponse)response, (Exception)exception);
        } else {
            Result results = new Result();
            ExceptionUtil.addErrorAttributes((Result)results, (MiddlewareException)exception);
            String result = ResultToJSON.convert((Result)results, null);
            dcResponse.setAttribute("chunkedresults_json", (Object)result);
        }
        this.getParentHandler(parentContext).onSuccess(dataControllerRequest, dcResponse, parentContext);
    }

    @Override
    public AsyncHandler getParentHandler(Context parentContext) {
        return (AsyncHandler)parentContext.get("handler");
    }
}

