/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.common.helper;

import com.google.gson.JsonObject;
import com.konylabs.middleware.appservices.common.helper.DFWSAsyncHandler;
import com.konylabs.middleware.appservices.common.helper.DFWSDownloadAsyncHandler;
import com.konylabs.middleware.appservices.common.helper.DFWSExecuteRequestAsyncHandler;
import com.konylabs.middleware.appservices.servlet.AppServicesAsyncHandler;
import com.konylabs.middleware.appservices.servlet.AppServicesServlet;
import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.controller.DataController;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.impl.AbstractDataControllerRequestImpl;
import com.konylabs.middleware.controller.impl.DataControllerRequestHttpImpl;
import com.konylabs.middleware.controller.impl.DataControllerRequestJSONImpl;
import com.konylabs.middleware.controller.impl.DataControllerRequestRowImpl;
import com.konylabs.middleware.mapper.RowNodeCreator;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import com.konylabs.middleware.request.builder.AbstractRowProcessingStratergy;
import com.konylabs.middleware.request.builder.CUDRowProcessingStratergy;
import com.konylabs.middleware.request.builder.GetRowProcessingStratergy;
import com.konylabs.middleware.request.builder.InputPayloadMetadata;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.request.builder.RowMetadata;
import com.konylabs.middleware.request.builder.RowProcessingStrategy;
import com.konylabs.middleware.request.parser.RequestData;
import com.konylabs.middleware.utilities.RequestUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public final class DataFoundationWSHelper {
    private static final Logger LOGGER = Logger.getLogger(DataFoundationWSHelper.class);
    private static DataController controller;
    private static final DFWSAsyncHandler dfwsAsyncHandler;
    private static final DFWSExecuteRequestAsyncHandler dfwsExecuteRequestAsyncHandler;
    private static final DFWSDownloadAsyncHandler dfwsDownloadAsyncHandler;

    public static void setMapperCallbackHandler(RowProcessingStrategy rowProcessingStrategy, ObjectMetadata objectMetaData, DataControllerRequest dcr) {
        dcr.setAttribute("RowNodeCreator", (Object)new RowNodeCreator(new RowMetadata(objectMetaData, objectMetaData.getName()), rowProcessingStrategy));
    }

    public static void executeDownload(HttpServletRequest request, RequestData requestData, HttpServletResponse response, ObjectMetadata objectMetaData, Map<String, String[]> urlParams, Context parentContext) {
        try {
            DataControllerRequest jsonDcr = DataFoundationWSHelper.createDcr(request, urlParams, requestData);
            if (objectMetaData.isOffline()) {
                DataFoundationWSHelper.setMapperCallbackHandler(new GetRowProcessingStratergy(), objectMetaData, jsonDcr);
            }
            Context context = new Context();
            context.put("parentContext", (Object)parentContext);
            context.put("request", (Object)request);
            context.put("response", (Object)response);
            context.put("handler", (Object)dfwsDownloadAsyncHandler);
            DataFoundationWSHelper.executeRequest(jsonDcr, response, requestData, context);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception occurred while invoking get request", (Throwable)e);
            ((AppServicesAsyncHandler)parentContext.get("handler")).onError(request, response, e, parentContext);
        }
    }

    public static void executeRequest(DataControllerRequest dataControllerRequest, HttpServletResponse response, RequestData requestData, Context parentContext) {
        controller = AppServicesServlet.getDataController();
        Context context = new Context();
        context.put("parentContext", (Object)parentContext);
        context.put("requestData", (Object)requestData);
        context.put("response", (Object)response);
        context.put("dataControllerRequest", (Object)dataControllerRequest);
        context.put("handler", (Object)dfwsExecuteRequestAsyncHandler);
        controller.processDataRequest(dataControllerRequest, context);
    }

    public static DataControllerRequest createDcr(HttpServletRequest request, Map<String, String[]> urlParams, RequestData requestData) throws IOException {
        AbstractDataControllerRequestImpl dcr;
        String objectServiceName = requestData.getAppId();
        String objectId = requestData.getObjectId();
        String serviceId = requestData.getServiceId();
        boolean requestPassThrough = requestData.getRequestPassThrough();
        String channel = request.getParameter("channel");
        if (requestPassThrough) {
            dcr = new DataControllerRequestHttpImpl(request, null);
            dcr.setAttribute("passThruHttpEntity", request.getInputStream());
        } else {
            JsonObject payload = (JsonObject)requestData.getParam("jsondata");
            dcr = new DataControllerRequestJSONImpl(payload, request);
            dcr.setAttribute("appregistry_Cache", requestData.getAppMetadata().getAppCache());
            Map<String, String> queryParamMap = requestData.getQueryParamMap();
            dcr.setAttribute("queryparams", queryParamMap);
            dcr.setAttribute("kqueryparams", queryParamMap);
            Set<String> keys = urlParams.keySet();
            for (String key : keys) {
                dcr.addRequestParam_(key, urlParams.get(key)[0]);
            }
        }
        dcr.setAttribute("tenantBean", request.getAttribute("tenantBean"));
        dcr.setAttribute("cacheDirector", RequestUtils.getAttribute((HttpServletRequest)request, (String)"cacheDirector"));
        dcr.setAttribute("metricsBean", request.getAttribute("metricsBean"));
        dcr.setAttribute("gatewaywrapperobject", requestData.getMbaasGateWayWrapper());
        dcr.addRequestParam_("objectID", objectId);
        dcr.addRequestParam_("appID", objectServiceName);
        dcr.addRequestParam_("serviceID", serviceId);
        DataFoundationWSHelper.setMapperCallbackHandler(new AbstractRowProcessingStratergy(), requestData.getObjectMetadata(), dcr);
        dcr.addRequestParam_("channel", channel != null && !channel.trim().isEmpty() ? channel : "rc");
        dcr.getHeaderMap().put("X-Kony-API-Version", requestData.getAppVersion().getVersion());
        return dcr;
    }

    public static DataControllerRequest createDcr(InputPayloadMetadata payloadMetadata, Row row) {
        HttpServletRequest request = payloadMetadata.getHttpServletRequest();
        DataControllerRequestRowImpl dcr = new DataControllerRequestRowImpl(row, request);
        String channel = request.getParameter("channel");
        dcr.setAttribute("tenantBean", request.getAttribute("tenantBean"));
        dcr.setAttribute("cacheDirector", RequestUtils.getAttribute((HttpServletRequest)request, (String)"cacheDirector"));
        dcr.setAttribute("queryparams", payloadMetadata.getQueryParamMap());
        dcr.addRequestParam_("channel", channel != null && !channel.trim().isEmpty() ? channel : "rc");
        dcr.getHeaderMap().put("X-Kony-API-Version", row.getMetadata().getAppVersion().getVersion());
        AbstractRowProcessingStratergy rowProcessingStrategy = row.getMetadata().getObjectMetadata().isOffline() ? new CUDRowProcessingStratergy() : new AbstractRowProcessingStratergy();
        DataFoundationWSHelper.setMapperCallbackHandler(rowProcessingStrategy, row.getMetadata().getObjectMetadata(), dcr);
        dcr.setAttribute("appregistry_Cache", payloadMetadata.getRequestData().getAppMetadata().getAppCache());
        dcr.setAttribute("gatewaywrapperobject", payloadMetadata.getRequestData().getMbaasGateWayWrapper());
        dcr.setAttribute("metricsBean", request.getAttribute("metricsBean"));
        return dcr;
    }

    public static void executeRequest(DataControllerRequest dataControllerRequest, HttpServletResponse response, Context parentContext) {
        DataController dataController = AppServicesServlet.getDataController();
        Context context = new Context();
        context.put("parentContext", (Object)parentContext);
        context.put("dataControllerRequest", (Object)dataControllerRequest);
        context.put("response", (Object)response);
        context.put("handler", (Object)dfwsAsyncHandler);
        dataController.processDataRequest(dataControllerRequest, context);
    }

    private DataFoundationWSHelper() {
    }

    static {
        dfwsAsyncHandler = new DFWSAsyncHandler();
        dfwsExecuteRequestAsyncHandler = new DFWSExecuteRequestAsyncHandler();
        dfwsDownloadAsyncHandler = new DFWSDownloadAsyncHandler();
    }
}

