/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.common.helper;

import com.konylabs.middleware.appservices.common.constants.ObjectParamEnum;
import com.konylabs.middleware.appservices.common.dataaccess.dto.ResponseDto;
import com.konylabs.middleware.objservices.metadata.FieldDto;
import com.konylabs.middleware.objservices.metadata.NamespaceDto;
import com.konylabs.middleware.objservices.metadata.ObjectDto;
import com.konylabs.middleware.objservices.metadata.RelationshipDto;
import com.konylabs.middleware.registry.impl.ActionBean;
import com.konylabs.middleware.registry.impl.ApplicationDiffBean;
import com.konylabs.middleware.registry.impl.MetadataKey;
import com.konylabs.middleware.registry.impl.ObjectBean;
import com.konylabs.middleware.registry.impl.ObjectMetadataBean;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class IncrementalMetadataHelper {
    public static List<NamespaceDto> getNamespaceDtosFromAppDiffBean(ApplicationDiffBean appDiffBean) {
        Map<String, ObjectBean> appDiffMap = appDiffBean.getAppDiffMap();
        LinkedHashMap<String, NamespaceDto> namespaceDtoMap = new LinkedHashMap<String, NamespaceDto>();
        ArrayList<NamespaceDto> namespaceDtoList = new ArrayList<NamespaceDto>();
        for (Map.Entry<String, ObjectBean> entry : appDiffMap.entrySet()) {
            String objectId = entry.getKey();
            ObjectDto objectDto = IncrementalMetadataHelper.getObjectDtoFromObjectBean(entry.getValue());
            String namespace = IncrementalMetadataHelper.getNamespaceFromNamespaceObject(objectId);
            List<ObjectDto> objectDtoList = null;
            NamespaceDto namespaceDto = (NamespaceDto)namespaceDtoMap.get(namespace);
            if (namespaceDto != null) {
                objectDtoList = namespaceDto.getObjects();
                objectDtoList.add(objectDto);
                if (!namespaceDto.getAction().equalsIgnoreCase(objectDto.getAction())) {
                    namespaceDto.setAction("");
                }
            } else {
                namespaceDto = new NamespaceDto("");
                namespaceDto.setName(namespace);
                namespaceDto.setAction(ActionBean.ACTION_VALUES.CREATE.name());
                objectDtoList = new ArrayList<ObjectDto>();
                objectDtoList.add(objectDto);
                if (!namespaceDto.getAction().equalsIgnoreCase(objectDto.getAction())) {
                    namespaceDto.setAction(objectDto.getAction());
                }
            }
            namespaceDto.setObjects(objectDtoList);
            namespaceDtoMap.put(namespace, namespaceDto);
        }
        for (Map.Entry<String, ObjectBean> entry : namespaceDtoMap.entrySet()) {
            namespaceDtoList.add((NamespaceDto)((Object)entry.getValue()));
        }
        return namespaceDtoList;
    }

    private static String getNamespaceFromNamespaceObject(String objectId) {
        return objectId.contains(".") ? objectId.split("\\.")[0] : "";
    }

    private static String getObjectIdFromNamespaceObject(String objectId) {
        return objectId.contains(".") ? objectId.split("\\.")[1] : objectId;
    }

    private static ObjectDto getObjectDtoFromObjectBean(ObjectBean objectBean) {
        ObjectDto objectDto = objectBean.getObjectDto();
        objectDto.setName(IncrementalMetadataHelper.getObjectIdFromNamespaceObject(objectBean.getObjectId()));
        objectDto.setAction(objectBean.getAction());
        Map<MetadataKey, ObjectMetadataBean> objectMetadataMap = objectBean.getObjectMetadataMap();
        for (Map.Entry<MetadataKey, ObjectMetadataBean> metadataEntry : objectMetadataMap.entrySet()) {
            if ("com.konylabs.middleware.registry.vo.Field".equalsIgnoreCase(metadataEntry.getKey().getType())) {
                IncrementalMetadataHelper.updateFieldsListInObjectDto(objectDto, metadataEntry);
                continue;
            }
            if (!"com.konylabs.middleware.registry.vo.Relation".equalsIgnoreCase(metadataEntry.getKey().getType())) continue;
            IncrementalMetadataHelper.updateRelationshipListInTableDto(objectDto, metadataEntry);
        }
        return objectDto;
    }

    private static void updateRelationshipListInTableDto(ObjectDto objectDto, Map.Entry<MetadataKey, ObjectMetadataBean> metadataEntry) {
        ObjectMetadataBean relationMetadata = metadataEntry.getValue();
        RelationshipDto relationshipDto = (RelationshipDto)relationMetadata.getMetadata();
        relationshipDto.setAction(relationMetadata.getAction());
        List<RelationshipDto> relationshipDtoList = objectDto.getRelationships();
        if (relationshipDtoList == null) {
            relationshipDtoList = new ArrayList<RelationshipDto>();
        }
        relationshipDtoList.add(relationshipDto);
        objectDto.setRelationships(relationshipDtoList);
    }

    private static void updateFieldsListInObjectDto(ObjectDto objectDto, Map.Entry<MetadataKey, ObjectMetadataBean> metadataEntry) {
        ObjectMetadataBean columnMetadata = metadataEntry.getValue();
        FieldDto fieldDto = (FieldDto)columnMetadata.getMetadata();
        fieldDto.setAction(columnMetadata.getAction());
        List<FieldDto> fieldDtoList = objectDto.getFields();
        if (fieldDtoList == null) {
            fieldDtoList = new ArrayList<FieldDto>();
        }
        fieldDtoList.add(fieldDto);
        objectDto.setFields(fieldDtoList);
    }

    public static void setAppConfigParamsToRespDto(ApplicationDiffBean appDiffBean, ResponseDto responseDto) {
        for (Map.Entry<String, String> appDiffEntry : appDiffBean.getAppConfigParmDiffMap().entrySet()) {
            ObjectParamEnum objectParamEnum = ObjectParamEnum.getObjectParamByValue(appDiffEntry.getKey());
            if (objectParamEnum == null) continue;
            switch (objectParamEnum) {
                case offline: {
                    responseDto.setOffline(appDiffEntry.getValue());
                    break;
                }
                case uploadCache: {
                    responseDto.setUploadCache(appDiffEntry.getValue());
                    break;
                }
                case conflict_policy: {
                    responseDto.setConflict_policy(appDiffEntry.getValue());
                    break;
                }
            }
        }
    }
}

