/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.common.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;

public abstract class AbstractOnlineResponseFormatter {
    public JsonObject prepareGetResponse(JsonObject middlewareResponse, ObjectMetadata objectMetaData) {
        JsonObject outputResponse = new JsonObject();
        JsonObject resultResponse = new JsonObject();
        String objectId = objectMetaData.getName();
        if (middlewareResponse.has(objectId)) {
            JsonElement middlewareResponseObject = middlewareResponse.get(objectId);
            if (middlewareResponseObject.isJsonArray()) {
                outputResponse.add("records", (JsonElement)middlewareResponseObject.getAsJsonArray());
            } else {
                resultResponse = middlewareResponseObject.getAsJsonObject();
            }
        } else {
            Long httpStatusCode = 200L;
            int opStatus = 0;
            if (middlewareResponse.has("httpStatusCode")) {
                httpStatusCode = middlewareResponse.get("httpStatusCode").getAsLong();
                outputResponse.addProperty("httpStatusCode", (Number)httpStatusCode);
                middlewareResponse.remove("httpStatusCode");
            }
            if (middlewareResponse.has("opstatus")) {
                opStatus = middlewareResponse.get("opstatus").getAsInt();
                outputResponse.addProperty("opstatus", (Number)opStatus);
                middlewareResponse.remove("opstatus");
            }
            resultResponse = middlewareResponse;
        }
        if (!outputResponse.has("records")) {
            JsonArray responseJson = new JsonArray();
            if (!resultResponse.entrySet().isEmpty()) {
                responseJson.add((JsonElement)resultResponse);
            }
            outputResponse.add("records", (JsonElement)responseJson);
        }
        ObjectServiceUtil.addMiddlewareAttributes(middlewareResponse, outputResponse);
        return outputResponse;
    }

    protected JsonObject extractMiddlewareResponse(JsonObject middlewareResponse, ObjectMetadata objectMetaData) {
        JsonObject jsonRecord = null;
        String objectId = objectMetaData.getName();
        if (middlewareResponse.has(objectId)) {
            JsonArray jsonArray = middlewareResponse.get(objectId).getAsJsonArray();
            jsonRecord = jsonArray.get(0).getAsJsonObject();
        } else {
            jsonRecord = middlewareResponse;
        }
        return jsonRecord;
    }

    public boolean isStatus204(JsonObject middlewareResponse) {
        return middlewareResponse.has("httpStatusCode") && middlewareResponse.get("httpStatusCode").getAsInt() == 204;
    }

    abstract JsonObject prepareCreateResponse(JsonObject var1, ObjectMetadata var2);

    abstract JsonObject prepareUpdateResponse(JsonObject var1, ObjectMetadata var2);

    abstract JsonObject preparePartialUpdateResponse(JsonObject var1, ObjectMetadata var2);

    abstract JsonObject prepareDeleteResponse(JsonObject var1, ObjectMetadata var2, DataControllerRequest var3);
}

