/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.common.util;

import com.kony.adapter.exception.DataAdapterException;
import com.kony.adapter.model.BinaryContent;
import com.konylabs.middleware.appservices.common.util.UploadFileContainer;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public final class BinaryOperandUtils {
    private static final Logger LOGGER = Logger.getLogger(BinaryOperandUtils.class);

    public static UploadFileContainer getUploadedFileDataField(Object fieldValue, DataAdapterData dataAdapterData) throws DataAdapterException {
        BinaryContent.BINARY_CONTENT_TYPE contentType = BinaryContent.BINARY_CONTENT_TYPE.BASE_64;
        UploadFileContainer uploadContainer = new UploadFileContainer();
        if (fieldValue instanceof InputStream) {
            contentType = BinaryContent.BINARY_CONTENT_TYPE.STREAM;
        } else {
            File uploadedFile = dataAdapterData.getDataControllerRequest().getUploadedFile(fieldValue.toString());
            if (uploadedFile != null) {
                try {
                    fieldValue = new FileInputStream(uploadedFile);
                }
                catch (FileNotFoundException e) {
                    LOGGER.error((Object)("Uploaded File Not Found " + uploadedFile.getName()));
                    throw new DataAdapterException(e.getMessage());
                }
                contentType = BinaryContent.BINARY_CONTENT_TYPE.STREAM;
            }
        }
        uploadContainer.setFieldValue(fieldValue);
        uploadContainer.setContentType(contentType);
        return uploadContainer;
    }

    private BinaryOperandUtils() {
    }
}

