/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.common.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.konylabs.middleware.appservices.common.constants.OperationEnum;
import com.konylabs.middleware.appservices.common.util.OfflineUtil;
import com.konylabs.middleware.objservices.runtime.BatchDeltaContextDTO;
import com.konylabs.middleware.objservices.runtime.ObjectDeltaContextDTO;
import com.konylabs.middleware.objservices.runtime.ResponseDeltaContextDTO;
import com.konylabs.middleware.objservices.runtime.metadata.DeltaContextFieldObject;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.request.parser.RequestData;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DeltaContextUtil {
    private static final String AND_DELTACTXTFILTERAPPENDER = " and ";
    private static final String GT_DELTACTXTFILTERAPPENDER = " gt ";
    private static final Logger LOGGER = Logger.getLogger(DeltaContextUtil.class);

    public ResponseDeltaContextDTO getDeltaContextObjectFromRequest(RequestData requestData) {
        JsonElement rawJsonDeltaContext = (JsonElement)requestData.getInputParams().get("delta_context");
        if (rawJsonDeltaContext != null && rawJsonDeltaContext.isJsonObject()) {
            return this.prepareDeltaContextObj(rawJsonDeltaContext.getAsJsonObject());
        }
        return new ResponseDeltaContextDTO();
    }

    public void addDeltaCtxtToResponse(ResponseDeltaContextDTO resDeltaContext, RequestData requestData, JsonObject middlewareResponse, JsonObject outputResponse, ObjectMetadata objectMetadata) {
        if ((middlewareResponse.has("processed_delta_context") || requestData.getDeltaContextMap().size() > 0) && resDeltaContext != null) {
            resDeltaContext.setCurobj(null);
            outputResponse.add("delta_context", new Gson().toJsonTree((Object)resDeltaContext, ResponseDeltaContextDTO.class));
        }
    }

    public ResponseDeltaContextDTO updateDeltaContextFromResponse(ResponseDeltaContextDTO resDeltaContext, RequestData requestData, JsonObject middlewareResponse, ObjectMetadata objectMetadata) {
        ObjectDeltaContextDTO oDTO = null;
        ResponseDeltaContextDTO responseDeltaContextDTO = resDeltaContext = resDeltaContext != null ? resDeltaContext : new ResponseDeltaContextDTO();
        if (resDeltaContext.getObjs() != null) {
            oDTO = resDeltaContext.getObjs().get(objectMetadata.getId());
        }
        if ((oDTO = DeltaContextUtil.getOrUpdateObjectDeltaContext(objectMetadata, middlewareResponse, oDTO, requestData)) != null) {
            if (resDeltaContext.getObjs() == null) {
                resDeltaContext.setObjs(new HashMap<String, ObjectDeltaContextDTO>());
            }
            resDeltaContext.getObjs().put(objectMetadata.getId(), oDTO);
        }
        return resDeltaContext;
    }

    public ResponseDeltaContextDTO processDeltaContextFromRequest(RequestData requestData, JsonObject deltaContext, ObjectMetadata runtimeObject, Map<String, String[]> urlParams) {
        ResponseDeltaContextDTO resDeltaContext = this.prepareDeltaContextObj(deltaContext);
        this.addFiltersFromDeltaContext(requestData, runtimeObject, urlParams, resDeltaContext);
        return resDeltaContext;
    }

    public void processDeltaContext(RequestData requestData, ResponseDeltaContextDTO deltaContextObj, ObjectMetadata runtimeObject, Map<String, String[]> urlParams) {
        this.addFiltersFromDeltaContext(requestData, runtimeObject, urlParams, deltaContextObj);
    }

    private void addFiltersFromDeltaContext(RequestData requestData, ObjectMetadata runtimeObject, Map<String, String[]> urlParams, ResponseDeltaContextDTO resDeltaContext) {
        if (resDeltaContext != null && resDeltaContext.getObjs() != null && resDeltaContext.getObjs().containsKey(runtimeObject.getId())) {
            ObjectDeltaContextDTO deltaContextObj = resDeltaContext.getObjs().get(runtimeObject.getId());
            this.addObjectServiceLevelFilter(deltaContextObj, urlParams, requestData);
            if (deltaContextObj.getBc() != null) {
                BatchDeltaContextDTO batchCtxt = deltaContextObj.getBc();
                if (batchCtxt.getBatchid() != null && !batchCtxt.getBatchid().isEmpty()) {
                    requestData.getQueryParamMap().put("$batchid", batchCtxt.getBatchid());
                    urlParams.put("$batchid", new String[]{batchCtxt.getBatchid()});
                    this.setGetVariant(requestData, runtimeObject.getId(), OperationEnum.getbatch.name());
                    requestData.putDeltaContextParam(runtimeObject.getId(), batchCtxt.getBdelta());
                }
            } else if (deltaContextObj.getDelta() != null) {
                String lastUpdateTimeFilter = this.prepareLastUpdateTimeFilter(runtimeObject.getDeltaContextfieldObj(), deltaContextObj);
                String dollorFilterFromRequest = requestData.getQueryParamMap().get("$filter");
                if (dollorFilterFromRequest != null && !dollorFilterFromRequest.isEmpty()) {
                    StringBuilder dollorFilterValueSB = new StringBuilder(lastUpdateTimeFilter).append(AND_DELTACTXTFILTERAPPENDER).append(dollorFilterFromRequest);
                    requestData.getQueryParamMap().put("$filter", dollorFilterValueSB.toString());
                    urlParams.put("$filter", new String[]{dollorFilterValueSB.toString()});
                } else {
                    requestData.getQueryParamMap().put("$filter", lastUpdateTimeFilter);
                    urlParams.put("$filter", new String[]{lastUpdateTimeFilter});
                }
                this.setGetVariant(requestData, runtimeObject.getId(), OperationEnum.getupdated.name());
                requestData.putDeltaContextParam(runtimeObject.getId(), deltaContextObj.getDelta());
            }
        }
    }

    private String prepareLastUpdateTimeFilter(DeltaContextFieldObject deltaContextFieldObject, ObjectDeltaContextDTO deltaContextObj) {
        StringBuilder lastUpdateTimeFilter = new StringBuilder(deltaContextFieldObject.getDeltaContextFieldName()).append(GT_DELTACTXTFILTERAPPENDER);
        return deltaContextFieldObject.getDataType().equalsIgnoreCase("number") ? lastUpdateTimeFilter.append(deltaContextObj.getDelta()).toString() : lastUpdateTimeFilter.append("'").append(deltaContextObj.getDelta()).append("'").toString();
    }

    public static ObjectDeltaContextDTO getOrUpdateObjectDeltaContext(ObjectMetadata runtimeObject, JsonObject middlewareResponse, ObjectDeltaContextDTO oDTO, RequestData requestData) {
        String deltaContextValue = DeltaContextUtil.compareUpdateDeltaContext(runtimeObject, middlewareResponse, requestData);
        if (middlewareResponse.has("hasMoreRecords") && !middlewareResponse.get("hasMoreRecords").isJsonNull() && middlewareResponse.get("hasMoreRecords").getAsBoolean() && middlewareResponse.has("nextBatchId")) {
            String batchID = middlewareResponse.get("nextBatchId").getAsString();
            oDTO = oDTO != null ? oDTO : new ObjectDeltaContextDTO();
            BatchDeltaContextDTO batchDTO = oDTO.getBc() != null ? oDTO.getBc() : new BatchDeltaContextDTO();
            oDTO.setBc(batchDTO);
            if (deltaContextValue != null) {
                oDTO.getBc().setBdelta(deltaContextValue);
            }
            oDTO.getBc().setBatchid(batchID.toString());
        } else {
            if (deltaContextValue != null) {
                oDTO = oDTO != null ? oDTO : new ObjectDeltaContextDTO();
                oDTO.setDelta(deltaContextValue);
            }
            if (oDTO != null) {
                oDTO.setBc(null);
            }
        }
        return oDTO;
    }

    private static String compareUpdateDeltaContext(ObjectMetadata runtimeObject, JsonObject middlewareResponse, RequestData requestData) {
        Long storedMaxDeltaValue;
        Long deltaValueFromRequestInLong = null;
        DeltaContextFieldObject deltaCntxtMetaObj = runtimeObject.getDeltaContextfieldObj();
        if (deltaCntxtMetaObj != null && requestData.getDeltaContextMap().get(runtimeObject.getName()) != null) {
            deltaValueFromRequestInLong = DeltaContextUtil.getRequestedDeltaValueFromRequestInLong(deltaCntxtMetaObj, requestData.getDeltaContextMap().get(runtimeObject.getName()));
        }
        Long finalDeltaValue = null;
        Long l = storedMaxDeltaValue = middlewareResponse.has("processed_delta_context") ? Long.valueOf(middlewareResponse.get("processed_delta_context").getAsLong()) : null;
        if (storedMaxDeltaValue != null && deltaValueFromRequestInLong != null) {
            finalDeltaValue = storedMaxDeltaValue > deltaValueFromRequestInLong ? storedMaxDeltaValue : deltaValueFromRequestInLong;
        } else if (storedMaxDeltaValue != null) {
            finalDeltaValue = storedMaxDeltaValue;
        } else if (deltaValueFromRequestInLong != null) {
            finalDeltaValue = deltaValueFromRequestInLong;
        }
        Object deltaContextValue = null;
        if (finalDeltaValue != null) {
            deltaContextValue = deltaCntxtMetaObj.getDataType().equalsIgnoreCase("date") ? OfflineUtil.getDateFormatFromMilliseconds(finalDeltaValue, "", false) : (!deltaCntxtMetaObj.getTimeStampFieldFormat().isEmpty() ? OfflineUtil.getDateFormatFromMilliseconds(finalDeltaValue, deltaCntxtMetaObj.getTimeStampFieldFormat(), false) : finalDeltaValue);
        }
        return deltaContextValue != null ? deltaContextValue.toString() : null;
    }

    private static long getRequestedDeltaValueFromRequestInLong(DeltaContextFieldObject deltaCntxtMetaObj, Object requestDeltaContextValue) {
        Long deltactxtInLong = 0L;
        if (requestDeltaContextValue != null) {
            deltactxtInLong = deltaCntxtMetaObj.getTimeStampFieldFormat() != null && !deltaCntxtMetaObj.getDataType().equalsIgnoreCase("number") ? Long.valueOf(OfflineUtil.getTimeInMilliseconds(requestDeltaContextValue, deltaCntxtMetaObj.getTimeStampFieldFormat())) : Long.valueOf(Long.parseLong(requestDeltaContextValue.toString()));
        }
        return deltactxtInLong;
    }

    public ResponseDeltaContextDTO prepareDeltaContextObj(JsonObject deltaContextValueInRequest) {
        return (ResponseDeltaContextDTO)new Gson().fromJson((JsonElement)deltaContextValueInRequest, ResponseDeltaContextDTO.class);
    }

    private void addObjectServiceLevelFilter(ObjectDeltaContextDTO deltaContextObj, Map<String, String[]> urlParams, RequestData requestData) {
        if (deltaContextObj.getOdataString() != null) {
            String[] odataParamsArray;
            for (String odataParams : odataParamsArray = deltaContextObj.getOdataString().split("&")) {
                String[] odataParamaters;
                if (!odataParams.contains("=") || (odataParamaters = odataParams.split("=")).length != 2) continue;
                String value = odataParamaters[1].toString();
                urlParams.put(odataParamaters[0].trim(), new String[]{value});
                requestData.getQueryParamMap().put(odataParamaters[0].trim(), value);
            }
        }
    }

    public static String getGetVariantServiceId(ApplicationMetadata appMetadata, String objectId, Object operationId) {
        String serviceId = null;
        if (appMetadata.getOperatonMapingByObjectId(objectId).containsKey(operationId)) {
            serviceId = appMetadata.getOperatonMapingByObjectId(objectId).get(operationId).getServiceid();
            LOGGER.debug((Object)new StringBuilder("Service fetched ").append(serviceId).append(" for Operation ").append(operationId));
        }
        return serviceId;
    }

    private void setGetVariant(RequestData requestData, String objectName, String operationName) {
        String serviceID = DeltaContextUtil.getGetVariantServiceId(requestData.getAppMetadata(), objectName, operationName);
        if (StringUtils.isNotBlank((String)serviceID)) {
            requestData.setServiceId(serviceID);
        }
    }
}

