/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.common.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.konylabs.middleware.appservices.common.util.DeltaContextUtil;
import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.objservices.runtime.ResponseDeltaContextDTO;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import com.konylabs.middleware.request.parser.RequestData;

public class DownloadResponseFormatter {
    public static JsonObject processJsonResponse(Object result, RequestData requestData, ObjectMetadata objectMetadata, ResponseDeltaContextDTO reqDeltaContext) {
        boolean isStatus204;
        if (result == null) {
            return null;
        }
        JsonObject outputResponse = new JsonObject();
        JsonObject middlewareResponse = new JsonParser().parse(result.toString()).getAsJsonObject();
        DeltaContextUtil deltaContextUtil = new DeltaContextUtil();
        String objectId = requestData.getObjectId();
        JsonObject finalResponse = new JsonObject();
        boolean bl = isStatus204 = middlewareResponse.has("httpStatusCode") && middlewareResponse.get("httpStatusCode").getAsInt() == 204;
        if (!isStatus204 && middlewareResponse.has("errmsg")) {
            outputResponse = middlewareResponse;
        } else {
            if (middlewareResponse.has(objectId)) {
                JsonElement middlewareResponseObject = middlewareResponse.get(objectId);
                if (middlewareResponseObject instanceof JsonArray) {
                    outputResponse.add("records", (JsonElement)((JsonArray)middlewareResponseObject));
                } else {
                    finalResponse = (JsonObject)middlewareResponseObject;
                }
                JsonObject metadataJsonObj = ObjectServiceUtil.addMetadataToGetOperation(middlewareResponse);
                if (metadataJsonObj != null) {
                    outputResponse.add("_metadata", (JsonElement)metadataJsonObj);
                }
                DownloadResponseFormatter.addBatchIdToOutputResponse(requestData, outputResponse);
                deltaContextUtil.addDeltaCtxtToResponse(reqDeltaContext, requestData, middlewareResponse, outputResponse, objectMetadata);
            } else {
                DownloadResponseFormatter.setHttpAndOpstatus(outputResponse, middlewareResponse);
                finalResponse = middlewareResponse;
            }
            if (!outputResponse.has("records")) {
                JsonArray responseJson = new JsonArray();
                if (!finalResponse.entrySet().isEmpty()) {
                    responseJson.add((JsonElement)finalResponse);
                }
                outputResponse.add("records", (JsonElement)responseJson);
            }
            ObjectServiceUtil.addMiddlewareAttributes(middlewareResponse, outputResponse);
        }
        return outputResponse;
    }

    public static void setHttpAndOpstatus(JsonObject outputResponse, JsonObject middlewareResponse) {
        int httpStatusCode = 200;
        int opStatus = 0;
        if (middlewareResponse.has("opstatus")) {
            opStatus = middlewareResponse.get("opstatus").getAsInt();
            outputResponse.addProperty("opstatus", (Number)opStatus);
            middlewareResponse.remove("opstatus");
        }
        if (middlewareResponse.has("httpStatusCode")) {
            httpStatusCode = middlewareResponse.get("httpStatusCode").getAsInt();
            outputResponse.addProperty("httpStatusCode", (Number)httpStatusCode);
            middlewareResponse.remove("httpStatusCode");
        }
    }

    private static void addBatchIdToOutputResponse(RequestData requestData, JsonObject outputResponse) {
        if (requestData.getQueryParamMap().containsKey("$batchid")) {
            outputResponse.addProperty("batchId", requestData.getQueryParamMap().get("$batchid").toString());
        }
    }
}

