/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.common.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.api.processor.StreamWriter;
import com.konylabs.middleware.api.processor.impl.ResponseData;
import com.konylabs.middleware.api.processor.manager.FabricResponseManager;
import com.konylabs.middleware.appservices.common.util.ResponseStatusEnum;
import com.konylabs.middleware.common.MWProperties;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.dataobject.Param;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.dataobject.ResultToJSON;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.objservices.runtime.request.cache.DatabaseUploadCacheImpl;
import com.konylabs.middleware.objservices.runtime.request.cache.UploadCacheService;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.registry.vo.Operationmapping;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.request.parser.RequestData;
import com.konylabs.middleware.response.HttpIntegrityResponseWrapper;
import com.konylabs.middleware.utilities.EncodeUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import com.konylabs.middleware.utilities.RequestUtils;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class ObjectServiceUtil {
    private static final Logger LOGGER = Logger.getLogger(ObjectServiceUtil.class);

    public static String getOverrideMethod(HttpServletRequest request) {
        return request.getHeader("X-HTTP-Method-Override");
    }

    protected static JsonObject prepareJsonPayLoadFromKeyValuePair(String key, String value) {
        JsonObject jsonPayLoad = new JsonObject();
        if (!key.isEmpty() && !value.isEmpty()) {
            jsonPayLoad.addProperty(key, value);
            return jsonPayLoad;
        }
        return jsonPayLoad;
    }

    public static String removeQutoesIfInputDCValueSentAsString(String deltaContextValue) {
        String formattedDeltaContextValue = deltaContextValue;
        if (deltaContextValue != null) {
            formattedDeltaContextValue = deltaContextValue.replaceAll("^\"|\"$", "");
        }
        return formattedDeltaContextValue;
    }

    public static void setQueryParams(HttpServletRequest request, RequestData requestData) {
        Map urlParams = request.getParameterMap();
        Set keys = urlParams.keySet();
        for (String key : keys) {
            String decodedKey = EncodeUtils.decode((String)key);
            String val = ((String[])urlParams.get(key))[0];
            String decodedVal = EncodeUtils.decode((String)val);
            requestData.getQueryParamMap().put(decodedKey, decodedVal);
        }
    }

    public static void addMiddlewareAttributes(JsonObject source, JsonObject outputResponse) {
        if (source.has("opstatus")) {
            outputResponse.add("opstatus", source.get("opstatus"));
        }
        if (source.has("hasMoreRecords") && !source.get("hasMoreRecords").isJsonNull()) {
            String hasMoreRecordsParam = source.get("hasMoreRecords").getAsString();
            outputResponse.addProperty("hasMoreRecords", hasMoreRecordsParam);
            boolean hasMorerecords = hasMoreRecordsParam.equalsIgnoreCase("true");
            if (source.has("nextBatchId") && hasMorerecords) {
                outputResponse.add("nextBatchId", source.get("nextBatchId"));
            }
        }
        if (source.has("httpStatusCode") && !outputResponse.has("httpStatusCode")) {
            outputResponse.add("httpStatusCode", source.get("httpStatusCode"));
        }
    }

    public static JsonObject addMetadataToGetOperation(JsonObject source) {
        JsonObject metadataJsonObj = null;
        if (source.has("recordCount")) {
            metadataJsonObj = new JsonObject();
            Long totalRecordsParam = source.get("recordCount").getAsLong();
            metadataJsonObj.addProperty("recordCount", (Number)totalRecordsParam);
            Long updatedrecords = source.has("updatedRecords") ? source.get("updatedRecords").getAsLong() : 0L;
            metadataJsonObj.addProperty("updatedRecords", (Number)updatedrecords);
            Long deletedrecords = source.has("deletedRecords") ? source.get("deletedRecords").getAsLong() : 0L;
            metadataJsonObj.addProperty("deletedRecords", (Number)deletedrecords);
        }
        return metadataJsonObj;
    }

    public static boolean isValidHttpCode(int code) {
        return code / 100 >= 1 && code / 100 <= 5;
    }

    public static void addFilterValues(String exp, DataControllerRequest jsonDcr) {
        String[] filters;
        exp = exp.replace('[', ' ');
        exp = exp.replace(']', ' ');
        exp = exp.replace('\'', ' ');
        exp = exp.replace('\"', ' ');
        for (String filter : filters = exp.split("and")) {
            String[] str = null;
            str = filter.split("eq");
            if (str.length != 2) continue;
            str[0] = str[0].trim();
            str[1] = str[1].trim();
            jsonDcr.addRequestParam_(str[0], str[1]);
        }
    }

    public static String removeSlashAtFirst(String path) {
        int index = path.indexOf("/");
        if (index == 0 && path.length() > 0) {
            path = path.substring(1, path.length());
        }
        return path;
    }

    public static String getAppservicesMetadataUrl() {
        return MWProperties.getInstance().getUrl("kony.app.services.metadata.url");
    }

    public static String getAppservicesDataUrl() {
        return MWProperties.getInstance().getUrl("kony.app.services.data.url");
    }

    public static String getErrorMsgByMiddlewareException(MiddlewareException e) {
        return ObjectServiceUtil.getErrorMsg(e.getErrorCode(), e.getMessage());
    }

    public static String getErrorMsg(String opstatus, String errmsg) {
        Result result = new Result();
        result.addParam(new Param("opstatus", opstatus, "int"));
        result.addParam(new Param("errmsg", errmsg, "string"));
        return ResultToJSON.convert((Result)result);
    }

    public static String getErrorMsgWithHttpStatusCode(MiddlewareException e) {
        return MiddlewareUtils.getResponseJsonString(e.getErrorCode(), e.getHttpStatusCode(), e.getMessage());
    }

    public static void sendResponse(String errorMsg, HttpServletResponse response) throws IOException {
        LOGGER.error((Object)errorMsg);
        PrintWriter writer = response.getWriter();
        writer.println(errorMsg);
        writer.flush();
        writer.close();
    }

    public static ApplicationMetadata getApplicationMetadataFromService(Service service) {
        ServiceMetadata serviceMetadata;
        ApplicationMetadata appMetadata = null;
        if (service != null && (serviceMetadata = (ServiceMetadata)service.getCustomObjMap().get("serviceMetadataKey")) != null) {
            appMetadata = serviceMetadata.getAppMetadata();
        }
        return appMetadata;
    }

    public static ApplicationMetadata getApplicationMetadataFromDataControllerRequest(DataControllerRequest dcRequest) {
        AppVersion appVersion = new AppVersion(dcRequest.getParameter("appID"), dcRequest.getHeader("X-Kony-API-Version"));
        AppCache appCache = (AppCache)dcRequest.getAttribute("appregistry_Cache");
        ApplicationMetadata appMetaData = (ApplicationMetadata)appCache.getAppMetadata(appVersion);
        return appMetaData;
    }

    private ObjectServiceUtil() {
    }

    public static void addHttpStatusCodeAndOpstatusAsPerResponseStatus(ResponseStatusEnum requestStatus, JsonObject outputResponse) {
        if (requestStatus != null) {
            outputResponse.addProperty("opstatus", (Number)requestStatus.getOpStatusByResponseStatus());
            outputResponse.addProperty("httpStatusCode", (Number)requestStatus.getHttpStatusCodeByResponseStatus());
        }
    }

    public static String getServiceId(ApplicationMetadata appMetadata, String objectName, String operationId) throws AppRegistryException {
        Operationmapping operation = appMetadata.getOperatonMapingByObjectId(objectName).get(operationId);
        if (operation == null || StringUtils.isBlank((String)operation.getServiceid())) {
            LOGGER.error((Object)"Service is not configured for the operation");
            String errorMessage = AppRegistryException.getErrorMessageForKey((String)"service_not_configured_operation");
            String errorCode = "14042";
            throw new AppRegistryException(errorCode, errorMessage);
        }
        return operation.getServiceid();
    }

    public static UploadCacheService getUploadCacheService(HttpServletRequest requestWrapper) {
        return new DatabaseUploadCacheImpl(TenantUtilities.getTenantBeanFromRequest((ServletRequest)requestWrapper).getSchemaName());
    }

    public static String getCharacterEncoding(HttpServletRequest request) {
        return StringUtils.isNotBlank((String)request.getCharacterEncoding()) ? request.getCharacterEncoding() : "utf-8";
    }

    public static Map<String, String> convertQueryJsonToMap(JsonObject queryParamJson) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        Set entrySet = queryParamJson.entrySet();
        for (Map.Entry entry : entrySet) {
            queryParams.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
        }
        return queryParams;
    }

    public static void processFinalResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        LOGGER.debug((Object)"Updating the post processor response to middleware.");
        FabricResponseManager responseManager = (FabricResponseManager)RequestUtils.getAttribute((HttpServletRequest)httpServletRequest, (String)"RESPONSE_MANAGER");
        StreamWriter streamWriter = (StreamWriter)responseManager.getPayloadHandler();
        if (httpServletResponse instanceof HttpIntegrityResponseWrapper) {
            LOGGER.debug((Object)"Using PrintWriter to write response since integrity is enabled.");
            streamWriter.write(httpServletResponse.getWriter());
        } else {
            LOGGER.debug((Object)"Using ServletOutputStream to write response.");
            streamWriter.write((OutputStream)httpServletResponse.getOutputStream());
        }
    }

    public static void addResponseToPayloadHandlerIfExists(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object response) throws IOException {
        FabricResponseManager responseManager = (FabricResponseManager)RequestUtils.getAttribute((HttpServletRequest)httpServletRequest, (String)"RESPONSE_MANAGER");
        if (responseManager != null) {
            LOGGER.debug((Object)"Adding middleware response to the ResponsePayloadHandler.");
            StreamWriter streamWriter = (StreamWriter)responseManager.getPayloadHandler();
            streamWriter.setMiddlewareResponse(new ResponseData(response, httpServletResponse.getCharacterEncoding()));
        } else {
            LOGGER.debug((Object)"Writing the response using print writer from http servlet response.");
            httpServletResponse.getWriter().print(response);
        }
    }
}

