/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.common.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.kony.mapper.model.NodePrimitive;
import com.konylabs.middleware.common.ActionType;
import com.konylabs.middleware.objservices.runtime.metadata.DeltaContextFieldObject;
import com.konylabs.middleware.objservices.runtime.metadata.SoftDeleteFieldObject;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.request.builder.RowList;
import com.konylabs.middleware.request.builder.RowMetadata;
import com.konylabs.middleware.request.builder.RowPrimitive;
import com.konylabs.middleware.request.builder.SummaryBean;
import com.konylabs.middleware.utilities.DigestUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OfflineUtil {
    private static final Logger logger = Logger.getLogger(OfflineUtil.class);

    public static void addKeyValueToChecksumString(Row row, String key, NodePrimitive rowPrimitive) {
        RowMetadata metadata = row.getMetadata();
        if (metadata.getCheckSumAsStringBuffer() != null) {
            metadata.getCheckSumAsStringBuffer().append(",").append(key).append("=").append(rowPrimitive.getValue());
        } else {
            metadata.setCheckSum(key + "=" + rowPrimitive.getValue());
        }
    }

    public static String getUTCDateFromDate(Object date) {
        if (date instanceof Date) {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(ZoneOffset.UTC));
            calendar.setTime((Date)date);
            return DatatypeConverter.printDateTime((Calendar)calendar);
        }
        return date.toString();
    }

    public static void addSummaryToResponseRow(Row result, SummaryBean summaryBean) {
        if (summaryBean.getTotalCount() > 0L) {
            result.setValue("recordCount", summaryBean.getTotalCount());
        }
        if (summaryBean.getPutCount() > 0L) {
            result.setValue("updatedRecords", summaryBean.getPutCount());
        }
        if (summaryBean.getDeleteCount() > 0L) {
            result.setValue("deletedRecords", summaryBean.getDeleteCount());
        }
        if (summaryBean.getMaxDeltaContextValue() != null) {
            result.setValue("processed_delta_context", summaryBean.getMaxDeltaContextValue());
        }
    }

    public static String getDateFormatFromMilliseconds(long dateinMilliseconds, String dateformat, boolean isLongType) {
        if (isLongType) {
            return Long.toString(dateinMilliseconds);
        }
        if (StringUtils.isBlank((String)dateformat)) {
            Date date = new Date(dateinMilliseconds);
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(ZoneOffset.UTC));
            calendar.setTime(date);
            return DatatypeConverter.printDateTime((Calendar)calendar);
        }
        try {
            Date date = new Date(dateinMilliseconds);
            SimpleDateFormat simpledateFormat = new SimpleDateFormat(dateformat);
            return simpledateFormat.format(date);
        }
        catch (Exception e) {
            logger.debug((Object)("Error with invalid date format : " + dateformat));
            return "";
        }
    }

    public static long getTimeInMilliseconds(Object deltaObj, String dateFormat) {
        try {
            if (deltaObj instanceof Date) {
                return ((Date)deltaObj).getTime();
            }
            if (deltaObj instanceof Long || deltaObj instanceof Integer) {
                return (Long)deltaObj;
            }
            if (StringUtils.isBlank((String)dateFormat)) {
                Calendar cal = DatatypeConverter.parseDateTime((String)deltaObj.toString());
                return cal.getTime().getTime();
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
            return simpleDateFormat.parse(deltaObj.toString()).getTime();
        }
        catch (ParseException e) {
            logger.error((Object)"Error while getting milliseconds from deltacontextparam", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)"Error while getting milliseconds from deltacontextparam", (Throwable)e);
        }
        return new Date(0L).getTime();
    }

    public static void calculateMaxDeltaValue(Row record, Object rowList, SummaryBean summaryBean) {
        RowPrimitive deltaContextField;
        DeltaContextFieldObject deltaCntxtMetaObj = record.getMetadata().getObjectMetadata().getDeltaContextfieldObj();
        long maxDeltaContextSummary = 0L;
        if (deltaCntxtMetaObj != null && (deltaContextField = (RowPrimitive)record.getValue(deltaCntxtMetaObj.getDeltaContextFieldName())) != null) {
            long currentRecordDeltaContextValue = OfflineUtil.getDeltaContextValueAsLong(deltaContextField);
            if (rowList instanceof RowList) {
                if (currentRecordDeltaContextValue > ((RowList)rowList).getMetadata().getObjectMaxDeltaValue()) {
                    ((RowList)rowList).getMetadata().setObjectMaxDeltaValue(currentRecordDeltaContextValue);
                }
                maxDeltaContextSummary = ((RowList)rowList).getMetadata().getObjectMaxDeltaValue();
            } else {
                maxDeltaContextSummary = currentRecordDeltaContextValue;
            }
            summaryBean.setMaxDeltaContextValue(maxDeltaContextSummary);
        }
    }

    private static Long getDeltaContextValueAsLong(RowPrimitive deltaContextField) {
        Long deltactxtInLong = 0L;
        if (deltaContextField.getValue() != null) {
            deltactxtInLong = deltaContextField.getMetadata().getDatatype().equalsIgnoreCase("date") || !deltaContextField.getMetadata().getTimeStampFieldFormat().isEmpty() ? Long.valueOf(OfflineUtil.getTimeInMilliseconds(deltaContextField.getValue(), deltaContextField.getMetadata().getTimeStampFieldFormat())) : Long.valueOf(Long.parseLong(deltaContextField.getValue().toString()));
        }
        return deltactxtInLong;
    }

    public static void addActionAndCheckSumToRecord(Row node) {
        JsonObject rowMetaData = new JsonObject();
        rowMetaData.addProperty("checksum", DigestUtil.digest(node.getMetadata().getCheckSum()));
        node.getMetadata().setCheckSum(null);
        OfflineUtil.addActionToRow(node, node.getMetadata());
        rowMetaData.addProperty("action", node.getMetadata().getAction());
        node.setValue("_metadata", (JsonElement)rowMetaData);
    }

    private static void addActionToRow(Row row, RowMetadata rowMetaData) {
        RowPrimitive softDeleteParam;
        SoftDeleteFieldObject softDelObj = row.getMetadata().getObjectMetadata().getSoftDeleteFieldObj();
        if (softDelObj != null && row.getValue(softDelObj.getSoftDeleteFieldName()) != null && (softDeleteParam = (RowPrimitive)row.getValue(softDelObj.getSoftDeleteFieldName())) != null && OfflineUtil.checkIfRecordIsDeleted(softDeleteParam, softDelObj)) {
            rowMetaData.setAction(ActionType.delete.name());
            return;
        }
        if (rowMetaData.getNumberOfColumnsInResponse() < rowMetaData.getObjectMetadata().getFieldMetadataMap().size()) {
            rowMetaData.setAction(ActionType.partialupdate.name());
        } else {
            rowMetaData.setAction(ActionType.update.name());
        }
    }

    private static boolean checkIfRecordIsDeleted(RowPrimitive softDeleteParam, SoftDeleteFieldObject softDelObj) {
        if (softDelObj.getDeletedValue() != null) {
            return softDeleteParam.getValue().equals(softDelObj.getDeletedValue());
        }
        return !softDeleteParam.getValue().equals(softDelObj.getActiveValue());
    }

    public static void addTypedValueToJson(String key, Object val, String datatype, JsonObject inputJson) {
        if (val != null) {
            switch (datatype) {
                case "date": {
                    inputJson.addProperty(key, OfflineUtil.getUTCDateFromDate(val));
                    break;
                }
                case "number": {
                    inputJson.addProperty(key, (Number)new BigDecimal(val.toString()));
                    break;
                }
                case "boolean": {
                    inputJson.addProperty(key, Boolean.valueOf(Boolean.parseBoolean(val.toString())));
                    break;
                }
                case "int": {
                    inputJson.addProperty(key, (Number)Integer.valueOf(val.toString()));
                    break;
                }
                case "double": {
                    inputJson.addProperty(key, (Number)Double.valueOf(val.toString()));
                    break;
                }
                default: {
                    inputJson.addProperty(key, val.toString());
                    break;
                }
            }
        } else {
            inputJson.add(key, (JsonElement)JsonNull.INSTANCE);
        }
    }

    public static void incrementPutOrDeleteAndTotalCount(String action, SummaryBean summaryBean) {
        summaryBean.incrementTotalCount();
        if (action != null && ActionType.delete.name().equalsIgnoreCase(action)) {
            summaryBean.incrementDeleteCount();
        } else {
            summaryBean.incrementPutCount();
        }
    }
}

