/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.common.util;

import com.google.gson.JsonObject;
import com.konylabs.middleware.appservices.common.constants.OperationEnum;
import com.konylabs.middleware.appservices.common.util.AbstractOnlineResponseFormatter;
import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.appservices.common.util.PrimaryKeyResponseFormatter;
import com.konylabs.middleware.appservices.common.util.ResponseFormatterPropertiesContainter;
import com.konylabs.middleware.appservices.common.util.SimpleResponseFormatter;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.request.builder.Row;

public class OnlineResponseFormatter {
    public static String prepareJsonResponse(Row result, DataControllerRequest dcRequest) {
        JsonObject outputResponse = null;
        ResponseFormatterPropertiesContainter propertyContainer = OnlineResponseFormatter.preparePropertyContainer(result, dcRequest);
        boolean isTransformationRequired = Boolean.valueOf(dcRequest.getHeader("X-Fabric-Ignore-Mapper-Response-Filtering"));
        AbstractOnlineResponseFormatter formatter = isTransformationRequired ? new SimpleResponseFormatter() : new PrimaryKeyResponseFormatter(propertyContainer.getAppMetaData(), propertyContainer.getDcRequest());
        outputResponse = OnlineResponseFormatter.processResponse(formatter, propertyContainer);
        return outputResponse.toString();
    }

    private static ResponseFormatterPropertiesContainter preparePropertyContainer(Row result, DataControllerRequest dcRequest) {
        JsonObject middlewareResponse = result.getJsonElement().getAsJsonObject();
        String operationId = dcRequest.getParameter("operationId").toString();
        String objectId = dcRequest.getParameter("objectID").toString();
        ApplicationMetadata appMetaData = ObjectServiceUtil.getApplicationMetadataFromDataControllerRequest(dcRequest);
        ObjectMetadata objectMetaData = appMetaData.getObjectMetadata(objectId);
        return new ResponseFormatterPropertiesContainter().withDefaultProperties(dcRequest, appMetaData, objectMetaData, middlewareResponse, operationId);
    }

    private static JsonObject processResponse(AbstractOnlineResponseFormatter formatter, ResponseFormatterPropertiesContainter propertyContainer) {
        JsonObject middlewareResponse = propertyContainer.getMiddlewareResponse();
        String operationId = propertyContainer.getOperationId();
        DataControllerRequest dcRequest = propertyContainer.getDcRequest();
        String objectId = dcRequest.getParameter("objectID").toString();
        ApplicationMetadata appMetaData = propertyContainer.getAppMetaData();
        ObjectMetadata objectMetaData = appMetaData.getObjectMetadata(objectId);
        boolean isStatus204 = formatter.isStatus204(middlewareResponse);
        JsonObject outputResponse = !isStatus204 && middlewareResponse.has("errmsg") ? middlewareResponse : (OperationEnum.create.name().equals(operationId) ? formatter.prepareCreateResponse(middlewareResponse, objectMetaData) : (OperationEnum.get.name().equals(operationId) ? formatter.prepareGetResponse(middlewareResponse, objectMetaData) : (OperationEnum.update.name().equals(operationId) ? formatter.prepareUpdateResponse(middlewareResponse, objectMetaData) : (OperationEnum.partialupdate.name().equals(operationId) ? formatter.preparePartialUpdateResponse(middlewareResponse, objectMetaData) : (OperationEnum.delete.name().equals(operationId) ? formatter.prepareDeleteResponse(middlewareResponse, objectMetaData, dcRequest) : middlewareResponse)))));
        return outputResponse;
    }
}

