/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.common.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.konylabs.middleware.appservices.common.util.AbstractOnlineResponseFormatter;
import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.appservices.common.util.ResponseFormatterUtil;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import java.util.List;

public class PrimaryKeyResponseFormatter
extends AbstractOnlineResponseFormatter {
    private ApplicationMetadata appMetaData;
    private DataControllerRequest dcRequest;

    public PrimaryKeyResponseFormatter(ApplicationMetadata appMetaDataObject, DataControllerRequest dcRequestObject) {
        this.appMetaData = appMetaDataObject;
        this.dcRequest = dcRequestObject;
    }

    @Override
    JsonObject prepareCreateResponse(JsonObject middlewareResponse, ObjectMetadata objectMetaData) {
        JsonObject jsonRecord = this.extractMiddlewareResponse(middlewareResponse, objectMetaData);
        JsonObject outputResponse = ResponseFormatterUtil.insertPk(jsonRecord, objectMetaData, this.appMetaData);
        ObjectServiceUtil.addMiddlewareAttributes(middlewareResponse, outputResponse);
        return outputResponse;
    }

    @Override
    JsonObject prepareUpdateResponse(JsonObject middlewareResponse, ObjectMetadata objectMetaData) {
        JsonObject outputResponse = new JsonObject();
        List<String> primaryKeys = objectMetaData.getPrimaryKeys();
        if (!middlewareResponse.has("errmsg")) {
            outputResponse.addProperty("totalRecords", (Number)1);
            if (middlewareResponse.has("updatedRecords")) {
                outputResponse.addProperty("updatedRecords", (Number)middlewareResponse.get("updatedRecords").getAsInt());
            }
            this.addPrimaryKeyToResponse(this.dcRequest, middlewareResponse, outputResponse, primaryKeys, objectMetaData.getName());
            ObjectServiceUtil.addMiddlewareAttributes(middlewareResponse, outputResponse);
        } else {
            outputResponse = middlewareResponse;
        }
        return outputResponse;
    }

    @Override
    JsonObject preparePartialUpdateResponse(JsonObject middlewareResponse, ObjectMetadata objectMetaData) {
        JsonObject outputResponse = new JsonObject();
        boolean isEmptyResponse = this.isStatus204(middlewareResponse);
        if (!isEmptyResponse) {
            outputResponse.addProperty("totalRecords", (Number)1);
            if (middlewareResponse.has("updatedRecords")) {
                outputResponse.addProperty("updatedRecords", (Number)middlewareResponse.get("updatedRecords").getAsInt());
            }
            List<String> primaryKeys = objectMetaData.getPrimaryKeys();
            this.addPrimaryKeyToResponse(this.dcRequest, middlewareResponse, outputResponse, primaryKeys, objectMetaData.getName());
            ObjectServiceUtil.addMiddlewareAttributes(middlewareResponse, outputResponse);
        } else {
            outputResponse = middlewareResponse;
        }
        return outputResponse;
    }

    @Override
    JsonObject prepareDeleteResponse(JsonObject middlewareResponse, ObjectMetadata objectMetaData, DataControllerRequest dcRequest) {
        JsonObject outputResponse = new JsonObject();
        boolean isEmptyResponse = this.isStatus204(middlewareResponse);
        List<String> primaryKeys = objectMetaData.getPrimaryKeys();
        if (!isEmptyResponse) {
            outputResponse.addProperty("totalRecords", (Number)1);
            if (middlewareResponse.has("deletedRecords")) {
                outputResponse.addProperty("deletedRecords", (Number)middlewareResponse.get("deletedRecords").getAsInt());
            }
            for (String primaryKey : primaryKeys) {
                String value = dcRequest.getParameter(primaryKey);
                outputResponse.addProperty(primaryKey, value);
            }
            ObjectServiceUtil.addMiddlewareAttributes(middlewareResponse, outputResponse);
        } else {
            outputResponse = middlewareResponse;
        }
        return outputResponse;
    }

    private void addPrimaryKeyToResponse(DataControllerRequest dcRequest, JsonObject middlewareResponse, JsonObject outputResponse, List<String> primaryKeys, String objectName) {
        if (!primaryKeys.isEmpty()) {
            for (String primaryKey : primaryKeys) {
                JsonElement pkValue = this.getPkValueFromResponse(middlewareResponse, primaryKey, objectName);
                if (pkValue != null) {
                    outputResponse.add(primaryKey, pkValue);
                    continue;
                }
                outputResponse.addProperty(primaryKey, dcRequest.getParameter(primaryKey));
            }
        }
    }

    public JsonElement getPkValueFromResponse(JsonObject middlewareResponse, String primaryKey, String objectName) {
        if (middlewareResponse.has(objectName)) {
            JsonObject responseRecord = null;
            if (middlewareResponse.get(objectName).isJsonArray() && middlewareResponse.get(objectName).getAsJsonArray().size() > 0) {
                JsonArray responseRecords = middlewareResponse.get(objectName).getAsJsonArray();
                if (responseRecords.get(0) != null && responseRecords.get(0).isJsonObject()) {
                    responseRecord = responseRecords.get(0).getAsJsonObject();
                }
            } else if (middlewareResponse.get(objectName).isJsonObject()) {
                responseRecord = middlewareResponse.get(objectName).getAsJsonObject();
            }
            if (responseRecord != null && responseRecord.has(primaryKey)) {
                return responseRecord.get(primaryKey);
            }
        }
        return null;
    }
}

