/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.common.util;

import com.google.gson.JsonObject;
import com.konylabs.middleware.appservices.common.util.AbstractOnlineResponseFormatter;
import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import java.util.List;

public class SimpleResponseFormatter
extends AbstractOnlineResponseFormatter {
    @Override
    JsonObject prepareCreateResponse(JsonObject middlewareResponse, ObjectMetadata objectMetaData) {
        return this.prepareResponse(middlewareResponse, objectMetaData);
    }

    @Override
    JsonObject prepareUpdateResponse(JsonObject middlewareResponse, ObjectMetadata objectMetaData) {
        boolean isNotValidResponse = this.isStatus204(middlewareResponse);
        return this.processUpdateResponse(middlewareResponse, objectMetaData, isNotValidResponse);
    }

    @Override
    JsonObject preparePartialUpdateResponse(JsonObject middlewareResponse, ObjectMetadata objectMetaData) {
        boolean isNotValidResponse = middlewareResponse.has("errmsg");
        return this.processUpdateResponse(middlewareResponse, objectMetaData, isNotValidResponse);
    }

    @Override
    JsonObject prepareDeleteResponse(JsonObject middlewareResponse, ObjectMetadata objectMetaData, DataControllerRequest dcRequest) {
        boolean isNotValidResponse = middlewareResponse.has("errmsg");
        return this.processDeleteResponse(dcRequest, middlewareResponse, objectMetaData, isNotValidResponse);
    }

    private JsonObject processDeleteResponse(DataControllerRequest dcRequest, JsonObject middlewareResponse, ObjectMetadata objectMetaData, boolean isEmptyResponse) {
        JsonObject outputResponse = new JsonObject();
        List<String> primaryKeys = objectMetaData.getPrimaryKeys();
        if (!isEmptyResponse) {
            outputResponse = this.prepareResponse(middlewareResponse, objectMetaData);
            outputResponse.addProperty("totalRecords", (Number)1);
            if (middlewareResponse.has("deletedRecords")) {
                outputResponse.addProperty("deletedRecords", (Number)middlewareResponse.get("deletedRecords").getAsInt());
            }
            for (String primaryKey : primaryKeys) {
                String value = dcRequest.getParameter(primaryKey);
                outputResponse.addProperty(primaryKey, value);
            }
            ObjectServiceUtil.addMiddlewareAttributes(middlewareResponse, outputResponse);
        } else {
            outputResponse = middlewareResponse;
        }
        return outputResponse;
    }

    private JsonObject processUpdateResponse(JsonObject middlewareResponse, ObjectMetadata objectMetaData, boolean isNotValidResponse) {
        JsonObject outputResponse = new JsonObject();
        if (isNotValidResponse) {
            outputResponse = middlewareResponse;
        } else {
            outputResponse = this.prepareResponse(middlewareResponse, objectMetaData);
            outputResponse.addProperty("totalRecords", (Number)1);
            if (middlewareResponse.has("updatedRecords")) {
                outputResponse.addProperty("updatedRecords", (Number)middlewareResponse.get("updatedRecords").getAsInt());
            }
            ObjectServiceUtil.addMiddlewareAttributes(middlewareResponse, outputResponse);
        }
        return outputResponse;
    }

    private JsonObject prepareResponse(JsonObject middlewareResponse, ObjectMetadata objectMetaData) {
        JsonObject jsonRecord = this.extractMiddlewareResponse(middlewareResponse, objectMetaData);
        ObjectServiceUtil.addMiddlewareAttributes(middlewareResponse, jsonRecord);
        return jsonRecord;
    }
}

