/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.custom.processors.filter;

import com.konylabs.middleware.api.processor.FabricRequestChain;
import com.konylabs.middleware.api.processor.impl.RequestPayload;
import com.konylabs.middleware.api.processor.manager.FabricRequestManager;
import com.konylabs.middleware.api.processor.manager.FabricResponseManager;
import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.appservices.custom.processors.util.ObjectServicePostProcessorUtil;
import com.konylabs.middleware.appservices.custom.processors.util.ObjectServicePreProcessorUtil;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.request.builder.RequestContext;
import com.konylabs.middleware.request.builder.UriContext;
import com.konylabs.middleware.servlet.filters.IntegrationCustomFilter;
import com.konylabs.middleware.utilities.RequestUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

@IntegrationCustomFilter(filterOrder=40, servletNames={"AppServices"}, defaultFilter=true)
public class CustomProcessorsFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(CustomProcessorsFilter.class);

    public void destroy() {
    }

    public void init(FilterConfig fConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        RequestPayload requestPayload = new RequestPayload();
        FabricRequestManager fabricRequestManager = ObjectServicePreProcessorUtil.prepareFabricRequestManager(httpServletRequest, requestPayload);
        FabricResponseManager fabricResponseManager = ObjectServicePostProcessorUtil.prepareFabricResponseManager();
        RequestUtils.setAttribute((HttpServletRequest)httpServletRequest, (String)"REQUEST_PAYLOAD", (Object)requestPayload);
        RequestUtils.setAttribute((HttpServletRequest)httpServletRequest, (String)"REQUEST_MANAGER", (Object)fabricRequestManager);
        RequestUtils.setAttribute((HttpServletRequest)httpServletRequest, (String)"RESPONSE_MANAGER", (Object)fabricResponseManager);
        RequestContext requestContext = (RequestContext)RequestUtils.getAttribute((HttpServletRequest)httpServletRequest, (String)"requestcontext");
        UriContext uriContext = (UriContext)RequestUtils.getAttribute((HttpServletRequest)httpServletRequest, (String)"uricontext");
        try {
            FabricRequestChain requestChain = ObjectServicePreProcessorUtil.createFabricRequestChain(httpServletRequest, httpServletResponse, chain, fabricRequestManager, fabricResponseManager);
            if (ObjectServicePreProcessorUtil.hasRequestProcessorConfigured(uriContext, requestContext)) {
                LOGGER.debug((Object)"About to execute request processor.");
                ObjectServicePreProcessorUtil.executeRequestProcessor(fabricRequestManager, fabricResponseManager, requestContext, uriContext, requestChain);
            } else {
                LOGGER.debug((Object)"Preprocessor not configured.");
                requestChain.execute();
            }
            ObjectServiceUtil.processFinalResult(httpServletRequest, httpServletResponse);
        }
        catch (MiddlewareException e) {
            LOGGER.error((Object)"Exception while processing request", (Throwable)e);
            String errorMsg = ObjectServiceUtil.getErrorMsgByMiddlewareException(e);
            ObjectServiceUtil.sendResponse(errorMsg, httpServletResponse);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unknown exception while processing request", (Throwable)e);
            httpServletResponse.setStatus(500);
        }
    }
}

