/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.custom.processors.util;

import com.kony.mobilefabric.cache.director.CacheDirector;
import com.konylabs.middleware.api.OperationData;
import com.konylabs.middleware.api.OperationDataBuilderImpl;
import com.konylabs.middleware.api.ServicesManager;
import com.konylabs.middleware.api.processor.FabricRequestChain;
import com.konylabs.middleware.api.processor.HeadersHandler;
import com.konylabs.middleware.api.processor.PayloadHandler;
import com.konylabs.middleware.api.processor.QueryParamsHandler;
import com.konylabs.middleware.api.processor.SessionHandler;
import com.konylabs.middleware.api.processor.impl.FabricRequestChainImpl;
import com.konylabs.middleware.api.processor.impl.Headers;
import com.konylabs.middleware.api.processor.impl.HeadersHandlerImpl;
import com.konylabs.middleware.api.processor.impl.ProcessorInfo;
import com.konylabs.middleware.api.processor.impl.QueryParamsHandlerImpl;
import com.konylabs.middleware.api.processor.impl.RequestPayload;
import com.konylabs.middleware.api.processor.impl.RequestPayloadHandlerImpl;
import com.konylabs.middleware.api.processor.impl.SessionHandlerImpl;
import com.konylabs.middleware.api.processor.manager.FabricRequestManager;
import com.konylabs.middleware.api.processor.manager.FabricResponseManager;
import com.konylabs.middleware.api.processor.manager.impl.FabricRequestManagerImpl;
import com.konylabs.middleware.appservices.custom.processors.exception.FabricCustomCodeException;
import com.konylabs.middleware.appservices.custom.processors.util.ObjectServicePostProcessorUtil;
import com.konylabs.middleware.cache.CacheUtils;
import com.konylabs.middleware.classloader.ClassLoaderUtils;
import com.konylabs.middleware.common.objectservice.ObjectServicePostProcessor;
import com.konylabs.middleware.common.objectservice.ObjectServicePreProcessor;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.metrics.MetricsBean;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.request.builder.RequestContext;
import com.konylabs.middleware.request.builder.UriContext;
import com.konylabs.middleware.utilities.MiddlewarePayloadParsingUtil;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import com.konylabs.middleware.utilities.RequestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class ObjectServicePreProcessorUtil {
    private static final Logger LOGGER = Logger.getLogger(ObjectServicePreProcessorUtil.class);

    public static OperationData prepareOperationData(RequestContext requestContext) {
        LOGGER.debug((Object)"Inside prepareOperationData()");
        OperationDataBuilderImpl builder = new OperationDataBuilderImpl(requestContext.getAppCache());
        return builder.withServiceId(requestContext.getAppId()).withVersion(requestContext.getApiVersion()).withObjectId(requestContext.getObjectId()).withOperationId(requestContext.getDefaultOperation()).buildQuietly();
    }

    public static FabricRequestManager prepareFabricRequestManager(HttpServletRequest httpServletRequest, RequestPayload requestPayload) {
        LOGGER.debug((Object)"Inside prepareFabricRequestWrapper()");
        HeadersHandler headersHandler = ObjectServicePreProcessorUtil.createRequestHeadersHandler(httpServletRequest);
        SessionHandlerImpl sessionHandler = new SessionHandlerImpl(httpServletRequest.getSession());
        QueryParamsHandler queryParamsHandler = ObjectServicePreProcessorUtil.createQueryParamsHandler(httpServletRequest);
        RequestPayloadHandlerImpl payloadHandler = new RequestPayloadHandlerImpl(httpServletRequest, requestPayload);
        RequestContext requestContext = (RequestContext)RequestUtils.getAttribute((HttpServletRequest)httpServletRequest, (String)"requestcontext");
        OperationData currentOperationData = ObjectServicePreProcessorUtil.prepareOperationData(requestContext);
        MetricsBean metricsBean = (MetricsBean)httpServletRequest.getAttribute("metricsBean");
        CacheDirector cacheDirector = CacheUtils.getCacheDirector(httpServletRequest);
        ServicesManager servicesManager = MiddlewareUtils.createServicesManager(requestContext.getTenantBean(), currentOperationData, metricsBean, cacheDirector);
        return new FabricRequestManagerImpl(servicesManager, (PayloadHandler)payloadHandler, headersHandler, (SessionHandler)sessionHandler, queryParamsHandler);
    }

    public static boolean hasRequestProcessorConfigured(UriContext uriContext, RequestContext requestContext) {
        ProcessorInfo processorInfo = uriContext.getCustomProcesorInfo(requestContext);
        return processorInfo != null && StringUtils.isNotBlank((String)processorInfo.getRequestProcessorName());
    }

    public static void executeRequestProcessor(FabricRequestManager fabricRequestManager, FabricResponseManager fabricResponseManager, RequestContext requestContext, UriContext uriContext, FabricRequestChain requestChain) throws Exception {
        ProcessorInfo processorInfo = uriContext.getCustomProcesorInfo(requestContext);
        String serviceId = requestContext.getAppId();
        String requestProcessorName = processorInfo.getRequestProcessorName();
        LOGGER.debug((Object)String.format("Inside executeRequestProcessor() with request processor name [%s] under [%s] jar module for the service [%s]", requestProcessorName, processorInfo.getJarModule(), serviceId));
        try {
            ObjectServicePreProcessor requestProcessorInstance = (ObjectServicePreProcessor)ClassLoaderUtils.getCustomClassInstance(serviceId, processorInfo.getJarModule(), requestProcessorName);
            requestProcessorInstance.execute(fabricRequestManager, fabricResponseManager, requestChain);
        }
        catch (Throwable e) {
            LOGGER.error((Object)String.format("Exception while executing request processor [%s]", requestProcessorName), e);
            String errMsg = FabricCustomCodeException.getErrorMessage("16000", requestProcessorName);
            throw new FabricCustomCodeException("16000", errMsg);
        }
    }

    public static InputStream getInputStreamFromCustomProcessor(HttpServletRequest request, RequestContext requestContext) throws IOException {
        Object inputStream = null;
        UriContext uriContext = (UriContext)RequestUtils.getAttribute((HttpServletRequest)request, (String)"uricontext");
        if (ObjectServicePreProcessorUtil.hasRequestProcessorConfigured(uriContext, requestContext)) {
            LOGGER.debug((Object)"Request processor configured. So trying to get the stream from custom code.");
            RequestPayload requestPayload = (RequestPayload)RequestUtils.getAttribute((HttpServletRequest)request, (String)"REQUEST_PAYLOAD");
            if (requestPayload.getInputPayload() != null) {
                LOGGER.debug((Object)"Found modified stream from request processor.");
                inputStream = (InputStream)requestPayload.getInputPayload().getTypedPayload("jsondata");
            } else {
                LOGGER.debug((Object)"No modification done to the stream in request processor. So returning the stream from request.");
                inputStream = request.getInputStream();
            }
        } else {
            LOGGER.debug((Object)"Request processor not configured. So returning the input stream from request.");
            inputStream = request.getInputStream();
        }
        return inputStream;
    }

    public static FabricRequestChain createFabricRequestChain(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain, FabricRequestManager fabricRequestManager, FabricResponseManager fabricResponseManager) throws ConnectorException {
        LOGGER.debug((Object)"Creating Request Chain.");
        RequestContext requestContext = (RequestContext)RequestUtils.getAttribute((HttpServletRequest)httpServletRequest, (String)"requestcontext");
        UriContext uriContext = (UriContext)RequestUtils.getAttribute((HttpServletRequest)httpServletRequest, (String)"uricontext");
        ObjectServicePostProcessor postProcessorInstance = null;
        if (ObjectServicePostProcessorUtil.hasResponseProcessorConfigured(uriContext, requestContext)) {
            String serviceId = requestContext.getServiceId();
            ProcessorInfo processorInfo = uriContext.getCustomProcesorInfo(requestContext);
            LOGGER.debug((Object)String.format("Injecting post processor instance of [%s] into request chain", processorInfo.getResponseProcessorName()));
            postProcessorInstance = (ObjectServicePostProcessor)ClassLoaderUtils.getCustomClassInstance(serviceId, processorInfo.getJarModule(), processorInfo.getResponseProcessorName());
        }
        return new FabricRequestChainImpl(httpServletRequest, httpServletResponse, filterChain, fabricRequestManager, fabricResponseManager, postProcessorInstance);
    }

    public static void updateOperationFromCustomCode(HttpServletRequest request) throws AppRegistryException {
        LOGGER.debug((Object)"Updating the operation from custom code.");
        FabricRequestManager requestManager = (FabricRequestManager)RequestUtils.getAttribute((HttpServletRequest)request, (String)"REQUEST_MANAGER");
        RequestContext requestContext = (RequestContext)RequestUtils.getAttribute((HttpServletRequest)request, (String)"requestcontext");
        if (requestManager != null) {
            requestContext.setDefaultOperation(requestManager.getServicesManager().getOperationData().getOperationId());
        }
    }

    public static HeadersHandler createRequestHeadersHandler(HttpServletRequest request) {
        LOGGER.debug((Object)"Creating headers handler with all the headers in the request.");
        HeadersHandlerImpl headersHandler = new HeadersHandlerImpl(new Headers());
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                String headerValue = request.getHeader(headerName);
                headersHandler.addHeader(headerName, headerValue);
            }
        }
        return headersHandler;
    }

    public static QueryParamsHandler createQueryParamsHandler(HttpServletRequest request) {
        LOGGER.debug((Object)"Creating query params handler.");
        Map queryParams = MiddlewarePayloadParsingUtil.parseQueryParams((String)request.getQueryString());
        return new QueryParamsHandlerImpl(queryParams);
    }

    private ObjectServicePreProcessorUtil() {
    }
}

