/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.servlet;

import com.konylabs.middleware.appservices.servlet.CachedObjectRequestExecutor;
import com.konylabs.middleware.appservices.servlet.ObjectRequestExecutor;
import com.konylabs.middleware.controller.DataController;
import com.konylabs.middleware.exceptions.ControllerInitializationException;
import com.konylabs.middleware.servlet.AbstractServlet;
import com.konylabs.middleware.utilities.ConfigPathUtil;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.MaskUtils;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AppServicesServlet
extends AbstractServlet {
    private static final long serialVersionUID = 1L;
    private static DataController dataController;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (dataController == null) {
            dataController = DataController.InstanceManager.getInstance();
            try {
                String fileName = ConfigUtility.getProperty((String)"controller.deffile");
                fileName = ConfigPathUtil.getMiddlewareHome() + "/middleware/middleware-bootconfig/" + fileName;
                dataController.init(fileName);
            }
            catch (ControllerInitializationException cie) {
                MaskUtils.maskTrace((String)("\n IN MWServlet - Controller Initialization Exception. Error code: " + cie.getErrorCode() + "\n"), (Throwable)cie);
                throw new ServletException();
            }
        }
    }

    public static DataController getDataController() {
        return dataController;
    }

    public static void setDataController(DataController dataController) {
        AppServicesServlet.dataController = dataController;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.executeRequest(request, response);
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.executeRequest(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ObjectRequestExecutor.getInstance().executeRequest(request, response);
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.executeRequest(request, response);
    }

    private void executeRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        ObjectRequestExecutor reqExecutor = null != request.getAttribute("isCachedObjectRequestExecutor") ? CachedObjectRequestExecutor.getInstance() : ObjectRequestExecutor.getInstance();
        reqExecutor.executeRequest(request, response);
    }
}

