/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.servlet;

import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.appservices.servlet.ObjectRequestExecAsyncHandler;
import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.objservices.runtime.request.cache.UploadCacheService;
import com.konylabs.middleware.request.builder.ObjectServiceResponseData;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CachedObjectRequestExecAsyncHandler
extends ObjectRequestExecAsyncHandler {
    private static final Logger LOGGER = Logger.getLogger(CachedObjectRequestExecAsyncHandler.class);

    @Override
    public void onSuccess(HttpServletRequest request, HttpServletResponse response, ObjectServiceResponseData objectServiceResponseData, Context context) {
        try {
            this.saveResponseToCache(context.get("uploadCacheHash").toString(), objectServiceResponseData.getResposne(), request, false, context.get("uc_firstRequestHitTime"));
        }
        catch (MiddlewareException ex) {
            LOGGER.error((Object)"Exception while saving response to cache ", (Throwable)ex);
        }
        super.onSuccess(request, response, objectServiceResponseData, context);
    }

    @Override
    public void onError(HttpServletRequest request, HttpServletResponse response, Exception e, Context context) {
        try {
            this.saveResponseToCache(context.get("uploadCacheHash").toString(), e.getMessage(), request, true, context.get("uc_firstRequestHitTime"));
        }
        catch (MiddlewareException me) {
            LOGGER.error((Object)"Exception while saving exception to cache ", (Throwable)me);
        }
        super.onError(request, response, e, context);
    }

    private void saveResponseToCache(String uploadChecksum, Object response, HttpServletRequest request, boolean isException, Object firstHitTime) throws MiddlewareException {
        UploadCacheService uCacheService = ObjectServiceUtil.getUploadCacheService(request);
        uCacheService.updateResponseToCache(uploadChecksum, response, isException, (Long)firstHitTime);
    }
}

