/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.servlet;

import com.google.gson.JsonObject;
import com.konylabs.middleware.appservices.common.dataaccess.exception.DataAccessException;
import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.appservices.servlet.CachedObjectRequestExecAsyncHandler;
import com.konylabs.middleware.appservices.servlet.ObjectRequestExecutor;
import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.connectors.logservice.MetricsUtils;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.exceptions.ObjectServicesException;
import com.konylabs.middleware.objservices.runtime.request.cache.UploadCache;
import com.konylabs.middleware.objservices.runtime.request.cache.UploadCacheService;
import com.konylabs.middleware.request.builder.ObjectServiceRequestData;
import com.konylabs.middleware.request.parser.RequestData;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CachedObjectRequestExecutor
extends ObjectRequestExecutor {
    public static final String UPLOAD_CACHE_HASH = "uploadCacheHash";
    public static final String UC_FIRST_REQUEST_HIT_TIME = "uc_firstRequestHitTime";
    private static final String UPLOAD_RESPONSE_WAIT_TIME = "upload.responseWaitTime";
    private static final String UPLOAD_REQUEST_RESUBMIT_TIME = "upload.requestResubmitTime";
    private static final Logger LOGGER = Logger.getLogger(CachedObjectRequestExecutor.class);
    private static final CachedObjectRequestExecutor cachedrequestExecutor = new CachedObjectRequestExecutor();
    private static final CachedObjectRequestExecAsyncHandler CACHED_OBJECT_REQUEST_ASYNC_HANDLER = new CachedObjectRequestExecAsyncHandler();
    private Object firstHitTimeCtxt;

    private CachedObjectRequestExecutor() {
    }

    public static CachedObjectRequestExecutor getInstance() {
        return cachedrequestExecutor;
    }

    public Object getFirstHitTimeCtxt() {
        return this.firstHitTimeCtxt;
    }

    public void setFirstHitTimeCtxt(Object contextObj) {
        this.firstHitTimeCtxt = contextObj;
    }

    @Override
    public void executeRequest(HttpServletRequest requestWrapper, HttpServletResponse resp) throws ServletException {
        try {
            LOGGER.debug((Object)"CachedObjectRequestExecutor: In executeRequest()");
            String uploadChecksum = requestWrapper.getHeader("X-Kony-RequestCacheId");
            this.validateUploadChecksum(uploadChecksum);
            this.getRequestData(requestWrapper).setUploadChecksum(uploadChecksum);
            UploadCacheService uploadCacheService = this.getUploadCacheServiceImpl(requestWrapper);
            UploadCache uploadCacheObj = uploadCacheService.getResponseFromCache(uploadChecksum);
            if (uploadCacheObj == null) {
                LOGGER.debug((Object)"uploadcacheobject is not found in database for the given uploadcache key");
                this.setContextAndInsertToRequestCache(uploadChecksum, uploadCacheService);
                super.executeRequest(requestWrapper, resp);
            } else if (uploadCacheObj.isErrorResponse()) {
                LOGGER.debug((Object)"uploadcacheobject contains error response");
                this.setFirstHitTimeCtxt(uploadCacheObj.getFirstRequestHitTime());
                this.resetCacheOnException(uploadChecksum, uploadCacheService, uploadCacheObj.getFirstRequestHitTime());
                super.executeRequest(requestWrapper, resp);
            } else if (null != uploadCacheObj.getResponse()) {
                LOGGER.debug((Object)"response has been fetched from the database");
                this.setCharacterEncodingOnResponse(requestWrapper, resp);
                MetricsUtils.addResponseInfoToMetricsBean(requestWrapper, System.currentTimeMillis(), new JsonObject().getAsJsonObject(uploadCacheObj.getResponse().toString()), 0, "", "");
                ObjectServiceUtil.addResponseToPayloadHandlerIfExists(requestWrapper, resp, uploadCacheObj.getResponse());
            } else if (this.isMaxWaitTimeExceeded(uploadCacheObj)) {
                this.deleteCacheOnMaxTimeExceeded(uploadChecksum, uploadCacheService, uploadCacheObj.getFirstRequestHitTime());
                this.setContextAndInsertToRequestCache(uploadChecksum, uploadCacheService);
                super.executeRequest(requestWrapper, resp);
            } else {
                LOGGER.debug((Object)"waiting for the ongoing request with same cache id to be finished");
                this.sleepUntilResponseWaitTime();
                this.getResponseAfterSleep(requestWrapper, resp, uploadChecksum, uploadCacheService);
            }
            LOGGER.debug((Object)"Return response from CachedObjectRequestExecutor");
        }
        catch (DataAccessException dae) {
            throw new ServletException((Throwable)dae);
        }
        catch (ObjectServicesException ose) {
            throw new ServletException((Throwable)new DataAccessException(Integer.parseInt(ose.getErrorCode()), ose.getMessage()));
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    private void setContextAndInsertToRequestCache(String uploadChecksum, UploadCacheService uploadCacheService) throws MiddlewareException {
        this.setFirstHitTimeCtxt(System.currentTimeMillis());
        this.insertRequestToCache(uploadChecksum, uploadCacheService);
    }

    @Override
    protected Context getContext(RequestData requestData, ServletException[] exception, CountDownLatch latch) {
        Context ctxt = super.getContext(requestData, exception, latch);
        ctxt.put("handler", (Object)CACHED_OBJECT_REQUEST_ASYNC_HANDLER);
        ctxt.put(UPLOAD_CACHE_HASH, (Object)((ObjectServiceRequestData)requestData).getUploadChecksum());
        ctxt.put(UC_FIRST_REQUEST_HIT_TIME, this.getFirstHitTimeCtxt());
        return ctxt;
    }

    UploadCacheService getUploadCacheServiceImpl(HttpServletRequest requestWrapper) {
        return ObjectServiceUtil.getUploadCacheService(requestWrapper);
    }

    boolean isMaxWaitTimeExceeded(UploadCache uc) {
        return System.currentTimeMillis() - uc.getFirstRequestHitTime() > Long.parseLong(ConfigUtility.getProperty((String)UPLOAD_REQUEST_RESUBMIT_TIME, (String)"1800000"));
    }

    private void insertRequestToCache(String uploadChecksum, UploadCacheService uploadCacheService) throws MiddlewareException {
        uploadCacheService.insertRequestToCache(uploadChecksum, System.currentTimeMillis());
    }

    void validateUploadChecksum(String uploadChecksum) throws ObjectServicesException {
        if (StringUtils.isBlank((CharSequence)uploadChecksum)) {
            String errorMessage = ObjectServicesException.getErrorMessage("500213");
            throw new ObjectServicesException("500213", errorMessage);
        }
    }

    void sleepUntilResponseWaitTime() throws InterruptedException {
        Thread.sleep(Long.parseLong(ConfigUtility.getProperty((String)UPLOAD_RESPONSE_WAIT_TIME, (String)"30000")));
    }

    private void logDeviceResponse(HttpServletRequest requestWrapper, UploadCache uploadCacheObjAfterSleep) {
        MiddlewareUtils.logDeviceResponse((ServletRequest)requestWrapper, uploadCacheObjAfterSleep.getResponse(), true);
    }

    private void deleteCacheOnMaxTimeExceeded(String uploadChecksum, UploadCacheService uploadCacheService, long firstHitTime) throws MiddlewareException {
        uploadCacheService.deleteCacheOnMaxWaitTimeExceeded(uploadChecksum, firstHitTime);
    }

    private void resetCacheOnException(String uploadChecksum, UploadCacheService uploadCacheService, long firstHitTime) throws MiddlewareException {
        uploadCacheService.updateResponseToCache(uploadChecksum, null, false, firstHitTime);
    }

    private void getResponseAfterSleep(HttpServletRequest requestWrapper, HttpServletResponse resp, String uploadChecksum, UploadCacheService uploadCacheService) throws Exception, IOException {
        UploadCache uploadCacheObjAfterSleep = uploadCacheService.getResponseFromCache(uploadChecksum);
        this.setCharacterEncodingOnResponse(requestWrapper, resp);
        JsonObject response = new JsonObject();
        LOGGER.debug((Object)"In CachedObjectRequestExecutor retreiving response after sleep");
        if (uploadCacheObjAfterSleep == null) {
            LOGGER.debug((Object)"no record has been found from db after sleep");
            String errorMessage = ObjectServicesException.getErrorMessage("500209", uploadChecksum);
            throw new DataAccessException(Integer.parseInt("500209"), errorMessage);
        }
        if (uploadCacheObjAfterSleep.isErrorResponse()) {
            LOGGER.debug((Object)"error record has been found from db after sleep");
            throw new DataAccessException(Integer.parseInt("500211"), uploadCacheObjAfterSleep.getResponse().toString());
        }
        if (null != uploadCacheObjAfterSleep.getResponse()) {
            LOGGER.debug((Object)"record found from db after sleep");
            response = (JsonObject)uploadCacheObjAfterSleep.getResponse();
            ObjectServiceUtil.addResponseToPayloadHandlerIfExists(requestWrapper, resp, uploadCacheObjAfterSleep.getResponse());
            this.logDeviceResponse(requestWrapper, uploadCacheObjAfterSleep);
        } else {
            JsonObject respJsonObj = new JsonObject();
            respJsonObj.addProperty("errmsg", ObjectServicesException.getErrorMessage("500210"));
            respJsonObj.addProperty("opstatus", (Number)Long.parseLong("500210"));
            respJsonObj.addProperty("httpStatusCode", (Number)200);
            response = respJsonObj;
            ObjectServiceUtil.addResponseToPayloadHandlerIfExists(requestWrapper, resp, respJsonObj);
            MiddlewareUtils.logDeviceResponse((ServletRequest)requestWrapper, respJsonObj, true);
        }
        MetricsUtils.addResponseInfoToMetricsBean(requestWrapper, System.currentTimeMillis(), response, 0, "", "");
    }

    private void setCharacterEncodingOnResponse(HttpServletRequest requestWrapper, HttpServletResponse resp) {
        String characterEncoding = ObjectServiceUtil.getCharacterEncoding(requestWrapper);
        LOGGER.debug((Object)("Setting the response encoding to :" + characterEncoding));
        resp.setCharacterEncoding(characterEncoding);
    }

    private ObjectServiceRequestData getRequestData(HttpServletRequest requestWrapper) {
        ObjectServiceRequestData requestData = (ObjectServiceRequestData)requestWrapper.getAttribute("requestdata");
        return requestData;
    }
}

