/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.servlet;

import com.konylabs.middleware.classloader.resources.ConfigurationProperties;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.tenant.TenantBean;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class ClientConfigurationServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ClientConfigurationServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug((Object)"In ClientConfigurationServlet GET Method");
        try {
            TenantBean<AppCache> tenantBean = TenantUtilities.getTenantBeanFromRequest((ServletRequest)request);
            LOGGER.debug((Object)"Fetching client configuration...");
            ConfigurationProperties configProperties = tenantBean.getConfigurationProperties();
            Map clientProperties = configProperties.getAllClientAppProperties();
            JSONObject json = new JSONObject(clientProperties);
            String responseBody = json.toString();
            response.setContentType("application/json; charset=UTF-8");
            PrintWriter pw = response.getWriter();
            pw.write(responseBody);
            pw.flush();
            LOGGER.debug((Object)"Exiting ClientConfigurationServlet GET Method");
        }
        catch (IOException e) {
            LOGGER.error((Object)"Unable to process client configuration request", (Throwable)e);
            response.setStatus(500);
        }
    }
}

