/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.servlet;

import com.kony.adapter.commons.security.EncryptDecryptText;
import com.kony.adapter.fileservice.FileEntity;
import com.kony.adapter.fileservice.FileServiceAdapterImpl;
import com.kony.adapter.fileservice.FileServiceDataAdapterException;
import com.kony.adapter.fileservice.utils.FilePathComputationUtils;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterUtil;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.ServerPropertiesUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FileServiceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(FileServiceServlet.class);
    private static final String ROOT_DIRECTORY_KEY = "KONY_SERVER_FILESERVICE_ROOT_DIRECTORY";
    private static final String KONY_SERVER_FILESERVICE_DISABLE = "KONY_SERVER_FILESERVICE_DISABLE";
    private static final String LIST_ALL_FILES_ENDPOINT = "listAllFiles";
    private static final String ACCESS_TOKEN = "ACCESS_TOKEN";
    private FileServiceAdapterImpl adapter;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        EncryptDecryptText.setSecurityKey((String)ServerPropertiesUtils.getInstance().getProperty("server.encryption.key"));
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String filePath;
        if (ConfigUtility.getBoolean((String)KONY_SERVER_FILESERVICE_DISABLE, (boolean)false)) {
            response.sendError(404);
            return;
        }
        LOGGER.debug((Object)"Entering the DELETE method of FileServiceServlet");
        String requestBody = IOUtils.toString((Reader)request.getReader());
        try {
            JSONObject requestJson = new JSONObject(requestBody);
            filePath = this.computeMountedPath() + FilePathComputationUtils.computeFilePathFromSvcAndOpn((String)requestJson.getString("serviceNameSpace"), (String)requestJson.getString("securityKey"));
            String fileNameWithExtension = requestJson.getString("fileNameWithExtension");
            filePath = filePath + fileNameWithExtension;
        }
        catch (JSONException e) {
            LOGGER.error((Object)e, (Throwable)e);
            this.sendResponseBack(response, e.getMessage(), 400);
            return;
        }
        try {
            this.getFileServiceAdapterInstance().deleteBinary(filePath);
            LOGGER.debug((Object)"Exiting the DELETE method of FileServiceServlet");
            this.sendResponseBack(response, "File deleted successfully", 200);
        }
        catch (FileServiceDataAdapterException e) {
            LOGGER.error((Object)e, (Throwable)e);
            this.sendResponseBack(response, e.getErrorMessage(), e.getHttpStatusCode());
        }
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String renameFileNameWithExtension;
        String fileNameWithExtension;
        String securityKey;
        String serviceNameSpace;
        if (ConfigUtility.getBoolean((String)KONY_SERVER_FILESERVICE_DISABLE, (boolean)false)) {
            response.sendError(404);
            return;
        }
        LOGGER.debug((Object)"Entering the PUT method of KonyFileServiceServlet");
        String requestBody = IOUtils.toString((Reader)request.getReader());
        try {
            JSONObject requestJson = new JSONObject(requestBody);
            serviceNameSpace = requestJson.getString("serviceNameSpace");
            securityKey = requestJson.getString("securityKey");
            fileNameWithExtension = requestJson.getString("fileNameWithExtension");
            renameFileNameWithExtension = requestJson.getString("renameFileNameWithExtension");
            if (StringUtils.isBlank((String)fileNameWithExtension) || StringUtils.isBlank((String)renameFileNameWithExtension)) {
                LOGGER.error((Object)"The file name cannot be null");
                this.sendResponseBack(response, "Filename cannot be null or empty", 400);
                LOGGER.debug((Object)"Exiting the FileServiceServlet");
                return;
            }
        }
        catch (JSONException e) {
            LOGGER.error((Object)e, (Throwable)e);
            this.sendResponseBack(response, e.getMessage(), 400);
            return;
        }
        try {
            this.getFileServiceAdapterInstance().rename(this.computeMountedPath() + serviceNameSpace, securityKey, fileNameWithExtension, renameFileNameWithExtension);
            LOGGER.debug((Object)"Exiting the PUT method of FileServiceServlet");
            this.sendResponseBack(response, "File renamed successfully", 200);
        }
        catch (FileServiceDataAdapterException e) {
            LOGGER.error((Object)e, (Throwable)e);
            this.sendResponseBack(response, e.getErrorMessage(), e.getHttpStatusCode());
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (ConfigUtility.getBoolean((String)KONY_SERVER_FILESERVICE_DISABLE, (boolean)false)) {
            response.sendError(404);
            return;
        }
        if (this.isNotAuthorizedRequest(request)) {
            LOGGER.error((Object)"The user doesn't have the permission to access the resource");
            response.sendError(403);
            return;
        }
        LOGGER.debug((Object)"Entering the POST method of FileServiceServlet");
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (!isMultipart) {
            LOGGER.error((Object)"This request doesn't contain Multipart content");
            this.sendResponseBack(response, "There is no multipart content in the request", 400);
            return;
        }
        LOGGER.debug((Object)"This request contains multipart content");
        try {
            ServletFileUpload upload = new ServletFileUpload();
            FileItemIterator iter = upload.getItemIterator(request);
            this.getFileServiceAdapterInstance().uploadBinary(this.computeMountedPath(), iter);
            this.sendResponseBack(response, "File uploaded successfully", 200);
        }
        catch (FileUploadException e) {
            LOGGER.error((Object)e, (Throwable)e);
            this.sendResponseBack(response, e.getMessage(), 500);
        }
        catch (FileServiceDataAdapterException e) {
            LOGGER.error((Object)e, (Throwable)e);
            this.sendResponseBack(response, e.getErrorMessage(), e.getHttpStatusCode());
        }
        LOGGER.debug((Object)"Exiting the FileServiceServlet");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (ConfigUtility.getBoolean((String)KONY_SERVER_FILESERVICE_DISABLE, (boolean)false)) {
            response.sendError(404);
            return;
        }
        LOGGER.debug((Object)"Entering GET method of Servlet");
        String pathInfo = request.getPathInfo();
        LOGGER.debug((Object)("PathInfo is computed:" + pathInfo));
        String serviceNameSpace = request.getParameter("serviceNameSpace");
        String securityKey = request.getParameter("securityKey");
        if (pathInfo == null) {
            if (this.isNotAuthorizedRequest(request)) {
                LOGGER.error((Object)"The user doesn't have the permission to access the resource");
                response.sendError(403);
                return;
            }
            serviceNameSpace = EncryptDecryptText.getInstance().decryptText(serviceNameSpace);
            securityKey = EncryptDecryptText.getInstance().decryptText(securityKey);
        }
        String filePath = this.computeMountedPath() + FilePathComputationUtils.computeFilePathFromSvcAndOpn((String)serviceNameSpace, (String)securityKey);
        if (pathInfo != null && pathInfo.indexOf(LIST_ALL_FILES_ENDPOINT) != -1) {
            LOGGER.debug((Object)"Entering the listAllFiles flow");
            this.getListAllFiles(response, filePath);
            LOGGER.debug((Object)"Exiting the listAllFiles flow. Exiting the FileServiceServlet");
            return;
        }
        LOGGER.debug((Object)"Entering downloadBinary Flow");
        String fileNameWithExtension = EncryptDecryptText.getInstance().decryptText(request.getParameter("fileNameWithExtension"));
        if (StringUtils.isBlank((String)fileNameWithExtension)) {
            LOGGER.error((Object)"The file name cannot be null");
            this.sendResponseBack(response, "Filename cannot be null or empty", 400);
            LOGGER.debug((Object)"Exiting the FileServiceServlet");
            return;
        }
        filePath = filePath + fileNameWithExtension;
        try {
            response.setContentType("application/octet-stream");
            this.getFileServiceAdapterInstance().downloadBinary(filePath, (OutputStream)response.getOutputStream());
        }
        catch (FileServiceDataAdapterException e) {
            LOGGER.error((Object)e, (Throwable)e);
            this.sendResponseBackUsingOutputStream(response, e.getErrorMessage(), e.getHttpStatusCode());
        }
        LOGGER.debug((Object)"Exiting the FileServiceServlet");
    }

    private synchronized FileServiceAdapterImpl getFileServiceAdapterInstance() {
        if (this.adapter == null) {
            this.adapter = new FileServiceAdapterImpl();
        }
        return this.adapter;
    }

    private void getListAllFiles(HttpServletResponse response, String filePath) throws IOException {
        List entities;
        try {
            entities = this.getFileServiceAdapterInstance().listAllFileEntities(filePath);
        }
        catch (FileServiceDataAdapterException e) {
            this.sendResponseBack(response, e.getErrorMessage(), e.getHttpStatusCode());
            return;
        }
        JSONArray listFiles = new JSONArray();
        for (int i = 0; i < entities.size(); ++i) {
            JSONObject file = new JSONObject();
            file.put("Name", (Object)((FileEntity)entities.get(i)).getName());
            file.put("Type", (Object)((FileEntity)entities.get(i)).getType().getName());
            file.put("LastUpdatedTime", (Object)((FileEntity)entities.get(i)).getLastUpdatedDate());
            file.put("SizeInBytes", (Object)((FileEntity)entities.get(i)).getSizeInBytes());
            listFiles.put((Object)file);
        }
        JSONObject responseObj = new JSONObject();
        responseObj.put("Number Of Files", entities.size());
        responseObj.put("files", (Object)listFiles);
        this.sendResponseBack(response, responseObj, 200);
    }

    private void sendResponseBack(HttpServletResponse response, String message, int status) throws IOException {
        JSONObject responseObj = new JSONObject();
        responseObj.put("message", (Object)message);
        this.sendResponseBack(response, responseObj, status);
    }

    private void sendResponseBack(HttpServletResponse response, JSONObject responseObj, int status) throws IOException {
        response.setStatus(status);
        response.setContentType("application/json");
        response.getWriter().write(responseObj.toString());
    }

    private void sendResponseBackUsingOutputStream(HttpServletResponse response, String message, int status) throws IOException {
        response.setStatus(status);
        response.setContentType("application/json");
        JSONObject responseObj = new JSONObject();
        responseObj.put("message", (Object)message);
        response.getOutputStream().write(responseObj.toString().getBytes());
    }

    private boolean isNotAuthorizedRequest(HttpServletRequest request) {
        String puidBeforeDecryption = request.getHeader(ACCESS_TOKEN);
        String puidAfterDecryption = EncryptDecryptText.getInstance().decryptText(puidBeforeDecryption);
        String claimsToken = request.getHeader("X-Kony-Authorization");
        String puidFromClaimsToken = DataAdapterUtil.getPuidFromClaimsToken(claimsToken);
        return !StringUtils.isNotBlank((String)puidFromClaimsToken) || !puidFromClaimsToken.equals(puidAfterDecryption);
    }

    private String computeMountedPath() {
        String mountedPath = ConfigUtility.getProperty((String)ROOT_DIRECTORY_KEY);
        if (mountedPath == null) {
            mountedPath = "";
        } else if (!mountedPath.endsWith("//")) {
            mountedPath = mountedPath + "//";
        }
        return mountedPath;
    }
}

