/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.servlet;

import com.kony.adapter.criteria.Criteria;
import com.kony.adapter.criteria.Filter;
import com.kony.adapter.criteria.IFilter;
import com.kony.adapter.exception.DataAdapterException;
import com.kony.adapter.util.criteria.CriteriaBuilder;
import com.kony.adapter.util.criteria.CriteriaBuilderFactory;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.appservices.common.dataaccess.exception.DataAccessException;
import com.konylabs.middleware.appservices.common.helper.AfnServletHelper;
import com.konylabs.middleware.appservices.servlet.RequestExecutor;
import com.konylabs.middleware.datasourcelogs.DeviceResponseData;
import com.konylabs.middleware.datasourcelogs.DiagnosticLogService;
import com.konylabs.middleware.exceptions.ObjectServicesException;
import com.konylabs.middleware.metrics.MetricsBean;
import com.konylabs.middleware.request.builder.ObjectServiceRequestData;
import com.konylabs.middleware.utilities.EncodeUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MetadataRequestExecutor
implements RequestExecutor {
    private static final Logger LOGGER = Logger.getLogger(MetadataRequestExecutor.class);
    private static MetadataRequestExecutor requestExecutor = null;

    public static MetadataRequestExecutor getInstance() {
        if (requestExecutor == null) {
            requestExecutor = new MetadataRequestExecutor();
        }
        return requestExecutor;
    }

    @Override
    public void executeRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            PrintWriter out = response.getWriter();
            ObjectServiceRequestData requestData = (ObjectServiceRequestData)request.getAttribute("requestdata");
            AppVersion appVersion = requestData.getAppVersion();
            String objectName = requestData.getObjectId();
            Map<String, String> queryParamMap = requestData.getQueryParamMap();
            String metadata = null;
            String odataString = queryParamMap.get("$filter");
            MetricsBean metricsBean = (MetricsBean)request.getAttribute("metricsBean");
            if (metricsBean != null) {
                String apiVersion = (String)requestData.getCustomParam("X-Kony-Service-Version");
                metricsBean.addParam("rver", (Object)apiVersion);
                if (StringUtils.isEmpty((String)apiVersion)) {
                    apiVersion = MiddlewareUtils.getRuntimeVersion(requestData.getAppMetadata().getAppCache(), request.getParameter("appID"));
                }
                metricsBean.addParam("svcver", (Object)apiVersion);
                metricsBean.addParam("httpStatusCode", (Object)200);
            }
            if (StringUtils.isEmpty((String)odataString) || "1.0".equals(requestData.getCustomParam("X-Kony-Service-Version"))) {
                metadata = AfnServletHelper.performGetMetadata(requestData, request.getRequestURI());
            } else {
                String encodedValue = EncodeUtils.encode((String)odataString);
                odataString = "$filter=" + encodedValue;
                Criteria criteria = this.getCriteriaFromOdataString(odataString);
                String timestamp = this.getTimestampFromCriteria(criteria);
                metadata = AfnServletHelper.performGetIncrementalMetadata(appVersion, timestamp, objectName, requestData);
            }
            DeviceResponseData deviceResponseData = (DeviceResponseData)request.getAttribute("DeviceResLogBean");
            deviceResponseData.setBody(DiagnosticLogService.convertToJSONQuietly(metadata));
            DiagnosticLogService.logDeviceResponseData((DeviceResponseData)request.getAttribute("DeviceResLogBean"));
            out.print(metadata);
        }
        catch (DataAccessException e) {
            ServletException servletException = new ServletException((Throwable)e);
            throw servletException;
        }
        catch (ObjectServicesException e) {
            ServletException servletException = new ServletException(e.getMessage());
            throw servletException;
        }
        catch (Throwable t) {
            LOGGER.error((Object)"Error occurred in getMetadata ", t);
            DataAccessException dae = new DataAccessException(t);
            ServletException servletException = new ServletException((Throwable)dae);
            throw servletException;
        }
    }

    private Criteria getCriteriaFromOdataString(String sbCriteria) throws DataAdapterException {
        CriteriaBuilder criteriaBuilder = CriteriaBuilderFactory.create((String)sbCriteria);
        return criteriaBuilder.getCriteria();
    }

    private String getTimestampFromCriteria(Criteria criteria) {
        List filtersList = criteria.getFilters();
        for (int i = 0; i < filtersList.size(); ++i) {
            IFilter filter = (IFilter)filtersList.get(i);
            if (!(filter instanceof Filter)) continue;
            Filter timeStampFilter = (Filter)filter;
            String filterType = timeStampFilter.getFilterType().toString();
            if (!"timestamp".equalsIgnoreCase(timeStampFilter.getFilterKey().toString()) || !"eq".equalsIgnoreCase(filterType)) continue;
            return timeStampFilter.getFilterValue().toString();
        }
        return null;
    }
}

