/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.appservices.servlet;

import com.konylabs.middleware.appservices.servlet.ObjectRequestExecAsyncHandler;
import com.konylabs.middleware.appservices.servlet.RequestExecutor;
import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.request.builder.InputPayloadMetadata;
import com.konylabs.middleware.request.builder.ObjectServiceRequestData;
import com.konylabs.middleware.request.parser.RequestData;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ObjectRequestExecutor
implements RequestExecutor {
    private static final Logger LOGGER = Logger.getLogger(ObjectRequestExecutor.class);
    private static ObjectRequestExecutor requestExecutor = null;
    private static final ObjectRequestExecAsyncHandler objectRequestAsyncHandler = new ObjectRequestExecAsyncHandler();

    public static ObjectRequestExecutor getInstance() {
        if (requestExecutor == null) {
            requestExecutor = new ObjectRequestExecutor();
        }
        return requestExecutor;
    }

    @Override
    public void executeRequest(HttpServletRequest requestWrapper, HttpServletResponse resp) throws ServletException {
        ObjectServiceRequestData requestData = (ObjectServiceRequestData)requestWrapper.getAttribute("requestdata");
        ServletException[] exception = new ServletException[1];
        CountDownLatch latch = new CountDownLatch(1);
        Context context = this.getContext(requestData, exception, latch);
        try {
            InputPayloadMetadata payloadMetadata = requestData.getInputPayloadMetadata();
            payloadMetadata.setHttpServletRequest(requestWrapper);
            payloadMetadata.setHttpServletResponse(resp);
            payloadMetadata.setRequestData(requestData);
            requestData.getRequestProcessingStrategy().process(payloadMetadata, context);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        this.waitForResults(latch);
        if (exception[0] != null) {
            LOGGER.error((Object)"caught error ", (Throwable)exception[0]);
            throw exception[0];
        }
    }

    protected Context getContext(RequestData requestData, ServletException[] exception, CountDownLatch latch) {
        Context context = new Context();
        context.put("exception", (Object)exception);
        context.put("latch", (Object)latch);
        context.put("handler", (Object)objectRequestAsyncHandler);
        context.put("appMetadata", (Object)requestData.getAppMetadata());
        return context;
    }

    protected void waitForResults(CountDownLatch latch) {
        LOGGER.debug((Object)"Submitted the operation and waiting for results.");
        try {
            latch.await(5L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Failed executing the operation", (Throwable)e);
        }
    }
}

