/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.asset;

import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.asset.AssetManager;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterCache;
import com.konylabs.middleware.registry.ModifiableAppCache;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.nio.charset.StandardCharsets;
import org.apache.log4j.Logger;

abstract class AbstractAssetManager
implements AssetManager {
    private static final Logger LOGGER = Logger.getLogger(AbstractAssetManager.class);

    AbstractAssetManager() {
    }

    @Override
    public final void loadAsset(String assetName, AppVersion appIdVersion, byte[] assetData, ModifiableAppCache appCache, DataAdapterCache dataAdapterCache) {
        try {
            this.loadAssetCore(assetName, appIdVersion, assetData, appCache, dataAdapterCache);
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Failed to load asset: " + assetName), (Throwable)ex);
        }
    }

    @Override
    public void clearAssetCache(ModifiableAppCache appCache, AppVersion appVersion) {
    }

    @Override
    public final boolean isLoadingSupported() {
        return !TenantUtilities.isMultiTenant() || this.isMultiTenantSupported();
    }

    protected boolean isMultiTenantSupported() {
        return false;
    }

    protected String byteToString(byte[] assetData) {
        return new String(assetData, StandardCharsets.UTF_8);
    }

    protected abstract void loadAssetCore(String var1, AppVersion var2, byte[] var3, ModifiableAppCache var4, DataAdapterCache var5) throws Exception;
}

