/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.asset;

import com.konylabs.middleware.asset.AssetManager;
import com.konylabs.middleware.asset.DataAdapterAssetManager;
import com.konylabs.middleware.asset.JavaScriptAssetManager;
import com.konylabs.middleware.asset.SAPJcoAssetManager;
import com.konylabs.middleware.asset.ScrapperAssetManager;
import com.konylabs.middleware.asset.StubConnectorAssetManager;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;

public class AssetType {
    public static final AssetType JAVASCRIPT = new AssetType("JS", true, JavaScriptAssetManager::new);
    public static final AssetType SCRAPPER = new AssetType("DSL", false, ScrapperAssetManager::new);
    public static final AssetType SAPJCO = new AssetType("SAPJCO", false, SAPJcoAssetManager::new);
    public static final AssetType FLYWAY = new AssetType("FLYWAY", false, null);
    public static final AssetType STUB = new AssetType("STUB", false, StubConnectorAssetManager::new);
    private static final Map<String, AssetType> ALL = AssetType.initAllAssetTypes();
    private final String type;
    private final boolean isShared;
    private final Supplier<AssetManager> assetManagerSupplier;

    private AssetType(String type, boolean isShared, Supplier<AssetManager> assetManagerSupplier) {
        this.type = type;
        this.isShared = isShared;
        this.assetManagerSupplier = assetManagerSupplier;
    }

    public String getType() {
        return this.type;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public boolean isDataAdapterType() {
        return !ALL.containsKey(this.getType());
    }

    public String toString() {
        return this.getType();
    }

    public static AssetType getByType(String assetType) {
        return ALL.containsKey(assetType) ? ALL.get(assetType) : AssetType.getDataAdapterType(assetType);
    }

    public static AssetManager getAssetManager(String assetType) {
        AssetType assetTypeEnum = AssetType.getByType(assetType);
        return assetTypeEnum.assetManagerSupplier != null ? assetTypeEnum.assetManagerSupplier.get() : new DataAdapterAssetManager(assetType);
    }

    private static Map<String, AssetType> initAllAssetTypes() {
        TreeMap<String, AssetType> all = new TreeMap<String, AssetType>(String.CASE_INSENSITIVE_ORDER);
        for (AssetType assetType : new AssetType[]{JAVASCRIPT, SCRAPPER, SAPJCO, FLYWAY, STUB}) {
            all.put(assetType.getType(), assetType);
        }
        return all;
    }

    private static AssetType getDataAdapterType(String type) {
        return new AssetType(type, true, null);
    }
}

