/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.asset;

import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.asset.AbstractAssetManager;
import com.konylabs.middleware.asset.AssetUtil;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterCache;
import com.konylabs.middleware.registry.ModifiableAppCache;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;

class DataAdapterAssetManager
extends AbstractAssetManager {
    private final String assetType;

    public DataAdapterAssetManager(String assetType) {
        this.assetType = assetType;
    }

    @Override
    protected void loadAssetCore(String assetName, AppVersion appIdVersion, byte[] assetData, ModifiableAppCache appCache, DataAdapterCache dataAdapterCache) {
        ApplicationMetadata appMetadata = (ApplicationMetadata)appCache.getAppMetadata(appIdVersion);
        if (assetName.startsWith(appMetadata.getApplicationVersion().getAppId())) {
            String assetKey = AssetUtil.removeAssetPrefix(assetName, appMetadata.getApplicationVersion().getAppId(), appMetadata.getApplicationVersion().getVersion());
            appMetadata.putAsset(this.assetType, assetKey, assetData);
        } else {
            appCache.putSharedAsset(this.assetType, assetName, assetData);
        }
        dataAdapterCache.getUpdatedAssets().add(appMetadata.getApplicationVersion());
    }

    @Override
    public boolean isMultiTenantSupported() {
        return true;
    }
}

